#! /bin/sh
#
#  gen-mem.sh -- SHARP SC61860 (for Pocket/Portable Computer) Emulator
#	  	 make memory image
#
#	0.1: Oct. 15, 2016 by Dai ISHIJIMA
#

echo "mainram = new Array(65536);"
echo 'for (i = 0; i < 65536; i++) {'
echo '	mainram[i] = 0;'
echo '}'

ofs=0
while [ $ofs -lt 8192 ]; do
	echo "workmem = new Array("
	hd -v -n 4096 -s $ofs cpu-1450.rom |
	awk '(NF > 17) {
		printf "\t/* %4.4s */\n\t", substr($1, 5, 4)
		for (i = 0; i < 8; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n\t"
		for (i = 8; i < 16; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n"
	}'
	echo "	-1);"
	echo 'for (i = 0; i < 4096; i++) {'
	echo "	mainram[i + $ofs] = workmem[i];"
	echo '}'
	ofs=$(( $ofs + 4096 ))
done

ofs=0
while [ $ofs -lt 32768 ]; do
	echo "workmem = new Array("
	hd -v -n 4096 -s $ofs bas-1450.rom |
	awk '(NF > 17) {
		printf "\t/* %4.4s */\n\t", substr($1, 5, 4)
		for (i = 0; i < 8; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n\t"
		for (i = 8; i < 16; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n"
	}'
	echo "	-1);"
	echo 'for (i = 0; i < 4096; i++) {'
	echo "	mainram[i + $ofs + 0x8000] = workmem[i];"
	echo '}'
	ofs=$(( $ofs + 4096 ))
done

# EOF
