/*
 *  keyboard.js -- SHARP SC61860 (for Pocket/Portable Computer) Emulator
 *		   JavaScript version - keyboard part
 *
 *  Original C Language version: Copyright (C) 1994-2016 by Dai ISHIJIMA
 *	0.1: Oct.  3, 1995 by Dai ISHIJIMA
 *	0.2: May   1, 2014 (ina/keyscan/termios improvement)
 *	0.3: Jan.  4, 2016 (FreeBSD/Linux/MacOSX)
 *
 *  JavaScript version:
 *	0.0: Jan. 24, 2016
 *	0.1: Jan. 30, 2016
 */

var keym = new Array();
var NKEYM = 128;
var KEYNM = 14;
var kon = 0;

var KNUL = '\x7f';
var ENTER = '\x0a';
var KEOF = '\xff';
var KANA = 'K';
var TEN= ':';
var CHON = '_';
var KDN = '{';
var KUP = '}';
var KCLR = '@';
var KLA = '[';
var KRA = ']';
var KBRK = '!';

/* #&@OV_!J */


var scandef = new Array (
/*	+0	+1	+2	+3	+4	+5	+6	+7   */
	'7',	'8',	'9',	'/',	'>',	KNUL,	KNUL,	KNUL,
	'4',	'5',	'6',	'*',	'<',	'U',	'D',	'M',
	'1',	'2',	'3',	'-',	'P',	'q',	'a',	'z',
	'0',	'%',	'.',	'+',	'=',	'w',	's',	'x',
	'H',	'S',	'C',	'T',	'K',	'e',	'd',	'c',
	'X',	'G',	'N',	'L',	':',	'r',	'f',	'v',
	'E',	'^',	'R',	'Q',	'_',	't',	'g',	'b',
	KNUL,	KCLR,	'|',	'F',	KDN,	'y',	'h',	'n',
	KNUL,	KNUL,	')',	'I',	KUP,	'u',	'j',	'm',
	KNUL,	KNUL,	KNUL,	'(',	KLA,	'i',	'k',	' ',
	KNUL,	KNUL,	KNUL,	KNUL,	KRA,	'o',	'l',	ENTER,
	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	'p',	',',	'B',
	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	'Z',	'A',
	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	KNUL,	KEOF
);


function keyinit() {
	var i;

	for (i = 0; i < KEYNM; i++) {
		keym[i] = 0;
	}
	//alert('key initialized');
}


function keyclear() {
	var i;

	for (i = 0; i < KEYNM; i++) {
		keym[i] = 0;
	}
}

function keyscan(keychar) {
	var i = 0;
	var j = 0;

	kon = 0;
	for (i = 0; i < KEYNM; i++) {
		keym[i] = 0;
	}
	if (keychar.length <= 0) {
		return;
	}
	for (i = 0; i < KEYNM; i++) {
		for (j = 0; j < 8; j++) {
			if (keychar == scandef[i * 8 + j]) {
				keym[i] = (1 << j);
				break;
			}
		}
		if (keym[i] != 0) {
//			alert('key scan ' + keym[i] + ' at ' + i);
			break;
		}
	}
	if (keychar == KBRK) {
		kon = 1;
	}
}


function kbdcheck() {
	var f = document.forms[0];

	return(f.keybuf.value.length);
}


function ttyin() {
	var keychar;
	var f = document.forms[0];
	var keystr;

	keychar = '';
	keystr = f.keybuf.value;
	if (keystr.length > 0) {
		keychar = keystr.substr(0, 1);
		f.keybuf.value = keystr.substr(1, keystr.length - 1);
	}
	return(keychar);
}

/* EOF */
