/*
 *  display.js -- SHARP SC61860 (for Pocket/Portable Computer) Emulator
 *		  JavaScript version - display part
 *
 *  Original C Language version: Copyright (C) 1994-2016 by Dai ISHIJIMA
 *	0.1: Oct.  3, 1995 by Dai ISHIJIMA
 *	0.2: May   1, 2014 (ina/keyscan/termios improvement)
 *	0.3: Jan.  4, 2016 (FreeBSD/Linux/MacOSX)
 *
 *  JavaScript version:
 *	0.0: Jan. 24, 2016
 *	0.1: Jan. 30, 2016
 */

var LCDCOLS = 16;
var XLCD = 5;
var YLCD = 7;
var LCDXMAX = (LCDCOLS * XLCD);

var LCD1 = 0x7000;
var LCD2 = 0x703c;
var LCD3 = 0x7068;
var LCD4 = 0x707c;
var LCDCOL1 = 12;

var LCDSYM1 = 0x703c;
var LCDSYM2 = 0x703d;
var LCDSYM3 = 0x707c;
var NUMSYM1 = 4; /* "KANA", "S/K", "SML", "STAT" */
var NUMSYM2 = 7; /* "BUSY", "DEF", "SHIFT", "HYP", "PRO", "RUN", "CAL" */
var NUMSYM3 = 7; /* "E", "M", "()", "RAD", "G", "DE", "PRINT" */

var ROMFONT = 0x806c;

var dispid;


function dispsymbols() {
	var bit;
	var byte;
	var i;
	var id;

	bit = 1;
	byte = memr(LCDSYM2);
	for (i = 0; i < NUMSYM2; i++) {
		id = "lcdsym2bit" + i;
		if ((byte & bit) != 0) {
			document.getElementById(id).style.color = "#101010";
		}
		else {
			document.getElementById(id).style.color = "#f0f0f0";
		}
		bit <<= 1;
	}
	bit = 1;
	byte = memr(LCDSYM1);
	for (i = 0; i < NUMSYM1; i++) {
		id = "lcdsym1bit" + i;
		if ((byte & bit) != 0) {
			document.getElementById(id).style.color = "#101010";
		}
		else {
			document.getElementById(id).style.color = "#f0f0f0";
		}
		bit <<= 1;
	}
	bit = 1;
	byte = memr(LCDSYM3);
	for (i = 0; i < NUMSYM3; i++) {
		id = "lcdsym3bit" + i;
		if ((byte & bit) != 0) {
			document.getElementById(id).style.color = "#101010";
		}
		else {
			document.getElementById(id).style.color = "#f0f0f0";
		}
		bit <<= 1;
	}
}


function x2addr(x) {
	if (x < (LCD2 - LCD1)) {
		return(LCD1 + x);	// 0x7000-
	}
	if (x < LCDXMAX) {
		return((LCDXMAX - x) + LCD3 - 1);		// 0x7068-
	}
	alert('Invalid LDC x value: ' + x);
	return(LCD1);
}


function x2char(x) {
	return(Math.floor(x / XLCD));
}


function lcdpos2id(x, y) {
	var c;
	var cc;
	var xx;
	var yy;
	var id = "L0C0";

	c = x2char(x);
	x = x - XLCD * c;
	cc = "00" + c.toString(16);
	xx = "00" + x.toString(16);
	yy = "00" + y.toString(16);
	id = "L0C0" + cc.substr(cc.length - 1, 1)
	   + "P" + xx.substr(xx.length - 1, 1)
	   + "B" + yy.substr(xx.length - 1, 1)
	   ;
	return(id);
}


function dispmatrix() {
	var x;
	var y;
	var bit;
	var id;
	var byte;

	for (x = 0; x < LCDXMAX; x++) {
		byte = memr(x2addr(x));
		bit = 1;
		for (y = 0; y < YLCD; y++) {
			id = lcdpos2id(x, y);
			if ((byte & bit) != 0) {
				document.getElementById(id).style.color
					= "#101010";
			}
			else {
				document.getElementById(id).style.color
					= "#f0f0f0";
			}
			bit <<= 1;
		}
	}
}


function lcd2char(addr) {
	var i;
	var ch;

	for (ch = 0x20; ch < 0x7f; ch++) {
		for (i = 0; i < 5; i++) {
			if (memr(ROMFONT + (ch - 0x20) * 5 + (4 - i))
			!= memr(addr + i)) {
				break;
			}
		}
		if (i >= 5) {
			return(ch);
		}
	}
	return(0x20);
}


function lcd2char2(addr) {
	var i;
	var ch;

	for (ch = 0x20; ch < 0x7f; ch++) {
		for (i = 0; i < 5; i++) {
			if (memr(ROMFONT + (ch - 0x20) * 5 + i)
			!= memr(addr + i)) {
				break;
			}
		}
		if (i >= 5) {
			return(ch);
		}
	}
	return(0x20);
}


function lcd2str() {
	var i;
	var addr;
	var str;
	var f = document.forms[0];

	f.lcdstr.value = '';
	for (i = 0; i < 12; i++) {
		addr = 5 * i + LCD1;
		f.lcdstr.value += String.fromCharCode(lcd2char(addr));
	}
	for (i = 12; i < 16; i++) {
		addr = LCD4 + 5 * (11 - i);
		f.lcdstr.value += String.fromCharCode(lcd2char2(addr));
	}
}


function disploop() {
	dispmatrix();
	dispsymbols();
	lcd2str();
	dispid = setTimeout("disploop()", 50);
}

/* EOF */
