#! /bin/sh
#
#  gen-ramjs.sh -- SHARP SC61860 (for Pocket/Portable Computer) Emulator
#	  	 make memory image (BASIC RAM)
#
#	0.1: Oct. 15, 2016 by Dai ISHIJIMA (ROM)
#	0.1: Jan.  6, 2021 (RAM)
#
#	sh gen-ramjs.sh > ram.js

echo 'function ramcard() {'
echo '	var i;'

ofs=0
while [ $ofs -lt 16384 ]; do
	echo "workmem = new Array("
	hd -v -n 4096 -s $ofs bas-1450.ram |
	awk '(NF > 17) {
		printf "\t/* %4.4s */\n\t", substr($1, 5, 4)
		for (i = 0; i < 8; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n\t"
		for (i = 8; i < 16; i++) {
			printf "0x%2.2s, ", $(i + 2)
		}
		printf "\n"
	}'
	echo "	-1);"
	echo 'for (i = 0; i < 4096; i++) {'
	echo "	mainram[i + $ofs + 0x2000] = workmem[i];"
	echo '}'
	ofs=$(( $ofs + 4096 ))
done

echo '}'

# EOF
