#! /bin/sh

stuffs="${1:-fz}"
disk="${2:-ad0}"

dmesg=/var/run/dmesg.boot
dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`diskinfo -B /dev/r$disk`

nstuff=0
msg=''
for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	case x"$stuff" in
		x[0z])	msg="${msg}0," ;;
		x[1f])	msg="${msg}1," ;;
		x[Rr])	msg="${msg}R," ;;
	esac
	nstuff=`expr $nstuff + 1`
done
msg=`echo $msg | sed 's/,$//'`

echo ''; echo ''; echo ''
echo "*** erase data on ${disk} ${dname}, ${bytes} bytes"
echo "    with writing $nstuff times ($msg)  "

echo -n "Ok? [y/n]: "
read ans
case x"$ans" in
	xy)	;;
	*)	echo 'canceled'; exit 1;;
esac

echo -n "Really? [yes/no]: "
read ans
case x"$ans" in
	xyes)	;;
	*)	echo 'canceled'; exit 1;;
esac


# õΥѥ᡼
bytes=`diskinfo -b /dev/r$disk`
obs=`expr 1024 '*' 1024`
ibs=1024
icnt=32768
ocnt=32
max=`expr '(' $bytes + $obs - 1 ')' / $obs`

#
echo ''

spc='                                                                        '
n=0
while [ $n -lt 18 ] ; do
	echo ''
	n=`expr $n + 1`
done
echo -n '[18A'
echo -n '7'

stage=0
xstage=1
startsec=`tinydate '+%s'`
totalrems='??? [min]'

for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	skip=0
	stagestart=`tinydate '+%s'`
	case "$stuff" in
		[0z]) method="'0'" ;;
		[1f]) method="'1'" ;;
		[Rr]) method="random data" ;;
	esac
	rems='??? [min]'
	skip=0
	echo -n '8'
	echo -n '7'
	n=0
	while [ $n -lt 18 ] ; do
		echo "$spc"
		n=`expr $n + 1`
	done
	while [ $skip -le $max ]; do
		# 
		echo -n '8'
		echo -n '7'
		# ׻
		cursec=`tinydate '+%s'`
		# С
		p=`expr 100 '*' $skip / $max`
		m=`expr 1000 '*' $skip / $max`
		q=`expr $p / 2`
		i=0
		bar=''
		while [ $i -lt $q ]; do
			bar="$bar"'#'
			i=`expr $i + 1`
		done
		while [ $i -lt 50 ]; do
			bar="$bar"'_'
			i=`expr $i + 1`
		done
		#
		# Ĥ
		elapsed=`expr $cursec - $stagestart`
		if [ $m -gt 0 ]; then
			remain=`expr '(' 1000 - $m ')' '*' $elapsed / $m + 1`
			if [ $remain -gt 120 ]; then
				rems=`expr '(' $remain + 59 ')' / 60`
				rems="${rems} [min]"
			else
				rems="${remain} [sec]"
			fi
		fi
		if [ $elapsed -gt 120 ]; then
			elas=`expr '(' $elapsed + 30 ')' / 60`
			elas="${elas} [min]"
		else
			elas="${elapsed} [sec]"
		fi
		#
		# ΥС
		pp=`expr '(' $p + 100 '*' $stage ')' / $nstuff`
		mm=`expr '(' $m + 1000 '*' $stage ')' / $nstuff`
		q=`expr $pp / 2`
		i=0
		totalbar=''
		while [ $i -lt $q ]; do
			totalbar="$totalbar"'#'
			i=`expr $i + 1`
		done
		while [ $i -lt 50 ]; do
			totalbar="$totalbar"'_'
			i=`expr $i + 1`
		done
		ee=`expr $cursec - $startsec`
		if [ $mm -gt 0 ]; then
			rr=`expr '(' 1000 - $mm ')' '*' $ee / $mm + 1`
			if [ $rr -gt 120 ]; then
				totalrems=`expr '(' $rr + 59 ')' / 60`
				totalrems="${totalrems} [min]"
			else
				totalrems="${rr} [sec]"
			fi
		fi
		if [ $ee -gt 120 ]; then
			totalelas=`expr '(' $ee + 30 ')' / 60`
			totalelas="${totalelas} [min]"
		else
			totalelas="${ee} [sec]"
		fi
		#

		echo "erasing data on disk: ${disk}."
		echo "stage ${xstage} of ${nstuff}, ${pp}% done   "
		echo "${totalelas} elapsed, ${totalrems} remains (approx.)   "
		echo ''
		echo "    0%|${totalbar}|100%"
		echo ''
		echo "now writing ${method} onto the disk.  ${p}% done   "
		echo "${elas} elapsed, ${rems} remains (approx.)   "
		echo ''
		echo "    0%|${bar}|100%"
		echo ''
		case x$DEBUG in
			x[Yy]*)
				echo 'now in debug mode...'
				sleep 1
				;;
			*)
				stuff -$stuff | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/r$disk
				;;
		esac
		# 롼
		skip=`expr $skip + $ocnt`
	done
	stage=`expr $stage + 1`
	xstage=`expr $xstage + 1`
done

echo ''; echo ''; echo ''; echo ''; echo ''

cursec=`tinydate '+%s'`
elapsed=`expr $cursec - $startsec`
if [ $elapsed -gt 120 ]; then
	min=`expr $elapsed / 60`
	sec=`expr $elapsed - $min '*' 60`
	elas="${min} [min] ${sec} [sec]"
else
	elas="${elapsed} [sec]"
fi

echo "completed ($elas)"
echo ''
echo -n 'Press ENTER to return menu...'
read x

exit 0

# EOF
