/*
 *  stuff -- ϡɥǥõΤεͤʪǡ
 *
 *  revision history:
 *	0.0:	Apr. 30, 2004 by Dai ISHIJIMA
 *	0.1:	May   1, 2004
 *	0.2:	Jun. 28, 2006 (ѥȤ)
 */

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>

#define BSIZ 1024
#define STDIN 0
#define STDOUT 1
#define STDERR 2

#define NEWLINE '\n'

#define ZERO 'z'
#define FILL 'f'
#define RAND 'r'
#define GENERATE 'g'
#define PATTERN  'p'
#define INVERT   'q'

#define shift --argc; ++argv


#define swap(t,a,b) {t _swap_tmp; _swap_tmp=(a); a=b; b=_swap_tmp;}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


/* ǥǡ򤫤ޤ */
void stair(int len, unsigned char *buf)
{
    int i, n;

    for (i = 0; i < len; i++) {
	n = random() & (len - 1);		/* len  2^n Ȳ */
	swap(unsigned char, buf[i], buf[n]);
    }
}


/* 񤭹ѥǡν */
void init(int len, unsigned char *buf, int mode)
{
    int i;

    if (mode == ZERO) {
	for (i = 0; i < len; i++) {
	    buf[i] = 0;
	}
    }
    else if (mode == FILL) {
	for (i = 0; i < len; i++) {
	    buf[i] = 0xff;
	}
    }
    else if ((mode == RAND) || (mode == GENERATE)) {
	srandom(time(NULL));
	for (i = 0; i < len; i++) {
	    buf[i] = i;
	}
	stair(len, buf);
    }
    else if (mode == PATTERN) {
	read(STDIN, buf, BSIZ);
    }
    else if (mode == INVERT) {
	read(STDIN, buf, BSIZ);
	for (i = 0; i < len; i++) {
	    buf[i] = ~buf[i];
	}
    }
    else {
	/* ˤʤϤ */
	myputs(STDERR, "stuff: unknown mode: ");
	putch(STDERR, mode);
	putch(STDERR, NEWLINE);
	exit(1);
    }
}


/* ޥɥ饤˴Ťơ0, 1, ǡ */    
int main(int argc, char *argv[])
{
    int mode;
    unsigned char buf[BSIZ];

    mode = ZERO;
    shift;
    while ((argc > 0) && (argv[0][0] == '-')) {
	if ((argv[0][1] == '0') || (argv[0][1] == 'z')) {
	    /* 0  */
	    mode = ZERO;
	}
	else if ((argv[0][1] == '1') || (argv[0][1] == 'f')) {
	    /* 1  */
	    mode = FILL;
	}
	else if ((argv[0][1] == 'R') || (argv[0][1] == 'r')) {
	    /* ǡ */
	    mode = RAND;
	}
	else if ((argv[0][1] == 'G') || (argv[0][1] == 'g')) {
	    /* ѥ */
	    mode = GENERATE;
	}
	else if ((argv[0][1] == 'P') || (argv[0][1] == 'p')) {
	    /* ѥ򷫤֤ */
	    mode = PATTERN;
	}
	else if ((argv[0][1] == 'Q') || (argv[0][1] == 'q')) {
	    /* ѥ򷫤֤ */
	    mode = INVERT;
	}
	else {
	    myputs(STDERR, "Usage: stuff [-[01Rzfrgpq]]\n");
	    exit(1);
	}
	shift;
    }
    if (argc > 0) {
	myputs(STDERR, "Usage: stuff [-[01Rzfrgpq]]\n");
	exit(1);
    }
    init(BSIZ, buf, mode);
    if (mode == GENERATE) {
	write(STDOUT, buf, BSIZ);
    }
    else {
	for (;;) {
	    if (mode == RAND) {
		stair(BSIZ, buf);
	    }
	    write(STDOUT, buf, BSIZ);
	}
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -s -static -o stuff stuff.c" */
/* End: */
