#! /bin/sh
#
#   mainmenu.sh -- ϡɥǥõġᥤ
#

dmesg=/var/run/dmesg.boot
resultfil=/tmp/result
disks=`sed -n -E '/^(da|ad)[0-9]:.*</p' $dmesg | sed 's/^\(...\).*/\1/'`
set $disks
disk=$1
stuffs='10'
dumpskip=0

while true ; do
	dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`diskinfo -B /dev/r$disk`
	cap=`diskinfo -p /dev/r$disk`

	echo '*** Hard Disk wiping tool "wipe-out" ***'
	echo ''
	echo "current disk: /dev/${disk} ${dname}"
	echo "    capacity: $bytes bytes ($cap)"
	echo ''
	echo '    0: write "0" onto the disk'
	echo '    1: write "1" onto the disk'
	echo '    2: write random data onto the disk'
	echo '    3: select disk'
	echo '    4: erase data with muliple writing'
	echo '    5: select multi-write method'
	echo '    6: verify disk (quick)'
	echo '    7: verify disk (normal)'
	echo '    8: dump sector'
	echo '    9: set sector number to dump'
	echo '    a: run shell (sh)'
	echo '    b: reboot'
	echo '    c: shutdown'
	echo ''
	echo -n 'enter number [0-9a-c]: '
	read ans

	case x"${ans}" in
		x0)
			sh erase.sh -z $disk
			;;
		x1)
			sh erase.sh -f $disk
			;;
		x2)
			sh erase.sh -r $disk
			;;
		x3)
			. seldisk.sh
			;;
		x4)
			sh fine-erase.sh $stuffs $disk
			;;
		x5)
			. sel-fine.sh
			;;
		x6)
			sh verify.sh 90 $disk
			;;
		x7)
			sh verify.sh 0 $disk
			;;
		x8)
			echo ''
			echo "*** sector $dumpskip of disk $disk"
			dd if=/dev/r$disk skip=$dumpskip count=1 2>/dev/null | tinydump
			dumpskip=`expr $dumpskip + 1`
			echo -n "Press ENTER to return menu"
			read enterkey
			;;
		x9)
			echo ''
			echo -n "Enter sector number [$dumpskip] :"
			read sector
			echo "$sector" > /tmp/sector
			echo "$dumpskip" >> /tmp/sector
			dumpskip=`sed -n '/^[0-9]/p' /tmp/sector | sed -n 1p`
			;;
		xa)
			/bin/sh -i
			;;
		xb)
			/sbin/init 6
			;;
		xc)
			/sbin/init 0
			;;
	esac
	echo ''; echo ''; echo ''
done

exit 0

# EOF
