/*
 *  check -- ǡõƤ뤫Ĵ٤
 *
 *  revision history:
 *	0.0: Oct. 26, 2001 by Dai ISHIJIMA
 *	0.1: May   1, 2004
 *	0.2: Jul.  7, 2005
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#define YES 1
#define NO  0

#define EOS '\0'

#ifndef BUFSIZ
#define BUFSIZ 512
#endif

#define ERROR	5
#define OK	0
#define ONE	1
#define NONZERO	2

#define shift --argc; ++argv


/* ͤʸѴ */
char *num2str(long long d, char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 10);
	++p;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


int main(int argc, char *argv[])
{
    char s[BUFSIZ];
    unsigned char buf[BUFSIZ];
    unsigned char last;
    int n;
    int i, j;
    int verbose = YES;

    shift;
    while ((argc > 0) && (argv[0][0] == '-')) {
	if (argv[0][1] == 'v') {
	    verbose = YES;
	}
	else if (argv[0][1] == 's') {
	    verbose = NO;
	}
	else {
	    myputs(STDERR_FILENO, "Usage: check [-v|-s]\n");
	    exit(1);
	}
	shift;
    }
    last = 0;
    i = 0;
    while ((n = read(STDIN_FILENO, buf, BUFSIZ)) > 0) {
	if ((i > 0) && (last != buf[0])) {
	    if (verbose) {
		myputs(STDOUT_FILENO, "not erased at ");
		num2str(i, s);
		myputs(STDOUT_FILENO, s);
		myputs(STDOUT_FILENO, "\n");
	    }
	    exit(ERROR);
	}
	++i;
	for (j = 1; j < n; j++) {
	    if (buf[j] != buf[j - 1]) {
		if (verbose) {
		    myputs(STDOUT_FILENO, "not erased at ");
		    num2str(i, s);
		    myputs(STDOUT_FILENO, s);
		    myputs(STDOUT_FILENO, "\n");
		}
		exit(ERROR);
	    }
	    ++i;
	}
	last = buf[n - 1];
    }
    if (verbose) {
	num2str(i, s);
	myputs(STDOUT_FILENO, s);
    }
    if (last == 0x00ff) {
	if (verbose) {
	    myputs(STDOUT_FILENO, " bytes erased with 1\n");
	}
	exit(ONE);
    }
    if (last != 0) {
	if (verbose) {
	    myputs(STDOUT_FILENO, " bytes may be erased, but not zero\n");
	}
	exit(NONZERO);
    }
    if (verbose) {
	myputs(STDOUT_FILENO, " bytes erased with 0\n");
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -static -o check check.c" */
/* End: */
