#! /bin/sh
#
#   erase.sh -- ǡ񤭤ƥǥΥǡõ
#
#	Ȥ: /bin/sh erase.sh -ä ǥ
#		ä: [zfr]
#		ǥ: ǥХեǻꡢƬΡ/dev/rפϾʤ
#		: /bin/sh erase.sh -z ad0
#
#	0.0: Jun. 20, 2004 by Dai ISHIJIMA (for wpout03)
#	0.1: Jul. 11, 2004
#	0.2: Jun. 28, 2006 (ѥ for wpout07)
#	0.3: Aug.  1, 2006 (ॹ)
#	0.4: Aug. 12, 2006 (ॹפ)
#

stuff="${1:--z}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# ٤32MХȤ
blklen="${BLKLEN:-33554432}"
# ϥ֥å1MХ
obs="${OBS:-1048576}"
ocnt=`expr $blklen / $obs`
# ϥ֥å1kХ
ibs="${IBS:-1024}"
icnt=`expr $blklen / $ibs`

if [ ! -w /dev/r$disk ]; then
	echo "$0: disk '$disk' does not exist or is not writable"
	echo "Usage: $0 -[z|f|r] disk"
	echo "Example: $0 -z ad0"
	exit 1
fi

title="${TITLE:-ϡɥǥõġwipe-out}"

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`diskinfo -B /dev/r$disk`
cap=`diskinfo -p /dev/r$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"

case x"$stuff" in
	x-[0z])	msg="${msg}0Ǿ񤭤ƾõޤ\n"
		method='write 0'
		;;
	x-[1f])	msg="${msg}1Ǿ񤭤ƾõޤ\n"
		method='write 1'
		;;
	x-[Rr])	msg="${msg}ǡǾ񤭤ƾõޤ\n"
		method='write random'
		;;
	x-[Pp])	stuff -g > $PATTERNFIL
		msg="${msg}ѥǾ񤭤ƾõޤ\n"
		method='write pattern'
		;;
	x-[Qq])	msg="${msg}ľѥǾ񤭤ƾõޤ\n"
		method='write inverted pattern'
		;;
	*)	msg="${msg}õޤ\n"
		method='overwrite'
		;;
esac

msg="${msg}\n                      Ǥ?"

dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) ΥǡõƤǤ?"

dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

# õΥѥ᡼
bytes=`diskinfo -b /dev/r$disk`
max=`expr '(' $bytes + $obs - 1 ')' / $obs`

startsec=`tinydate '+%s'`
rems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

skip=0
while [ $skip -le $max ]; do
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=`expr 100 '*' $skip / $max`
	m=`expr 1000 '*' $skip / $max`
	q=`expr $p / 2`
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=`expr $i + 1`
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=`expr $i + 1`
	done
	# Ĥ
	elapsed=`expr $cursec - $startsec`
	if [ $m -gt 0 ]; then
		remain=`expr '(' 1000 - $m ')' '*' $elapsed / $m + 1`
		if [ $remain -gt 120 ]; then
			rems=`expr '(' $remain + 59 ')' / 60`
			rems="Ĥ 褽${rems}ʬ"
		else
			rems="Ĥ 褽${remain}"
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=`expr '(' $elapsed + 30 ')' / 60`
		elas="${elas}ʬ"
	else
		elas="${elapsed}"
	fi
	#
	text="ǥ ${disk} ΥǡõƤޤ"
	text="${text} ${p}% λ\n"
	text="${text}${elas} в  ${rems}  \n\n"
	text="${text}        0%|${bar}|100%"
	text="${text}\n${errormsg}"
	dialog --title "$title" --infobox "$text" 7 72
	echo -n "$status2"
	case x$DEBUG in
		x[Yy]*)
			status2='now in debug mode...'
			errormsg=''
			sleep 1
			;;
		*)
			status=`stuff $stuff < $PATTERNFIL | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/r$disk 2>&1`
			status2=`echo "$status" | sed -n '/transfer/p'`
			errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
			;;
	esac
	# 롼
	skip=`expr $skip + $ocnt`
done

sleep 2

cursec=`tinydate '+%s'`
elapsed=`expr $cursec - $startsec`
if [ $elapsed -gt 120 ]; then
	min=`expr $elapsed / 60`
	sec=`expr $elapsed - $min '*' 60`
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

# ¸
echo 'The contents of this storage device' > /tmp/erase-log.$disk
echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
echo -n 'were erased with ' >> /tmp/erase-log.$disk
echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
echo "Erased with '$method'" >> /tmp/erase-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk

echo "but NOT verified" > /tmp/verify-log.$disk

dialog	--title "$title" \
	--msgbox "ǥΥǡõλޤ (${elas})" 5 72

exit 0

# EOF
