#! /bin/sh
#
#   fine-erase.sh -- ʣ񤭹ߤǰ˥ǥΥǡõ
#
#	Ȥ: /bin/sh fine-erase.sh ä ǥ
#		ä: [0z1fRr]+
#		ǥ: ǥХեǻꡢƬΡ/dev/rפϾʤ
#		: /bin/sh fine-erase.sh 0101010 ad0
#
#	0.0: Jun. 27, 2004 by Dai ISHIJIMA
#	0.1: Jul. 11, 2004
#	0.2: Jun. 28, 2006
#	0.3: Aug.  1, 2006 (ॹ for wpout07)
#

stuffs="${1:-fz}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# ٤32MХȤ
blklen="${BLKLEN:-33554432}"
# ϥ֥å1MХ
obs="${OBS:-1048576}"
ocnt=`expr $blklen / $obs`
# ϥ֥å1kХ
ibs="${IBS:-1024}"
icnt=`expr $blklen / $ibs`

if [ ! -w /dev/r$disk ]; then
	echo "$0: disk '$disk' does not exist or is not writable"
	echo "Usage: $0 [0|1|R|z|f|r|P|Q]... disk"
	echo "Example: $0 R10R10 ad0"
	exit 1
fi

title="${TITLE:-ϡɥǥõġwipe-out}"

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`diskinfo -B /dev/r$disk`
cap=`diskinfo -p /dev/r$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"

nstuff=0
for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	case x"$stuff" in
		x[0z])	msg="${msg}0" ;;
		x[1f])	msg="${msg}1" ;;
		x[Rr])	msg="${msg}R" ;;
		x[Pp])	msg="${msg}P" ;;
		x[Qq])	msg="${msg}Q" ;;
	esac
	nstuff=`expr $nstuff + 1`
done

msg="${msg}ν\n${nstuff}񤭤ƾõޤ\n"
msg="${msg}\n                      Ǥ?"

dialog --title "$title" --yesno "$msg" 10 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) ΥǡõƤǤ?"

dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

# õΥѥ᡼
bytes=`diskinfo -b /dev/r$disk`
max=`expr '(' $bytes + $obs - 1 ')' / $obs`

stage=0
xstage=1
startsec=`tinydate '+%s'`
totalrems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	skip=0
	stagestart=`tinydate '+%s'`
	case "$stuff" in
		[0z])	method="'0'񤭤" ;;
		[1f])	method="'1'񤭤" ;;
		[Rr])	method="ǡ񤭤" ;;
		[Pp])	stuff -g > $PATTERNFIL
			method="ѥ񤭤" ;;
		[Qq])	method="ľѥ񤭤" ;;
	esac
	rems=''
	status=''
	status2=''
	errormsg=''
	while [ $skip -le $max ]; do
		# ׻
		cursec=`tinydate '+%s'`
		# С
		p=`expr 100 '*' $skip / $max`
		m=`expr 1000 '*' $skip / $max`
		q=`expr $p / 2`
		i=0
		bar=''
		while [ $i -lt $q ]; do
			bar="$bar"'#'
			i=`expr $i + 1`
		done
		while [ $i -lt 50 ]; do
			bar="$bar"'_'
			i=`expr $i + 1`
		done
		# Ĥ
		elapsed=`expr $cursec - $stagestart`
		if [ $m -gt 0 ]; then
			remain=`expr '(' 1000 - $m ')' '*' $elapsed / $m + 1`
			if [ $remain -gt 120 ]; then
				rems=`expr '(' $remain + 59 ')' / 60`
				rems="Ĥ 褽${rems}ʬ"
			else
				rems="Ĥ 褽${remain}"
			fi
		fi
		if [ $elapsed -gt 120 ]; then
			elas=`expr '(' $elapsed + 30 ')' / 60`
			elas="${elas}ʬ"
		else
			elas="${elapsed}"
		fi
		# ΥС
		pp=`expr '(' $p + 100 '*' $stage ')' / $nstuff`
		mm=`expr '(' $m + 1000 '*' $stage ')' / $nstuff`
		q=`expr $pp / 2`
		i=0
		totalbar=''
		while [ $i -lt $q ]; do
			totalbar="$totalbar"'#'
			i=`expr $i + 1`
		done
		while [ $i -lt 50 ]; do
			totalbar="$totalbar"'_'
			i=`expr $i + 1`
		done
		ee=`expr $cursec - $startsec`
		if [ $mm -gt 0 ]; then
			rr=`expr '(' 1000 - $mm ')' '*' $ee / $mm + 1`
			if [ $rr -gt 120 ]; then
				totalrems=`expr '(' $rr + 59 ')' / 60`
				totalrems="Ĥ 褽${totalrems}ʬ"
			else
				totalrems="Ĥ 褽${rr}"
			fi
		fi
		if [ $ee -gt 120 ]; then
			totalelas=`expr '(' $ee + 30 ')' / 60`
			totalelas="${totalelas}ʬ"
		else
			totalelas="${ee}"
		fi
		#
		text="ǥ ${disk} ΥǡõƤޤ\n\n"
		text="${text} ${nstuff}  ${xstage} ֤  "
		text="${text} Τ ${pp}% λ\n"
		text="${text}${totalelas} в  ${totalrems}  \n\n"
		text="${text}        0%|${totalbar}|100%\n\n"
		text="${text}ιǤ${method}ǡõƤޤ\n"
		text="${text}${p}% λ  "
		text="${text}${elas} в  ${rems}  \n\n"
		text="${text}        0%|${bar}|100%\n\n"
		text="${text}\n${errormsg}"
		dialog --title "$title" --infobox "$text" 15 72
		echo -n "$status2"
		case x$DEBUG in
			x[Yy]*)
				status2='now in debug mode...'
				errormsg=''
				sleep 1
				;;
			*)
				status=`stuff -$stuff < $PATTERNFIL | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/r$disk 2>&1`
				status2=`echo "$status" | sed -n '/transfer/p'`
				errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
				;;
		esac
		# 롼
		skip=`expr $skip + $ocnt`
	done
	stage=`expr $stage + 1`
	xstage=`expr $xstage + 1`
done

sleep 2

cursec=`tinydate '+%s'`
elapsed=`expr $cursec - $startsec`
if [ $elapsed -gt 120 ]; then
	min=`expr $elapsed / 60`
	sec=`expr $elapsed - $min '*' 60`
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

# ¸
echo 'The contents of this storage device' > /tmp/erase-log.$disk
echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
echo -n 'were erased with ' >> /tmp/erase-log.$disk
echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
echo "Erase $nstuff times ($stuffs)" >> /tmp/erase-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk

echo "but NOT verified" > /tmp/verify-log.$disk

dialog	--title "$title" \
	--msgbox "ǥΥǡõλޤ (${elas})" 5 72

exit 0

# EOF
