#! /bin/sh
#
#   makeiso.sh -- ϡɥǥõѥ֡CDκ
#
#   revision history:
#	0.0: Oct. 26, 2001 by Dai ISHIJIMA
#	0.1: Oct. 22, 2002 (add diskinfo)
#	0.2: May   1, 2004 (4.8R, disklabel, random data)
#	0.3: May   1, 2004 (makefd.sh -> makeiso.sh)
#	0.4: Jun. 15, 2004 (dialog, cd9660)
#	0.5: Jun. 19, 2004 (ե륵ǡ)
#	0.6: Jun. 27, 2004 (ǰõ, fine-erase.sh)
#	0.7: Oct. 18, 2004 (ISO᡼)
#	0.8: Jun. 19, 2005 (CDޥ, PXEѥͥ)
#	0.9: Jul.  8, 2005 (õå)
#	1.0: Jun. 29, 2006 (v07pre-1, 4.11R)
#	1.1: Aug.  6, 2006 (v07pre-2, 4.11R, CD֡Ȥʤݤн)
#	1.2: Sep. 18, 2006 (v07pre-3, 4.11R, PXE֡Ȥ /var ʤݤн)
#
#   usage:
#	# sh makeiso.sh [-t|-p|-f|-a]
#		-t:  (tiny)
#		-p: PXE (pxe-boot)
#		-f: ե륵 (full)
#		-a:  (all)
#

#
# ɤä??
#
##size=full	# CD-ROM˥ͤᤳС
size=tiny	# ξС
pxe=no
suffix=t
case x"$1" in
	x-a*)
		size=all
		pxe=yes
		suffix=a
		;;
	x-[fm]*)
		size=full
		pxe=yes
		suffix=m
		;;
	x-p*)
		size=tiny
		pxe=yes
		suffix=p
		;;
	x-[st]*) size=tiny
		pxe=no
		suffix=t
		;;
esac

# С
version='07'
minor='997'	# 2006-09-18
#minor='998'	# 2006-08-06
#minor='999'	# 2006-08-05, pre release: 999, 998, 997,...
#minor='000'	# official release: 000, 001, 002,...

# Υե뤽¾֤
srcdir=/home/dai/src/wipe-out/v$version/menu

rc=rc
binaries="diskinfo stuff tinydate tinydump check makembr wpout-mbr.boot"
scripts="startup.sh mainmenu.sh seldisk.sh erase.sh fine-erase.sh sel-fine.sh verify.sh dump.sh writelog.sh copy.sh"
misc="info.txt"
termcap="termcap"

ident=WIPEOUT

kernel=/sys/compile/$ident/kernel
sbins="init mount_cd9660 dmesg ldconfig"
devs="all aac0 aacd0 amr0 amrd0"
basebins="dd echo sh test expr"
bins="$basebins cat sleep"
bins_in_cd="cp csh date df hostname kill ln ls mkdir mv ps rcp rm sync"
bins_in_pxe="cp date mkdir sync"
sbins_in_cd="mount mount_ext2fs mount_msdos mount_nfs mount_ntfs umount"
sbins_in_pxe="mount mount_nfs umount"
ubins="/tmp/sed/sed /tmp/dialog/dialog"
usbins="/tmp/kbdcontrol/kbdcontrol"
output="/tmp/wpout${version}${suffix}.iso"
basename=`echo $output | sed 's/\.[^.]*$//' | sed 's+^.*/++'`

# ܸɽ (餫 static link  kon ѰդƤ)
fontdir=/usr/local/share/fonts/bdf
font=pawfont
#font=k14
konbin="/usr/local/bin/kon /usr/local/bin/fld"
koncfg="/usr/local/etc/kon-$font.cfg"
fonts="$fontdir/paw16a.bdf $fontdir/paw16k.bdf"
case "$font" in
	k14) fonts="$fontdir/7x14rk.bdf $fontdir/k14.bdf" ;;
esac

#
# ɬפʥե·äƤ뤫
#

# write_mfs_in_kernel
if [ ! -f /usr/src/release/write_mfs_in_kernel.c ] ; then
	echo 'unable to compile "write_mfs_in_kernel"'
	exit 1
fi

# kernel
if [ ! -f $kernel ] ; then
	echo 'no kernel found'
	exit 1
fi

# diskinfo
if [ ! -x $srcdir/diskinfo ]; then
	echo 'No diskinfo binary'
	exit 1
fi

#
# static link ʥХʥѰ
#
if [ ! -x /tmp/sed/sed ]; then
	if [ ! -x /usr/src/usr.bin/sed ]; then
		echo 'no source of sed'
		exit 1
	fi
	echo "Making static-linked 'sed'..."
	cd /tmp
	(cd /usr/src/usr.bin; tar cf - sed) | tar xvf -
	cd sed
	patch -p1 < $srcdir/sed.patch
	make
fi
if [ ! -x /tmp/dialog/dialog ]; then
	if [ ! -x /usr/src/gnu/usr.bin/dialog ]; then
		echo 'no source of dialog'
		exit 1
	fi
	echo "Making static-linked 'dialog'..."
	cd /tmp
	(cd /usr/src/gnu/usr.bin; tar cf - dialog) | tar xvf -
	cd dialog
	patch -p1 < $srcdir/dialog.patch
	make
fi
if [ ! -x /tmp/kbdcontrol/kbdcontrol ]; then
	if [ ! -x /usr/src/usr.sbin/kbdcontrol ]; then
		echo 'no source of kbdcontrol'
		exit 1
	fi
	echo "Making static-linked 'kbdcontrol'..."
	cd /tmp
	(cd /usr/src/usr.sbin; tar cf - kbdcontrol) | tar xvf -
	cd kbdcontrol
	patch -p1 < $srcdir/kbdcontrol.patch
	make
fi


#
# write_mfs_in_kernel 
#
if [ ! -x /tmp/write_mfs_in_kernel/write_mfs_in_kernel ]; then
	echo "Making write_mfs_in_kernel..."
	mkdir /tmp/write_mfs_in_kernel
	cd /tmp/write_mfs_in_kernel
	cp /usr/src/release/write_mfs_in_kernel.c .
	cc -o write_mfs_in_kernel write_mfs_in_kernel.c
fi


#
# MFSե륷ƥ
#
echo "Making file system onto MFS..."
cd /tmp
# 18, 320 -> 9kХ/ȥå, 640ȥå (1.4M FD4ʬ)
dd of=mfs-image if=/dev/zero count=640 bs=9216
vnconfig -s labels -c /dev/vn0 mfs-image
# ǥ٥
disklabel -w -B -b /boot/boot1 -s /boot/boot2 vn0 auto
newfs -t 2 -u 18 -l 1 -c 80 -i 4096 -m 5 -o space /dev/rvn0c

# -t [track/cylinder]
# -u [sectors/track]
# -l [interleave factor]
# -i [bytes/inode]
# -m [MINFREE]
# -o [optimize]

#
# MFSޥȤ
#
echo "Mounting MFS..."
mount /dev/vn0c /mnt

#
# ǥХե
#
echo "Making device files..."
mkdir /mnt/dev
cd /mnt/dev
cp /dev/MAKEDEV .
for i in $devs; do
	./MAKEDEV $i
done

#
# /tmp ǥ쥯ȥ
#
echo "Making tmp..."
mkdir /mnt/tmp
chmod 777 /mnt/tmp

# ޥȥݥ
mkdir /mnt/a
mkdir /mnt/mnt
mkdir /mnt/cdrom

#
# /etc ǥ쥯ȥ
#
echo "Making etc..."
mkdir /mnt/etc
cd /mnt/etc
echo 'root:*:0:0:Charlie &:/:/bin/sh' > /mnt/etc/passwd
echo 'root:*:0:0::0:0:Charlie &:/:/bin/sh' > /mnt/etc/master.passwd
pwd_mkdb -d /mnt/etc /mnt/etc/master.passwd

cp -p /usr/src/etc/login.conf /mnt/etc
cap_mkdb /mnt/etc/login.conf

cp -p /usr/src/etc/etc.i386/ttys /mnt/etc
cp -p /usr/src/etc/group /mnt/etc
cp -p /usr/src/etc/services /mnt/etc
cp -p /usr/src/etc/protocols /mnt/etc

#
cd $srcdir
cp $rc /mnt/etc/rc
chmod +x /mnt/etc/rc
cp $termcap /mnt/etc

#
# /bin
#
echo "Copying binaries..."
mkdir /mnt/bin
cd /mnt/bin
for i in $bins; do
	cp -p /bin/$i /mnt/bin/$i
done
cd /mnt/bin
ln 'test' '['

# link
cd /mnt/bin
for i in `/bin/ls /bin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/bin/$i $i
	fi
done

mkdir /mnt/wipeout
cd $srcdir
cp $binaries /mnt/wipeout
cp $scripts /mnt/wipeout
cp $misc /mnt/wipeout
cd /mnt/wipeout
chmod +x $scripts
cd /tmp

#
# /sbin
#
mkdir /mnt/sbin
cd /mnt/sbin
for i in $sbins; do
	cp -p /sbin/$i /mnt/sbin/$i
done

# link
cd /mnt/sbin
for i in `/bin/ls /sbin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/sbin/$i $i
	fi
done

#
# /usr
#
mkdir -p /mnt/usr
cd /mnt/usr
ln -s /cdrom/usr/bin bin
ln -s /cdrom/usr/lib lib
ln -s /cdrom/usr/sbin sbin
ln -s /cdrom/usr/libexec libexec

#
# kon
#
mkdir -p /mnt/usr/local/bin
cp $konbin /mnt/usr/local/bin
mkdir -p /mnt/usr/local/etc
cp $koncfg /mnt/usr/local/etc/kon.cfg

#
# /var
#
mkdir -p /mnt/var/run
mkdir -p /mnt/var/tmp

#
# MFS򥢥ޥ
#
cd /tmp
umount /mnt
vnconfig -u /dev/vn0


#
#
#
echo "Writing file system into kernel..."
cp $kernel /tmp
/tmp/write_mfs_in_kernel/write_mfs_in_kernel /tmp/kernel /tmp/mfs-image

#
# ͥ򰵽
#
echo "Compressing kernel..."
cd /tmp
gzip --best < /tmp/kernel > /tmp/kernel.gz
chmod +x kernel.gz

#exit 0

#
# եåԡ᡼κ
#
echo "Making boot floppy image..."

# 18, 80 -> 9kХ/ȥå, 320ȥå (2.8M FD)
dd of=floppy-image if=/dev/zero count=320 bs=9216
vnconfig -s labels -c /dev/vn0 floppy-image

# ǥ٥
disklabel -w -B -b /boot/boot1 -s /boot/boot2 /dev/rvn0c minimum2
newfs -t 2 -u 18 -l 1 -c 80 -i 65536 -m 0 -o space /dev/rvn0c

#
# եåԡ᡼ޥ
#
mount /dev/vn0c /mnt

#
# ̤ͥ֡ȥեåԡ᡼˥ԡ
#
mkdir /mnt/boot
cp -p /boot/boot1 /mnt/boot
cp -p /boot/boot2 /mnt/boot
cp -p /boot/loader /mnt/boot

cp -f /tmp/kernel.gz /mnt/kernel.gz

cd /tmp
umount /mnt
vnconfig -u /dev/vn0

#
# CD-ROM˳ǼեѰդ
#
rm -rf /tmp/cdfs
mkdir /tmp/cdfs

# ֡ȥեåԡ᡼򥳥ԡmkisofsǤΥ᡼ꤹ
mkdir -p /tmp/cdfs/floppies
cp /tmp/floppy-image /tmp/cdfs/floppies/boot.flp

# MFSǥޥȤե륷ƥ򥳥ԡ
case "$size" in
	[af]*)
		mkdir -p /tmp/cdfs/floppy-fs
		vnconfig -c /dev/vn0 mfs-image
		mount /dev/vn0c /mnt
		(cd /mnt; tar cf - . ) | (cd /tmp/cdfs/floppy-fs; tar xvpf -)
		umount /mnt
		vnconfig -u /dev/vn0
		;;
esac

# 켰򥳥ԡ
mkdir -p /tmp/cdfs/src
cd $srcdir
cp -p * /tmp/cdfs/src

# CD-ROM˳Ǽե륷ƥ
case "$size" in
	# ե륵ǤϥȥԡƤ
	[af]*)
		# CD-ROM /bin /sbin ե륷ƥ
		for i in bin sbin ; do
			mkdir -p /tmp/cdfs/$i
			cd /tmp/cdfs/$i
			(cd /$i; tar cf - .) | tar xvpf -
		done
		
		# CD-ROM /etc ե륷ƥ
		mkdir -p /tmp/cdfs/etc
		cd /tmp/cdfs/etc
		(cd /usr/src/etc; tar cf - .) | tar xvpf -
		
		# CD-ROM /usr/* ե륷ƥ
		for i in bin lib sbin libexec ; do
			mkdir -p /tmp/cdfs/usr/$i
			cd /tmp/cdfs/usr/$i
			(cd /usr/$i; tar cf - .) | tar xvpf -
		done
		
		# ä
		cd /tmp/cdfs/usr/lib
		/bin/rm -rf aout compat lib*.a
		cd /tmp/cdfs/usr/libexec
		/bin/rm -rf cc1 cc1obj f771 cc1plus lpr sendmail sm.bin uucp
		cd /tmp/cdfs/usr/sbin
		/bin/rm -rf named
		;;
	# ̥СϤ
	t*)
		mkdir /tmp/cdfs/bin
		cd /tmp/cdfs/bin
		(cd /bin; tar cf - $bins_in_cd) | tar xvpf -
		mkdir /tmp/cdfs/sbin
		cd /tmp/cdfs/sbin
		(cd /sbin; tar cf - $sbins_in_cd) | tar xvpf -
		;;		
esac

#
# static linked binaries
#
mkdir -p /tmp/cdfs/usr.bin
cp $ubins /tmp/cdfs/usr.bin
mkdir -p /tmp/cdfs/usr.sbin
cp $usbins /tmp/cdfs/usr.sbin

#
# fonts
#
mkdir -p /tmp/cdfs/fonts
cp $fonts /tmp/cdfs/fonts

#
# PXE֡ѥͥκ
#
case "x$pxe" in
	xyes)
		# ᡼եɬפʥեɲ
		cd /tmp
		vnconfig -c /dev/vn0 mfs-image
		mount /dev/vn0c /mnt
		for i in $bins_in_pxe ; do
			rm -f /mnt/bin/$i
			cp -p /bin/$i /mnt/bin
		done
		for i in $sbins_in_pxe ; do
			rm -f /mnt/sbin/$i
			cp -p /sbin/$i /mnt/sbin
		done
		mkdir -p /mnt/usr.bin
		cp $ubins /mnt/usr.bin
		mkdir -p /mnt/usr.sbin
		cp $usbins /mnt/usr.sbin
		mkdir -p /mnt/usr/local/share/fonts/bdf
		cp $fonts /mnt/usr/local/share/fonts/bdf
		umount /mnt
		vnconfig -u /dev/vn0

		# ͥCD-ROM᡼
		cp $kernel /tmp
		/tmp/write_mfs_in_kernel/write_mfs_in_kernel \
			/tmp/kernel /tmp/mfs-image
		cp /tmp/kernel /tmp/cdfs

		# pxeboot¾Υ֡ȥɤ
		mkdir /tmp/cdfs/boot
		(cd /boot; tar cf - .) | (cd /tmp/cdfs/boot; tar xvf -)
		;;
esac

#
# ΥեѰդ
#
case "$size" in
	a*)
		mkdir -p /tmp/cdfs/images
#		cp /tmp/wpout${version}f.flp /tmp/cdfs/images
		cp /tmp/wpout${version}t.iso /tmp/cdfs/images
		cp /tmp/wpout${version}m.lzh /tmp/cdfs/images
		cp /tmp/wpout${version}s.lzh /tmp/cdfs/images
		cd /tmp/cdfs/images
		md5 wpout* > md5sums.txt
		;;
esac

cd /tmp

#      filename-maj-min
#      0123456789abcdef
#      WIPE-OUT-04M_001
#
volsuffix=`echo $suffix | tr a-z A-Z`
volid="WIPE-OUT-${version}${volsuffix}_${minor}"

#
# ʲˡ mkisofs 1.15a27 ǤϤޤ
# cjk-mkisofs 2.01 Ǥϥ֥֡CDʤ
#

mkisofs -b floppies/boot.flp -c floppies/boot.catalog \
	-r -J -V $volid -o $output /tmp/cdfs

# -d .פʤΥե̾, -D ǥ쥯ȥ곬ؤ֤ʤ
# -V ܥ塼ID, -f ܥå󥯤򤿤ɤ, -J WindowsJolietĥ
# -r ե⡼, -b ֡ȥ᡼(å), -o 
####mkisofs -d -D -V ERASEHDJ -f -J -r -b floppy-image -o $output /tmp/cdfs
#

/bin/rm $basename.lzh $basename.tgz
lha ao5 $basename.lzh $basename.iso
#tar czvf $basename.tgz $basename.iso

#
# ޤ
#
