/*
 *  makembr -- ᤳMBR
 *
 *  revision history:
 *	0.0:	Aug.  1, 2006 by Dai ISHIJIMA (for wpout07)
 */

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#define STDIN 0
#define STDOUT 1
#define STDERR 2

#ifndef EOF
#define EOF -1
#endif

#define NEWLINE	'\n'
#define CRET	'\r'

#define MBRSIZ	512
#define MESGLEN	398
#define TBLOFF	0x01be
#define MESG	(TBLOFF - MESGLEN)
#define MAXLINE 50

/* ʸ */
int getch(int fd)
{
    unsigned char ch;
    
    if (read(fd, &ch, 1) <= 0) {
	return(EOF);
    }
    return(ch);
}


int main()
{
    unsigned char mbrbuf[MBRSIZ];
    int ch;
    int len;
    int pos;

    /* Ȥꤢ512Хɤ */
    read(STDIN, mbrbuf, MBRSIZ);
    /* μ餬񤭹 */
    len = 0;
    pos = 0;
    while ((len < MESGLEN) && ((ch = getch(STDIN)) != EOF)) {
	if (ch == NEWLINE) {
	    mbrbuf[MESG + len] = CRET;
	    ++len;
	    mbrbuf[MESG + len] = NEWLINE;
	    ++len;
	    pos = 0;
	}
	else if (pos < MAXLINE) {
	    mbrbuf[MESG + len] = ch;
	    ++len;
	    ++pos;
	}
	else if (pos == MAXLINE) {
	    mbrbuf[MESG + len] = '.';
	    ++len;
	    ++pos;
	    mbrbuf[MESG + len] = '.';
	    ++len;
	    ++pos;
	    mbrbuf[MESG + len] = '.';
	    ++len;
	    ++pos;
	}
    }
    if (len < MESGLEN) {
	mbrbuf[MESG + len] = 0;
    }
    write(STDOUT, mbrbuf, MBRSIZ);
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -s -static -o makembr makembr.c" */
/* End: */
