#! /bin/sh
#
#   verify.sh -- ǡäƤ뤫ǧ
#
#	Ȥ: /bin/sh verify.sh step ǥ
#		step: åפĹ
#		ǥ: ǥХեǻꡢƬΡ/dev/rפϾʤ
#		: /bin/sh verify.sh 90 ad0
#
#	0.0: Jul.  8, 2005 by Dai ISHIJIMA (for wpout06)
#	0.2: Aug.  1, 2006 (ॹ for wpout07)
#

step="${1:-1}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# 10MХñ̤ǳǧ
vblklen="${VBLKLEN:-10485760}"
# ٤1MХ
vbs="${VBS:-1048576}"
# ٤10֥å
vcnt=`expr $vblklen / $vbs`

if [ ! -r /dev/r$disk ]; then
	echo "$0: disk '$disk' does not exist or is not readable"
	echo "Usage: $0 [step] disk"
	echo "Example: $0 -1 ad0"
	exit 1
fi

title="${TITLE:-ϡɥǥõġwipe-out}"

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
dbytes=`diskinfo -p /dev/r$disk`


# ǧΥѥ᡼
bytes=`diskinfo -b /dev/r$disk`
# ֥åñ̤ǤΥǥ
max=`expr '(' $bytes + $vbs - 1 ')' / $vbs`

# 
zero=0
one=0
maybe=0
unerased=0
checked=0

startsec=`tinydate '+%s'`
rems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

skip=0
while [ $skip -lt $max ]; do
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=`expr 100 '*' $skip / $max`
	m=`expr 1000 '*' $skip / $max`
	q=`expr $p / 2`
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=`expr $i + 1`
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=`expr $i + 1`
	done
	# Ĥ
	elapsed=`expr $cursec - $startsec`
	if [ $elapsed -gt 10 ]; then
		remain=`expr '(' 1000 - $m ')' '*' $elapsed / $m + 1`
		if [ $remain -gt 120 ]; then
			rems=`expr '(' $remain + 59 ')' / 60`
			rems="Ĥ 褽${rems}ʬ"
		else
			rems="Ĥ 褽${remain}"
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=`expr '(' $elapsed + 30 ')' / 60`
		elas="${elas}ʬ"
	else
		elas="${elapsed}"
	fi
	#
	text="ǥ ${disk} ΥǡåƤޤ\n"
	text="${text}${max}֥åΤ${skip}֥å${p}% λ\n"
	text="${text}${elas} в  ${rems}  \n\n"
	text="${text}        0%|${bar}|100%"
	text="${text}\n${errormsg}"
	dialog --title "$title" --infobox "$text" 8 72
	echo -n "$status2"
	case x$DEBUG in
		x[Yy]*)
			status2='now in debug mode...'
			errormsg=''
			sleep 1
			;;
		*)
			status=`(dd if=/dev/r$disk ibs=$vbs skip=$skip count=$vcnt | check -s) 2>&1`
			case $? in
				0) zero=`expr $zero + $vcnt` ;;
				1) one=`expr $one + $vcnt` ;;
				2) maybe=`expr $maybe + $vcnt` ;;
				*) unerased=`expr $unerased + $vcnt` ;;
			esac
			status2=`echo "$status" | sed -n '/transfer/p'`
			errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
			;;
	esac
	# 롼
	checked=`expr $checked + $vcnt`
	skip=`expr $skip + $vcnt + $step`
done

sleep 2

cursec=`tinydate '+%s'`
elapsed=`expr $cursec - $startsec`
if [ $elapsed -gt 120 ]; then
	min=`expr $elapsed / 60`
	sec=`expr $elapsed - $min '*' 60`
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

unerased=`expr $unerased + $maybe`
zp=`expr $zero '*' 100 / $checked`
op=`expr $one '*' 100 / $checked`
np=`expr $unerased '*' 100 / $checked`

msg="ǥ ($disk, $dbytes Х) Υåλޤ (${elas})\n"
msg="${msg} $max ֥å $checked ֥å򸡺ޤ\n"
msg="${msg}  '0' ǾõƤ֥å: $zero ($zp %)\n"
msg="${msg}  '1' ǾõƤ֥å: $one ($op %)\n"
msg="${msg}  ʳ (̤õ) Υ֥å: $unerased ($np %)\n"

# ¸
echo "Verified $checked blocks" > /tmp/verify-log.$disk
echo -n " erased with 0:${zp}%, 1:${op}%, " >> /tmp/verify-log.$disk
echo "unerased:${np}%" >> /tmp/verify-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/verify-log.$disk

dialog	--title "$title" \
	--msgbox "$msg" 10 72

exit 0

# EOF
