#! /bin/sh
#
#   mainmenu.sh -- ϡɥǥõġᥤ (floppy)
#
#	0.0: Oct. 30, 2001 by Dai ISHIJIMA (as startup.sh)
#	0.1: Oct. 22, 2002 (for v01)
#	0.2: May   1, 2004 (for v02)
#	0.3: Jun. 19, 2004 (for v03, as mainmenu.sh)
#	0.4: Jul. 11, 2004 (for v04)
#	0.5: Jul.  9, 2005 (for v06)
#	0.6: Feb. 17, 2005 (for v08)
#

dmesg=/var/run/dmesg.boot
resultfil=/tmp/result
disks=`sed -n -E '/^(da|ad)[0-9]:.*</p' $dmesg | sed 's/^\(...\).*/\1/'`
set $disks
disk=$1
stuffs='10'
dumpskip=0

while true ; do
	dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`diskinfo -B /dev/r$disk`
	cap=`diskinfo -p /dev/r$disk`

	echo '*** Hard Disk wiping tool "wipe-out" ***'
	echo ''
	echo "current disk: /dev/${disk} ${dname}"
	echo "    capacity: $bytes bytes ($cap)"
	echo ''
	echo '    0: write "0" onto the disk'
	echo '    1: write "1" onto the disk'
	echo '    2: erase data with multiple writing'
	echo '    3: select multi-write method'
	echo '    4: verify disk (quick)'
	echo '    5: verify disk (normal)'
	echo '    6: write erase log onto the disk'
	echo '    7: select disk'
	echo '    8: dump sector'
	echo '    9: set sector number to dump'
	echo '    a: write random data onto the disk'
	echo '    b: run shell (sh)'
	echo '    c: reboot'
	echo '    d: shutdown'
	echo ''
	echo -n 'enter number [0-9a-d]: '
	read ans

	case x"${ans}" in
		x0)
			sh erase.sh -z $disk
			;;
		x1)
			sh erase.sh -f $disk
			;;
		x2)
			sh fine-erase.sh $stuffs $disk
			;;
		x3)
			. sel-fine.sh
			;;
		x4)
			sh verify.sh 90 $disk
			;;
		x5)
			sh verify.sh 0 $disk
			;;
		x6)
			sh writelog.sh $disk
			;;
		x7)
			. seldisk.sh
			;;
		x8)
			echo ''
			echo "*** sector $dumpskip of disk $disk"
			dd if=/dev/r$disk skip=$dumpskip count=1 2>/dev/null | tinydump
			dumpskip=$(( $dumpskip + 1 ))
			echo -n "Press ENTER to return menu"
			read enterkey
			;;
		x9)
			echo ''
			echo -n "***Enter sector number [$dumpskip] :"
			read sector
			echo "$sector" > /tmp/sector
			echo "$dumpskip" >> /tmp/sector
			dumpskip=`sed -n '/^[0-9]/p' /tmp/sector | sed -n 1p`
			;;
		xa)
			sh erase.sh -r $disk
			;;
		xb)
			/bin/sh -i
			;;
		xc)
			/sbin/init 6
			;;
		xd)
			/sbin/init 0
			;;
	esac
	echo ''
	echo ''
done

exit 0

# EOF
