#! /bin/sh
#
#   makeiso.sh -- ϡɥǥõѥ֡CDκ
#
#   revision history:
#	0.0: Oct. 26, 2001 by Dai ISHIJIMA
#	0.1: Oct. 22, 2002 (add diskinfo)
#	0.2: May   1, 2004 (4.8R, disklabel, random data)
#	0.3: May   1, 2004 (makefd.sh -> makeiso.sh)
#	0.4: Jun. 15, 2004 (dialog, cd9660)
#	0.5: Jun. 19, 2004 (ե륵ǡ)
#	0.6: Jun. 27, 2004 (ǰõ, fine-erase.sh)
#	0.7: Oct. 18, 2004 (ISO᡼)
#	0.8: Jun. 19, 2005 (CDޥ, PXEѥͥ)
#	0.9: Jul.  8, 2005 (õå)
#	1.0: Jun. 29, 2006 (v07pre-1, 4.11R)
#	1.1: Aug.  6, 2006 (v07pre-2, 4.11R, CD֡Ȥʤݤн)
#	1.2: Sep. 18, 2006 (v07pre-3, 4.11R, PXE֡Ȥ /var ʤݤн)
#	1.3: Dec. 21, 2006 (v07pre-4, SJISɥ)
#	1.4: Feb. 10, 2007 (v08pre-1, ǥؤΥϿ)
#	1.5: Feb. 15, 2007 (nkfץߥ)
#	1.6: Feb. 16, 2007 (ͥȥե륷ƥʬΥ)
#	1.7: Sep. 12, 2007 (v09pre-1)
#	1.9: Sep. 17, 2007 (v09pre-2)
#	2.0: Oct.  7, 2007 (v09pre-3, /etc/fstab)
#	2.1: Dec. 23, 2007 (v09pre-4, copy.sh¾Сշ׻)
#	2.2: Jan.  2, 2008 (v09pre-5, ե륵, ե, etc.)
#	2.3: Feb. 10, 2008 (v09)
#	2.4: Apr. 19, 2009 (v10pre-1)
#	2.5: Apr. 25, 2009 (v10pre-2)
#	2.6: Nov.  7, 2010 (v11pre-1), FreeBSD 7.3R
#	2.7: Apr. 11, 2011 (v11pre-2), kon2fixed
#	2.8: Apr. 16, 2011 (v11pre-3), USB
#	2.9: Dec. 22, 2012 (v12pre-1), SMART
#	3.0: Jan. 21, 2013 (v12pre-2), USB image
#	3.1: May   5, 2013 (v13pre-1), FreeBSD 8.3R, md0c -> md0a
#	3.1: Oct. 10, 2013 (v13pre-3), fix kon fatal error, libusb.so
#	3.2: Nov.  7, 2013 (v13pre-4), xhci.ko
#	3.3: Dec.  7, 2013 (v13pre-5), mfi(4), mfid
#
#   usage:
#	# sh makeiso.sh [-t|-p|-f|-a|-u]
#		-t:  (tiny)
#		-u:  (tiny) for USB
#		-p: PXE (pxe-boot) (obsolated)
#		-f: ե륵 (full)
#		-a:  (all) (obsolated)
#
#   required install:
#	kern-developer, setc (/etc/source), ports
#
#   required packages/ports:
#	ja-kon2, ja-nkf, cdrtools, kon2fixed, smartmontools
#
#   required patches:
#	apply kon-paw16.cfg.patch at /usr/local/etc
#	apply kon2diff.gz at /usr/ports/japanese/kon2-16dot/work/kon2-0.3/src
#	install kon as /usr/local/bin/kon2fixed
#
#   required font files:
#	paw16k.bdf, paw16a.bdf in /usr/local/share/fonts/bdf
#

# Ȥꤢư
cd /tmp

#
# ɤä??
#
##size=full	# CD-ROM˥ͤᤳС
size=tiny	# ξС
pxe=no
suffix=t
mkusb=NO
case x"$1" in
	x-[afm]*)
		size=full
		pxe=yes
		suffix=m
		;;
	x-[stp]*)
		size=tiny
		pxe=yes
		suffix=t
		;;
	x-[u]*)
		size=tiny
		pxe=yes
		suffix=t
		mkusb=YES
		;;
esac

# С
version='13'

minor='994'	# 2013-12-31 for v13
#minor='995'	# 2013-12-07 for v13
#minor='996'	# 2013-11-10 for v13
#minor='997'	# 2013-10-12 for v13
#minor='998'	# 2013-10-11 for v13
#minor='999'	# 2013-05-05 for v13
#minor='000'	# official release: 000, 001, 002,...

# 
output="/tmp/wpout${version}${suffix}.iso"
usbimg="/tmp/wpout${version}${suffix}.usb"
basename=`echo $output | sed 's/\.[^.]*$//' | sed 's+^.*/++'`

#
# ܥ塼٥
#      filename-maj-min
#      0123456789abcdef
#      WIPE-OUT-04M_001
#
volsuffix=`echo $suffix | tr a-z A-Z`
volid="WIPE-OUT-${version}${volsuffix}_${minor}"

# ॹ
timestamp=`date '+%Y-%m-%d'`
echo "$volid ($timestamp)" > /tmp/version.txt

# Υե뤽¾֤
srcdir=/home/dai/src/wipe-out/v$version/menu

# ͥ
ident=
case x${ident} in
	x)
		kerndir=/boot/kernel
		;;
	x*)
		kerndir=/boot/kernel.$ident
		;;
esac

# ɬפʤΤϤ?
for f in $srcdir/disksize $kerndir/kernel ; do
	if [ ! -r $f ]; then
		echo "can't open $f" 1>&2
		exit 1
	fi
done

if [ ! -f /usr/local/share/fonts/bdf/paw16k.bdf ]; then
	echo "can't find paw16k.bdf" 1>&2
	exit 1
fi
if ! grep paw /usr/local/etc/kon.cfg > /dev/null 2>&1; then
	echo "paw font patch did not applied" 1>&2
	exit 1
fi

#
# wipe-outΥե뷲
#
rc=rc
binaries="disksize stuff tinydate tinydump check makembr wpout-mbr.boot"
scripts="startup.sh mainmenu.sh seldisk.sh erase.sh fine-erase.sh"
scripts="$scripts sel-fine.sh verify.sh dump.sh writelog.sh"
scripts="$scripts copy.sh embr.sh crlf.sh floppylog.sh dummyread.sh"
scripts="$scripts kon2start.sh"
misc="info.txt readme.txt help.txt"
termcap="termcap"
textfiles="$rc $scripts $misc $termcap"
images="wpout08f.flp"
images="$images wpout10u-20100214.tgz"
images="$images wpout11t-2011-04-16.iso"
images="$images wpout11t-2011-04-16.usb"
#images="NO"	# ǤΥ᡼ե򥳥ԡʤ
 
#
# FreeBSDΥƥե
#

# MFS˺ǥ쥯ȥ
dirs="bin sbin lib libexec etc dev tmp var/run var/tmp wipeout"
dirs="$dirs usr.bin usr.sbin usr.lib"
dirs="$dirs usr/local/bin usr/local/etc usr/local/sbin"
dirs="$dirs usr/local/share/fonts/bdf"
dirs="$dirs a mnt cdrom floppy"

# MFS˥ԡե
bins="sh echo dd test expr cat sleep"
bins="$bins cp date mkdir sync"
bins="$bins csh df hostname kill ln ls mv ps rm"

sbins="init ldconfig mount dmesg mount_cd9660"
sbins="$sbins umount shutdown"
sbins="$sbins mount_msdosfs mount_nfs mount_ntfs"

# ɬפʥ饤֥ ldd(1) ޥɤǳǧ
libs="libc.so.? libcrypt.so.? libedit.so.? libncurses.so.? libutil.so.?"
libs="$libs libkvm.so.? libkiconv.so.? libm.so.?"
libs="$libs libcam.so.? libgcc_s.so.? libsbuf.so.?"

libexecs="ld-elf.so.?"

ubins="sed dialog hd id wall"
usbins="kbdcontrol"
ulibs="libdialog.so.? libbsm.so.? libstdc++.so.? libusb.so.?"

ulbins="kon kon2fixed fld "
uletcs="kon.cfg"
fonts="paw16k.bdf paw16a.bdf"

ulsbins="smartctl"

#
# mfsroot.gz κ
#

# ᡼ե
dd if=/dev/zero bs=1m of=/tmp/mfsroot count=10

# 
mdconfig -a -t vnode -f /tmp/mfsroot -u 0
bsdlabel -w md0 auto
newfs -i 4096 md0a
# default value of i option: 8192 -> 320 inodes
# 4096 -> 576, 2048 -> 1088 inodes


# ޥ
mount /dev/md0a /mnt
cd /mnt

# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT /mnt
 
# СϿ
cp /tmp/version.txt /mnt

# ɬפʥǥ쥯ȥ
cd /mnt
for d in $dirs ; do
	mkdir -p $d
done
chmod 777 /tmp

# /etc 
cd /mnt/etc
echo 'root:*:0:0:Charlie &:/:/bin/sh' > /mnt/etc/passwd
echo 'root:*:0:0::0:0:Charlie &:/:/bin/sh' > /mnt/etc/master.passwd
pwd_mkdb -d /mnt/etc /mnt/etc/master.passwd

cp -p /usr/src/etc/login.conf /mnt/etc
cap_mkdb /mnt/etc/login.conf

cp -p /usr/src/etc/etc.i386/ttys /mnt/etc
cp -p /usr/src/etc/group /mnt/etc
cp -p /usr/src/etc/services /mnt/etc
cp -p /usr/src/etc/protocols /mnt/etc

cp -p /usr/src/etc/root/dot.profile /mnt/.profile
cp -p $srcdir/dot.cshrc /mnt/.cshrc

echo '# device	mount	fstype	options	dump	pass'	>  /mnt/etc/fstab
echo '/dev/md0a	/	ufs	rw	1	1'	>> /mnt/etc/fstab

# wipe-outϢΥե/etc˥ԡ
cd $srcdir
cp $rc /mnt/etc/rc
chmod +x /mnt/etc/rc
cp $termcap /mnt/etc

# /wipeout ɬפʥե򥳥ԡ
cd $srcdir
cp $binaries /mnt/wipeout
cp $scripts /mnt/wipeout
cp $misc /mnt/wipeout
cd /mnt/wipeout
chmod +x $scripts

# /bin
cd /mnt/bin
for f in $bins ; do
	cp -p /bin/$f .
done
# link
ln 'test' '['
# symlink
for i in `/bin/ls /bin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/bin/$i $i
	fi
done

# /sbin
cd /mnt/sbin
for f in $sbins ; do
	cp -p /sbin/$f .
done
# symlink
for i in `/bin/ls /sbin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/sbin/$i $i
	fi
done

# /lib
cd /mnt/lib
for f in $libs ; do
	cp -p /lib/$f .
done
# symlink
for i in `/bin/ls /lib`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/lib/$i $i
	fi
done

# /libexec
cd /mnt/libexec
for f in $libexecs ; do
	cp -p /libexec/$f .
done
# symlink
for i in `/bin/ls /libexec`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/libexec/$i $i
	fi
done

# /usr/bin
cd /mnt/usr.bin
for f in $ubins ; do
	cp -p /usr/bin/$f .
done
ln id whoami
ln id groups

# /usr/sbin
cd /mnt/usr.sbin
for f in $usbins ; do
	cp -p /usr/sbin/$f .
done

# /usr/lib
cd /mnt/usr.lib
for f in $ulibs ; do
	cp -p /usr/lib/$f .
done

# other /usr directories
cd /mnt/usr
udirs="bin sbin lib libexec"
for d in $udirs ; do 
	ln -s /cdrom/usr/$d $d
done

# /usr/local/bin
cd /mnt/usr/local/bin
for f in $ulbins ; do
	cp -p /usr/local/bin/$f .
done

# /usr/local/etc
cd /mnt/usr/local/etc
for f in $uletcs ; do
	cp -p /usr/local/etc/$f .
done

# /usr/local/sbin
cd /mnt/usr/local/sbin
for f in $ulsbins ; do
	cp -p /usr/local/sbin/$f .
done

# /usr/local/share/fonts/bdf
mkdir -p /mnt/usr/local/share/fonts/bdf
for f in $fonts ; do
	cp -p /usr/local/share/fonts/bdf/$f /mnt/usr/local/share/fonts/bdf
done

# ޥȤư
cd /tmp
umount /mnt
mdconfig -d -u 0
gzip --best < /tmp/mfsroot > /tmp/mfsroot.gz

# 
# ֡ȥ᡼κ
#
if [ -d /tmp/cdfs ]; then
	chflags -R 0 /tmp/cdfs
	rm -rf /tmp/cdfs
fi

mkdir -p /tmp/cdfs/boot/kernel
mkdir -p /tmp/cdfs/boot/modules
mkdir -p /tmp/cdfs/boot/defaults

# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT /tmp/cdfs

bootfils="boot boot0 boot0sio boot1 boot2 cdboot loader mbr pxeboot"
bootfils="$bootfils beastie.4th frames.4th loader.4th screen.4th support.4th"
bootfils="$bootfils device.hints loader.conf loader.help loader.rc"

for f in $bootfils ; do
	cp -p /boot/$f /tmp/cdfs/boot
done

cp -p /boot/defaults/loader.conf /tmp/cdfs/boot/defaults

echo 'mfsroot_load="YES"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_type="mfs_root"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_name="/boot/mfsroot"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_before="echo -n '"'"'mfsroot '"'"'"' \
	>> /tmp/cdfs/boot/loader.conf
echo 'vfs.root.mountfrom="ufs:/dev/md0a"' >> /tmp/cdfs/boot/loader.conf

# 2009-09-29 (IBM ServeRAID support test) -> no need? (2012-12-22)
echo 'ips_load="YES"' >> /tmp/cdfs/boot/loader.conf

# 2013-10-11 (siis(4) eSATA support test)
echo 'siis_load="YES"' >> /tmp/cdfs/boot/loader.conf

# 2013-10-12 (xhci(4) USB 3.0 support test)
echo 'xhci_load="YES"' >> /tmp/cdfs/boot/loader.conf

cp -p $kerndir/kernel /tmp/cdfs/boot/kernel
cp -p $kerndir/linker.hints /tmp/cdfs/boot/kernel
cp -p $kerndir/acpi.ko /tmp/cdfs/boot/kernel
#
cp -p $kerndir/ips.ko* /tmp/cdfs/boot/kernel
cp -p $kerndir/siis.ko* /tmp/cdfs/boot/kernel
cp -p $kerndir/xhci.ko* /tmp/cdfs/boot/kernel
#
cp /tmp/mfsroot.gz /tmp/cdfs/boot/mfsroot.gz

# 礭Ǥ $kerndir/* 򥳥ԡ
case x"$size" in
    x[af]*)
	cp -p $kerndir/* /tmp/cdfs/boot/kernel
	;;
esac	

# 켰򥳥ԡ
mkdir -p /tmp/cdfs/src
cd $srcdir
cp -p * /tmp/cdfs/src

# Windows桼˥եJISΥեѰ
for i in $misc ; do
	nkf -s -c $i > /tmp/cdfs/$i
done
nkf -s -c /tmp/version.txt > /tmp/cdfs/version.txt

mkdir -p /tmp/cdfs/sjis
for i in $textfiles ; do
	nkf -s -c $i > /tmp/cdfs/sjis/$i
done

# ޥ˥
case x"$size" in
    x[af]*)
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p /tmp/cdfs/$d
		cd /tmp/cdfs/$d
		(cd /$d; tar cf - . ) | tar xvpf -
	done
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p /tmp/cdfs/usr/$d
		cd /tmp/cdfs/usr/$d
		(cd /usr/$d; tar cf - . ) | tar xvpf -
	done
	# ä
	cd /tmp/cdfs/usr/libexec
	/bin/rm -rf cc1* f77* lpr sendmail sm.bin
	cd /tmp/cdfs/usr/lib
	/bin/rm -rf aout compat lib*.a
	cd /tmp/cdfs/usr/sbin
	/bin/rm -rf named* dns* lwresd*	
	;;
esac

# ǤΥ᡼ե򥳥ԡ (CD)
case x"$images" in
	xNO)
		;;
	*)
		mkdir -p /tmp/cdfs/images
		for i in $images ; do
			if [ -f /tmp/$i ]; then
				cp -p /tmp/$i /tmp/cdfs/images
			fi
		done
		;;
esac


# ISO᡼
cd /tmp
mkisofs -b boot/cdboot -no-emul-boot -c boot.catalog \
	-r -J -V $volid -o /tmp/$basename.iso /tmp/cdfs

# USB᡼
case x"$mkusb" in
    xYES)
	cd /tmp

	# 3 * 255 * 63 * 512 = 24,6758,403 =~ 24Mbytes
	ncyls=6
	nhead=128
	nsect=62
	#
	ncnt=$(( ($ncyls * $nhead * $nsect * 512 + 1048576 - 1) / 1048576 ))
	# 24MХȤΥ᡼
	dd if=/dev/zero of=$usbimg bs=1048576 count=$ncnt

	# ᡼
	mdconfig -a -t vnode -f $usbimg -u 0 -x $nsect -y $nhead

	# fdiskѾ
	#   geometry	sector	head	cylinder
	echo	"g	s$nsect	h$nhead	c$ncyls"	>  /tmp/fdisk.conf
	#    partition	slice	sysid	start	length
	echo	"p	1	6	$nsect	4M"	>> /tmp/fdisk.conf
	echo	'p	2	165	*	*'	>> /tmp/fdisk.conf
	echo	'p	3	0	0	0'	>> /tmp/fdisk.conf
	echo	'p	4	0	0	0'	>> /tmp/fdisk.conf
	#    slice #2 is bootable (active)
	echo	'a	2'				>> /tmp/fdisk.conf

	# Ȥꤢ֡ȥ񤭹
	fdisk -v -BI md0
	# fdisk.conf ˴Ťƥѡƥ
	fdisk -v -f fdisk.conf md0

	# FAT16 (sysid == 6) եޥåȤƥǥ쥯ȥ
	newfs_msdos /dev/md0s1
	mount -t msdosfs /dev/md0s1 /mnt
	mkdir /mnt/WIPE-OUT
	cp -p /tmp/cdfs/*.txt /mnt
	mkdir /mnt/SJIS
	( cd /tmp/cdfs/sjis ; tar cf - . ) | ( cd /mnt/SJIS ; tar xvf -)
	df -k /mnt
	umount /mnt

	# UFS (/dev/da0s2a) 
	bsdlabel -w -B /dev/md0s2
	newfs /dev/md0s2a
	mount /dev/md0s2a /mnt
	( cd cdfs ; tar cf - . ) | ( cd /mnt ; tar xvpf - )
	df -k /mnt
	umount /mnt
	fdisk /dev/md0

	# ᡼ڤΥ
	mdconfig -d -u 0
	;;
esac

# 
/bin/rm -f $basename.lzh $basename.tgz
#lha ao5 $basename.lzh $basename.iso
#tar czvf $basename.tgz $basename.iso

#
# ޤ
#
