#! /bin/sh
#
#   verify.sh -- ǡäƤ뤫ǧ
#
#	Ȥ: /bin/sh verify.sh step ǥ
#		step: åפĹ
#		ǥ: ǥХեǻꡢƬΡ/dev/פϾʤ
#		: /bin/sh verify.sh 0 ad0 (ǥ)
#		    /bin/sh verify.sh 90 ad0 (Τ1/10)
#		    /bin/sh verify.sh 990 ad0 (Τ1/100)
#
#	0.0: Jul.  8, 2005 by Dai ISHIJIMA (for wpout06)
#	0.2: Aug.  1, 2006 (ॹ for wpout07)
#	0.3: Feb. 10, 2007 (Ͽ for wpout08)
#	0.4: Feb. 15, 2007 (󥿡Ĺк)
#	0.5: Sep. 12, 2007 (wpout09)
#	0.6: Oct.  6, 2007 (׻32ӥåդϰϤǹԤ)
#	0.7: Dec. 23, 2007 (Сɽη׻)
#	0.8: Jan.  2, 2008 ()
#	0.9: Apr. 19, 2009 (ǧå, wpout10)
#

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"
PATTERNFIL="${PATTERNFIL:-/tmp/pattern.dat}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

step="${1:-1}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# 10MХñ̤ǳǧ
vblklen="${VBLKLEN:-10485760}"
# ٤1MХ
vbs="${VBS:-1048576}"
vunit=$(( $vbs / 1048576 ))
# ٤10֥å
vcnt=$(( $vblklen / $vbs ))

#
resultfil=/tmp/result

#
title="${TITLE:-ϡɥǥõġwipe-out}"

if [ ! -r /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ǥ $disk ¸ߤʤɤޤ" \
		5 64
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
dbytes=`disksize -p /dev/$disk`

bytes=`disksize -B /dev/$disk`

# ǧΥѥ᡼
mbytes=`disksize -m /dev/$disk`
# ֥åñ̤ǤΥǥ
max=$(( $mbytes / $vunit ))

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"
msg="${msg}õƤ뤳Ȥǧޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'õǧ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

# 
zero=0
one=0
maybe=0
unerased=0
checked=0

startsec=`tinydate '+%s'`
rems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "verify started on " >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname) $bytes bytes" >> $LOGFIL

nerrs=0
skip=0
xcent=100
xmill=1000
mcent=$max
mmill=$max
if [ $max -gt 1048576 ]; then
	xcent=1
	xmill=1
	mcent=$(( ( $max + 99 ) / 100 ))
	mmill=$(( ( $max + 999 ) / 1000 ))
fi
while [ $skip -lt $max ]; do
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=$(( ( $xcent * $skip ) / $mcent ))
	m=$(( ( $xmill * $skip ) / $mmill ))
	q=$(( $p / 2 ))
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=$(( $i + 1 ))
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=$(( $i + 1 ))
	done
	# Ĥ
	elapsed=$(( $cursec - $startsec ))
	if [ $elapsed -gt 10 ]; then
		remain=$(( ( 1000 - $m ) * $elapsed / $m + 1 ))
		if [ $remain -gt 120 ]; then
			rems=$(( ( $remain + 59 ) / 60 ))
			rems="Ĥ 褽${rems}ʬ"
		else
			rems="Ĥ 褽${remain}"
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=$(( ( $elapsed + 30 ) / 60 ))
		elas="${elas}ʬ"
	else
		elas="${elapsed}"
	fi
	#
	text="ǥ ${disk} ΥǡåƤޤ\n"
	text="${text}${max}֥åΤ${skip}֥å${p}% λ\n"
	text="${text}${elas} в  ${rems}  \n\n"
	text="${text}        0%|${bar}|100%"
	text="${text}\n${errormsg}"
	dialog --title "$title" --infobox "$text" 8 72
	echo -n "$status2"
	case x$DEBUG in
		x[Yy]*)
			status2='now in debug mode...'
			errormsg=''
			sleep 1
			;;
		*)
			status=`(dd if=/dev/$disk ibs=$vbs skip=$skip count=$vcnt | check -s) 2>&1`
			case $? in
				0) zero=$(( $zero + $vcnt )) ;;
				1) one=$(( $one + $vcnt )) ;;
				2) maybe=$(( $maybe + $vcnt )) ;;
				*) unerased=$(( $unerased + $vcnt )) ;;
			esac
			status2=`echo "$status" | sed -n '/transfer/p'`
			errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
			;;
	esac
	# Ͽ
	case x"$skip" in
		x0)
			echo "skip: $skip, $status2" >> $LOGFIL
			;;
	esac
	case x"${nerrs}"x"${errormsg}" in
		x[0-8]x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
		x9x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			echo "Too many errors encounterd..." >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
	esac
	# 롼
	checked=$(( $checked + $vcnt ))
	skip=$(( $skip + $vcnt + $step ))
done

sleep 2

#
echo "skip: $skip, $status2" >> $LOGFIL
echo "number of error messages: $nerrs" >> $LOGFIL
echo -n "verify finished on" >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname, $dbytes), max = $max, checked = $checked" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

cursec=`tinydate '+%s'`
elapsed=$(( $cursec - $startsec ))
if [ $elapsed -gt 120 ]; then
	min=$(( $elapsed / 60 ))
	sec=$(( $elapsed - $min * 60 ))
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

unerased=$(( $unerased + $maybe ))
zp=$(( $zero * 100 / $checked ))
op=$(( $one * 100 / $checked ))
np=$(( $unerased * 100 / $checked ))

msg="ǥ ($disk, $dbytes Х) Υåλޤ (${elas})\n"
msg="${msg} $max ֥å $checked ֥å򸡺ޤ\n"
msg="${msg}  '0' ǾõƤ֥å: $zero ($zp %)\n"
msg="${msg}  '1' ǾõƤ֥å: $one ($op %)\n"
msg="${msg}  ʳ (̤õ) Υ֥å: $unerased ($np %)\n"

# ¸
echo "Verified $checked blocks" > /tmp/verify-log.$disk
echo -n " erased with 0:${zp}%, 1:${op}%, " >> /tmp/verify-log.$disk
echo "unerased:${np}%" >> /tmp/verify-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/verify-log.$disk

sh dummyread.sh

# ʤߤޤ?
#echo -n "final confirmation message displayed on " >> $LOGFIL
#date >> $LOGFIL

dialog	--title "$title" \
	--msgbox "$msg" 10 72

exit 0

# EOF
