/*
 *  tinydump -- 512ХȤ16ʥפ
 *
 *  revision history:
 *	0.0: Jul.  7, 2005 by Dai ISHIJIMA
 *	0.1: Sep. 12, 2007 (for wpout09, FreeBSD 6.2R)
 *	0.2: Apr. 18, 2009 (for wpout09, FreeBSD 7.1R, unsigned char)
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#define EOS '\0'

#define BLKSIZ 512
#define NCOLS 16

/* ͤʸѴ */
unsigned char *num2str(long long d, unsigned char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 10);
	++p;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}

/* ͤʸѴ */
unsigned char *num2hex(long long d, int cols, unsigned char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 16);
	if (s[p] > '9') {
	    s[p] += ('a' - '9' - 1);
	}
	++p;
	d /= 16;
    } while (d > 0);
    while (p < cols) {
	s[p] = '0';
	++p;
    }
    s[p] = EOS;
    /* ʸҤä꤫ */
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, unsigned char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


int main()
{
    unsigned char s[BLKSIZ];
    unsigned char t[BLKSIZ];
    int i, j;

    read(STDIN_FILENO, s, BLKSIZ);
    for (i = 0; i < BLKSIZ; i += NCOLS) {
	num2hex(i, 3, t);
	myputs(STDOUT_FILENO, t);
	myputs(STDOUT_FILENO, "  ");
	for (j = 0; j < NCOLS; j++) {
    	    if (j == NCOLS / 2) {
		putch(STDOUT_FILENO, ' ');
	    }
	    num2hex(s[i + j], 2, t);
	    myputs(STDOUT_FILENO, t);
	    putch(STDOUT_FILENO, ' ');
	}
	myputs(STDOUT_FILENO, " ");
	for (j = 0; j < NCOLS; j++) {
	    if ((0x20 < s[i + j]) && (s[i + j] < 0x7f)) {
		putch(STDOUT_FILENO, s[i + j]);
	    }
	    else {
		putch(STDOUT_FILENO, '.');
	    }
	}
	putch(STDOUT_FILENO, '\n');
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -s -static -o tinydump tinydump.c" */
/* End: */
