#! /bin/sh
#
#   erase.sh -- ǡ񤭤ƥǥΥǡõ
#
#	Ȥ: /bin/sh erase.sh -ä ǥ
#		ä: [zfr]
#		ǥ: ǥХեǻꡢƬΡ/dev/פϾʤ
#		: /bin/sh erase.sh -z ad0
#
#	0.0: Jun. 20, 2004 by Dai ISHIJIMA (for wpout03)
#	0.1: Jul. 11, 2004
#	0.2: Jun. 28, 2006 (ѥ for wpout07)
#	0.3: Aug.  1, 2006 (ॹ)
#	0.4: Aug. 12, 2006 (ॹפ)
#	0.5: Feb. 10, 2007 (Ͽ for wpout08)
#	0.6: Feb. 15, 2007 (󥿡Ĺк顼ž®٤Υ)
#	0.7: Sep. 12, 2007 (wpout09)
#	0.8: Oct.  6, 2007 (׻32ӥåդϰϤǹԤ)
#	0.9: Dec. 23, 2007 (Сɽη׻)
#	1.0: Jan.  2, 2008 ()
#	1.1: Mar. 22, 2014 (̤ΤĤ򸺤餹 (򸺤餹))
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"
PATTERNFIL="${PATTERNFIL:-/tmp/pattern.dat}"
dispupd="${DISPUPD:-2}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

if [ ! -s $PATTERNFIL ]; then
	stuff -g > $PATTERNFIL
	echo "random pattern file $PATTERNFIL generated" >> $LOGFIL
fi

#
stuff="${1:--z}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# ٤32MХȤ
blklen="${BLKLEN:-33554432}"
# ϥ֥å1MХ
obs="${OBS:-1048576}"
ocnt=$(( $blklen / $obs ))
ounit=$(( $obs / 1048576 ))
# ϥ֥å1kХ
ibs="${IBS:-1024}"
icnt=$(( $blklen / $ibs ))
#
resultfil=/tmp/result

#
title="${TITLE:-ϡɥǥõġwipe-out}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ǥ $disk ¸ߤʤ񤭹ߤǤޤ" \
		5 64
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "ޥΥǥ $disk õ뤳ȤϤǤޤ" \
	    5 64
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"

case x"$stuff" in
	x-[0z])	msg="${msg}0Ǿ񤭤ƾõޤ\n"
		method='write 0'
		;;
	x-[1f])	msg="${msg}1Ǿ񤭤ƾõޤ\n"
		method='write 1'
		;;
	x-[Rr])	msg="${msg}ǡǾ񤭤ƾõޤ\n"
		method='write random'
		;;
	x-[Pp])	stuff -g > $PATTERNFIL
		echo "random pattern file $PATTERNFIL generated" >> $LOGFIL
		msg="${msg}ѥǾ񤭤ƾõޤ\n"
		method='write pattern'
		;;
	x-[Qq])	msg="${msg}ľѥǾ񤭤ƾõޤ\n"
		method='write inverted pattern'
		;;
	*)	msg="${msg}õޤ\n"
		method='overwrite'
		;;
esac

msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) ΥǡõƤǤ?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

# õΥѥ᡼ (MХñ̤ǿ)
mbytes=`disksize -m /dev/$disk`
max=$(( $mbytes / $ounit ))

startsec=`tinydate '+%s'`
rems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "erase started on " >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname) $bytes bytes with $method" >> $LOGFIL

nerrs=0
skip=0
xcent=100
xmill=1000
mcent=$max
mmill=$max
if [ $max -gt 1048576 ]; then
	xcent=1
	xmill=1
	mcent=$(( ( $max + 99 ) / 100 ))
	mmill=$(( ( $max + 999 ) / 1000 ))
fi
lastdisp=0
dispintv=0
while [ $skip -le $max ]; do
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=$(( ( $xcent * $skip ) / $mcent ))
	m=$(( ( $xmill * $skip ) / $mmill ))
	q=$(( $p / 2 ))
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=$(( $i + 1 ))
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=$(( $i + 1 ))
	done
	# Ĥ
	elapsed=$(( $cursec - $startsec ))
	if [ $elapsed -gt 10 ]; then
		if [ $m -gt 0 ]; then
			remain=$(( ( 1000 - $m ) * $elapsed / $m + 1 ))
			if [ $remain -gt 120 ]; then
				rems=$(( ( $remain + 59 ) / 60 ))
				rems="Ĥ 褽${rems}ʬ"
			else
				rems="Ĥ 褽${remain}"
			fi
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=$(( ( $elapsed + 30 ) / 60 ))
		elas="${elas}ʬ"
	else
		elas="${elapsed}"
	fi
	#
	text="ǥ ${disk} ΥǡõƤޤ\n"
	text="${text} ${p}% ($skip/$max) λ  "
	text="${text}${elas} в  ${rems}  \n\n"
	text="${text}        0%|${bar}|100%"
	text="${text}\n${errormsg}"
	dispintv=$(( $cursec - $lastdisp ))
	if [ $dispintv -ge $dispupd ]; then
		dialog --title "$title" --infobox "$text" 7 72
		lastdisp=$cursec
	else
		echo -e '\r\c'
	fi
	case "x$progchar" in
		xO) progchar='.' ;;
		xo) progchar='O' ;;
		*)  progchar='o' ;;
	esac
	echo -n "$progchar $status2"
	case x$DEBUG in
		x[Yy]*)
			status2='now in debug mode...'
			errormsg=''
			sleep 1
			;;
		*)
			status=`stuff $stuff < $PATTERNFIL | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/$disk 2>&1`
			status2=`echo "$status" | sed -n '/transfer/p'`
			errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
			;;
	esac
	# Ͽ
	case x"$skip" in
		x0)
			echo "skip: $skip, $status2" >> $LOGFIL
			;;
	esac
	case x"${nerrs}"x"${errormsg}" in
		x[0-8]x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
		x9x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			echo "Too many errors encounterd..." >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
	esac
	# 롼
	skip=$(( $skip + $ocnt ))
done

sleep 2

#

echo "skip: $skip, $status2" >> $LOGFIL
echo "number of error messages: $nerrs" >> $LOGFIL
echo -n "erase finished on " >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname, $cap) with $method" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

cursec=`tinydate '+%s'`
elapsed=$(( $cursec - $startsec ))
if [ $elapsed -gt 120 ]; then
	min=$(( $elapsed / 60 ))
	sec=$(( $elapsed - $min * 60 ))
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

# ¸
echo 'The contents of this storage device' > /tmp/erase-log.$disk
echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
echo -n 'were erased with ' >> /tmp/erase-log.$disk
echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
echo "Erased with '$method'" >> /tmp/erase-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk

echo "but NOT verified" > /tmp/verify-log.$disk

sh dummyread.sh
dialog	--title "$title" \
	--msgbox "ǥΥǡõλޤ (${elas})" 5 72

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
