#! /bin/sh
#
#   kon2start.sh -- ȥ󤷤ĤġɤΥ⡼ɤ˰ܹԤ뤫
#
#	0.0: May   5, 2009 by Dai ISHIJIMA (as countdown.sh)
#	0.1: Apr. 11, 2011 for wpout11
#	0.2: Oct. 11, 2013 (use /dev/ttyv0, wpout13)
#	0.3: May  11, 2014 (comconsole -> serial console)
#

export TTY="${TTY:-ttyv0}"
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"

echo ''
echo ''
echo "# select console mode"
echo "    0: Start wipe-out on KON2 (Kanji on console) [default]"
echo "    1: Start wipe-out on KON2 fixed for some Laptops"

if [ -c /dev/cuau0 ]; then
	echo "    c: Start wipe-out on serial console (regacy serial, uart0)"
fi
if [ -c /dev/cuaU0 ]; then
	echo "    u: Start wipe-out on serial console (USB adaptor, ucom0)"
fi

echo "    2: Start interactive shell, stay in Native console (non Japanese)"


prompt="# Just press ENTER to select default mode"

count=9

while [ $count -gt 0 ]; do
	echo -e "\r$prompt[$count] \c"
	if read -t 1 keyin 1>/dev/null 2>&1 ; then
		count=0
	fi
	count=$(( $count - 1 ))
done

case x"$count" in
	x0)
		echo -e "\r$prompt[0] 0"
		keyin=0		
		;;
esac


echo -n "kon2start with keyin = $keyin, " >> $LOGFIL
date >> $LOGFIL

case x"$keyin" in
	x0)
		export KON2MODE=default
		/wipeout/shell-on /dev/ttyv1
		/usr/local/bin/kon -e /wipeout/startup.sh < /dev/ttyv0
		;;
	x2)
		/bin/sh -i
		;;
	xc)
		export TTY=comconsole.cuau0
		dmesg > /dev/cuau0
		/wipeout/shell-on /dev/cuau0 /bin/sh /wipeout/startup.sh
		;;
	xu)
		export TTY=comconsole.cuaU0
		dmesg > /dev/cuaU0
		/wipeout/shell-on /dev/cuaU0 /bin/sh /wipeout/startup.sh
		;;
	*)
		export KON2MODE=FIXed
		/wipeout/shell-on /dev/ttyv1
		/usr/local/bin/kon2fixed FIX -e /wipeout/startup.sh < /dev/ttyv0
		;;

esac

exit 0

# EOF

