#! /bin/sh
#
#   atasecurity.sh -- camcontrol security でデータを消去する
#
#	使い方: /bin/sh atasecurity.sh 方法 ディスク
#		例: /bin/sh atasecurity -e ada0
#
#	0.0: Aug.  4, 2015 by Dai ISHIJIMA (for wpout15, FreeBSD 9.3R)
#	0.1: May  20, 2020 for wpout20, FreeBSD 11.3R
#	0.2: Aug. 12, 2025 for wpout25, FreeBSD 14.2R, ja_JP.UTF-8
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# 単独でも動くように
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

echo "starting ata security ($TTYNAME)" > $STATEFIL

#
method="${1:--e}"
disk="${2:-ada0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"

#
resultfil=/tmp/result

#
title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ディスク $disk が存在しないか、書き込みできません" \
		5 64
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "マウント中のディスク $disk を消去することはできません" \
	    5 64
	exit 1
fi

/bin/sh logdev.sh > /tmp/devices.txt
if [ -s /tmp/devices.txt ]; then
    sed -n "/$disk/p" /tmp/devices.txt > /tmp/checkdev.txt 2>&1
    if [ -s /tmp/checkdev.txt ]; then
	sh dummyread.sh
	msg="${disk}は「wipe-out」の起動メディアと思われます。消去しますか?\n"
	msg="${msg}\n                      よろしいですか?"
	dialog --title "$title" --yesno "$msg" 9 64
	case x"$?" in
	    x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
	esac
    fi
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ディスク ${disk} ${dname} の\n"
msg="${msg}全データ ${bytes}バイトを、\n"
msg="${msg}セキュア消去 (ATA Security) で消去します。\n"
msg="${msg}\n                      よろしいですか?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac


msg="P-ATAデバイスやSCSIデバイス、USB接続のデバイスでは\n"
msg="${msg}セキュア消去 (ATA Security) が動作しなかったり\n"
msg="${msg}正常終了してもデータの消去が実行されていないことがあります。\n"
msg="${msg}\n                      よろしいですか?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac


msg="本当に${disk} ($cap) のデータをセキュア消去していいですか?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac

dialog	--title "$title" \
	--infobox 'ディスクをセキュア消去しています' 3 64

sleep 2

# 開始時刻
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "ata security $method ($TTYNAME) started on " >> $LOGFIL
date >> $LOGFIL

date '+%s' > /tmp/secure-stamp-${TTYNAME}.txt
sh waitsecure.sh /tmp/secure-stamp-${TTYNAME}.txt &
child="$!"
echo "ata security $method $disk ($dname) $bytes bytes" >> $LOGFIL
echo "confirm ata security ($TTYNAME)" > $STATEFIL
script /tmp/sanitize-${TTYNAME}.txt \
	/sbin/camcontrol security $disk -U user
case x"$?" in
	x0)
		stat="ok"
		echo "セキュア消去の事前確認は正常終了しました"  > /tmp/sanitizemsg.txt
		;;
	*)
		stat="failed"
		echo "セキュア消去の事前確認は動作しませんでした" > /tmp/sanitizemsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;
esac
kill $child > /dev/null 2>&1


echo 'erase time: UNKNOWN' > /tmp/erasetime.txt
case "x${method}" in
    x-e)
	sed -n '/^erase time/p' < /tmp/sanitize-${TTYNAME}.txt \
		>> /tmp/erasetime.txt
	;;
    *)
	sed -n '/^erase time/p' < /tmp/sanitize-${TTYNAME}.txt \
		>> /tmp/erasetime.txt
	;;
esac
erasetime=`sed -n '$p' < /tmp/erasetime.txt`
echo "erasetime = $erasetime" >> $LOGFIL

echo '' >> $LOGFIL
echo '::: ATA Security (camcontrol output) :::' >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt
echo '' >> /tmp/sanitizemsg.txt
case x"$stat" in
    xok)
	sh waitsecure.sh /tmp/secure-stamp-${TTYNAME}.txt &
	child="$!"
	echo "erasing $disk with ata security ($TTYNAME)" > $STATEFIL
	script /tmp/sanitize-${TTYNAME}.txt \
		/sbin/camcontrol security $disk -U user -y -s wipe $method wipe
	status="$?"
	kill $child > /dev/null 2>&1
	case "x$status" in
	    x0)
		status="finished"
		echo "セキュア消去は正常終了しました" >> /tmp/sanitizemsg.txt
		echo "セキュア消去は正常終了しました。" > /tmp/dialogmsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;
	    *)
		status="failed"
		echo "セキュア消去は動作しませんでした" >> /tmp/sanitizemsg.txt
		echo "セキュア消去は動作しませんでした。" > /tmp/dialogmsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;

	esac
	nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL
	nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt
esac

cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt

echo -n 'コマンド実行時のログは以下のとおりです。' >> /tmp/dialogmsg.txt
echo '上下カーソルキーでスクロールします。' >> /tmp/dialogmsg.txt
echo '' >> /tmp/dialogmsg.txt
echo '/* ======== */' >> /tmp/dialogmsg.txt
cat /tmp/sanitizemsg.txt >> /tmp/dialogmsg.txt

echo "show result of ata security ($TTYNAME)" > $STATEFIL

sh dummyread.sh
dialog	--title 'セキュア消去のログ' --textbox /tmp/dialogmsg.txt 19 76

#

echo -n "sanitize $status on " >> $LOGFIL
date >> $LOGFIL
echo "sanitize $disk ($dname, $cap)" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

# 終了時刻
endstamp=`date '+%H:%M'`

case x"$status" in
    xfinished)
	# ログ保存
	echo 'The contents of this storage device' > /tmp/erase-log.$disk
	echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
	echo -n 'were erased with ' >> /tmp/erase-log.$disk
	echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
	echo "Erased with 'ATA SECURITY'" >> /tmp/erase-log.$disk
	echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk
	echo "but NOT verified" > /tmp/verify-log.$disk
	;;
esac

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
