#! /bin/sh
#
#   embr.sh -- MBRのみ消去する
#
#	使い方: /bin/sh embr.sh ディスク
#		ディスク: デバイスファイルで指定、先頭の「/dev/」は省く
#		例: /bin/sh embr.sh ad0
#
#	0.0: Dec. 21, 2006 by Dai ISHIJIMA (for wpout07)
#	0.1: Feb. 10, 2007 (ログ記録 for wpout08)
#	0.2: Feb. 15, 2007 (エンターキー長押し対策)
#	0.3: Sep. 12, 2007 (wpout09)
#	0.4: Jan.  2, 2008 (ログ修正)
#	0.5: Aug. 12, 2025 (wpout25, 14.2R, ja_JP.UTF-8)
#

LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
disk="${1:-ad0}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

#if [ ! -w /dev/$disk ]; then
#	echo "$0: disk '$disk' does not exist or is not writable"
#	echo "Usage: $0 disk"
#	echo "Example: $0 ad0"
#	exit 1
#fi

title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`

msg="ディスク ${disk} ${dname} の\n"
msg="${msg}MBR (マスタ・ブート・レコード; 先頭セクタ)\n"
msg="${msg}*だけ* を消去します。\n"
msg="${msg}\n"
msg="${msg}MBRを消すと、ディスク上のすべてのデータが\n"
msg="${msg}なくなったかのように見えます。しかし、\n"
msg="${msg}復元ツールで元に戻すことも可能なので\n"
msg="${msg}情報漏洩の危険があります。ご注意ください。\n"
msg="${msg}\n          よろしいですか?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 15 52

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac

msg="ディスク ${disk} のMBR消去を中止しますか?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x0)
		dialog	--title "$title" \
			--infobox 'ディスクの消去をキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
esac

echo "v ---------------------------- v" >> $LOGFIL
echo -n "erase MBR ($disk)  started on " >> $LOGFIL
date >> $LOGFIL

case x$DEBUG in
    x[Yy]*)
	echo -n "now in debug mode..."
	echo 'debug mode' >> $LOGFIL
	;;
    *)
	dd bs=512 count=1 if=/dev/zero of=/dev/$disk
	;;
esac

sleep 3

#
echo -n "erase MBR ONLY $disk ($dname) on " >> $LOGFIL
date >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

sh dummyread.sh
dialog	--title "$title" \
	--msgbox "MBRの消去が終了しました" 5 64

exit 0

# EOF
