#! /bin/sh
#
#   sel-fine.sh - 念入り消去法の選択
#
#	0.0: Jun. 26, 2004 by Dai ISHIJIMA
#	0.1: Jul.  9, 2005
#	0.2: Jun. 28, 2006 (ランダムパターンと補数 for wpout07)
#	0.3: Feb. 18, 2007 (15回消去を追加 for wpout08)
#	0.4: Jan. 15, 2017 (誤字修正、パターン追加)
#	0.5: Aug. 12, 2025 (wpout25, 14.2R, ja_JP.UTF-8, ↓↑→は文字欠けする)
#

resultfil=/tmp/result

stuffs="${stuffs:-10}"
title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

dialog	2>$resultfil \
	--title "$title" \
	--menu '消去方法を選択してください。上下キーでスクロールします。' \
	19 74 12 \
	10		'1=>0の順に2回上書きする' \
	01		'0=>1の順に2回上書きする' \
	0R		'0=>ランダムの順に2回上書きする' \
	PQ		'パターン=>補数の順に2回上書きする'		\
	R0		'ランダム=>0の順に2回上書きする'		\
	RR0		'ランダム=>ランダム=>0の順に3回上書きする'	\
	R10		'ランダム=>1=>0の順に3回上書きする'		\
	PQ0		'ランダムパターン=>補数=>0の順に3回上書きする'	\
	5A0		'0x55=>0xAA=>0の順に3回上書きする'		\
	PQR		'パターン=>補数=>ランダムの順に3回上書き'	\
	5AR		'0x55=>0xAA=>ランダムの順に3回上書きする'	\
	01R		'0=>1=>ランダムの順に3回上書きする'	\
	RR10		'ランダム×2=>1=>0の順に4回上書きする'		\
	1010		'1=>0=>1=>0の順に4回上書きする'			\
	0101		'0=>1=>0=>1の順に4回上書きする'			\
	PQ10		'パターン=>補数=>1=>0の順に4回上書きする'	\
	PQR0		'パターン=>補数=>ランダム=>0の順に4回上書き'	\
	5AR0		'0x55=>0xAA=>ランダム=>0の順に4回上書き'	\
	01010		'(0=>1)×2=>0の順に5回上書きする'		\
	RRR10		'ランダム×3=>1=>0の順に5回上書きする'		\
	PQPQ0		'(パターン=>補数)×2=>0の順に5回上書きする'	\
	101010		'1=>0=>1=>0=>1=>0の順に6回上書きする'		\
	RRRR10		'ランダム×4=>1=>0の順に6回上書きする'		\
	PQPQ10		'(パターン=>補数)×2=>1=>0の順に6回上書き'	\
	0101010		'(0=>1)×3=>0の順に7回上書きする'		\
	R101010		'ランダム=>1=>0=>1=>0=>1=>0の順に7回上書き'	\
	5A5A5AR		'(0x55=>0xAA)×3=>ランダムの順に7回上書き'	\
	R10R10R10	'(ランダム=>1=>0)×3の順に9回上書きする'	\
	PQRPQRPQR0	'(パターン=>補数=>ランダム)×3=>0の順に10回'	\
	PQRPQRPQR10	'(パータン=>補数=>ランダム)×3=>1=>0の順に11回' \
	R10R10R10R10	'(ランダム=>1=>0)×4の順に12回上書きする'	\
	PQRPQRPQRPQR0	'(パターン=>補数=>ランダム)×4=>0の順に13回'	\
	PQRPQRPQRPQR10	'(パターン=>補数=>ランダム)×4=>1=>0の順に14回' \
	PQR10PQR10PQR10	'(パターン=>補数=>ランダム=>1=>0)×3の順に15回' \

case x"$?" in
	x0)
		newstuff=`cat $resultfil`
		if [ x"$stuffs" != x"$newstuff" ]; then
			msg="消去方法を ${stuffs} から"
			msg="${msg} ${newstuff} に変更しました。"
			dialog	--title "$title" \
				--infobox "$msg" 3 72
			sleep 2
		fi
		stuffs="$newstuff"
		;;	
	x1)
		dialog	--title "$title" \
			--infobox '消去方法の選択をキャンセルしました' 3 64
		sleep 2
		;;
esac

# EOF
