/*
 *  disksize -- ǥΥȥ
 *
 *  revision history
 *	diskinfo:
 *	0.0: Sep.  6, 2002 by Dai ISHIJIMA (ȤꤢС)
 *	0.1: Oct. 21, 2002
 *	0.2: Apr. 28, 2004
 *	0.3: May   1, 2004
 *	0.4: May  30, 2004
 *	0.5: Jun. 19, 2004
 *	0.6: Aug.  5, 2006 (äȽ)
 *	0.7: Aug. 12, 2006 (ͭβ)
 *	disksize:
 *	0.9: Sep. 12, 2007 (exit(3), ѥ᡼ˡѹ)
 *	1.0: Oct.  2, 2007 (MХñ̤Ǥɽ)
 *	1.1: Aug. 23, 2025 (FreeBSD 14.2, fstat(2))
 *
 *  ʸ:
 *	fdisk(8) Υ (/usr/src/sbin/i386/fdisk/fdisk.c)
 *	wpout09ʹ (/usr/src/sbin/fdisk/fdisk.c), diskinfo(8)
 */

#include <stdlib.h>
#include <sys/disk.h>
#include <sys/disklabel.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>


#define SHOW_CYLS 1
#define SHOW_HEAD 2
#define SHOW_SECS 4
#define SHOW_BYTES 8
#define SHOW_BYTES_WITH_UNITS 16
#define SHOW_BLOCKS 32
#define SHOW_BYTES_WITH_COMMA 64
#define SHOW_MEGABYTES 128

#define shift --argc; ++argv


#define DFLT_DISK "/dev/ad0"
#define EOS '\0'
#define NEWLINE '\n'

#ifndef BUFSIZ
#define BUFSIZ 512
#endif

#define MEGABYTES (1024 * 1024)


/* ͤʸѴ */
char *num2str(off_t d, char *s)
{
    int p;
    int q;
    int ch;

    p = 0;
    do {
	s[p] = '0' + (d % 10);
	++p;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ͤʸѴ, ޶ڤ */
char *num2commastr(off_t d, char *s)
{
    int p;
    int q;
    int n;
    int ch;

    p = 0;
    n = 0;
    do {
	if ((n > 0) && ((n % 3) == 0)) {
	    s[p] = ',';
	    ++p;
	}
	s[p] = '0' + (d % 10);
	++p;
	++n;
	d /= 10;
    } while (d > 0);
    s[p] = EOS;
    for (q = 0; q < p / 2; q++) {
	ch = s[q];
	s[q] = s[p - q - 1];
	s[p - q - 1] = ch;
    }
    return(s);
}


/* ʸ */
void putch(int fd, unsigned char ch)
{
    write(fd, &ch, 1);
}


/* ʸ */
void myputs(int fd, char *s)
{
    while (*s) {
	putch(fd, *s);
	++s;
    }
}


int main(int argc, char *argv[])
{
    char *disk;
    char s[BUFSIZ];
    int show;
    int fd;
    off_t mediasize, blocks;
    off_t secsiz, nsecs, nhead, ncyls;
    unsigned char units[] = { 'k', 'M', 'G', 'T', EOS };
    int p;
    off_t m;
    int fraction;
#ifndef OBSOLATED
    struct stat sb;
#endif

    mediasize = blocks = secsiz = nsecs = nhead = ncyls = 0;
    show = 0;
    shift;
    while ((argc > 0) && (argv[0][0] == '-')) {
	if (argv[0][1] == 'c') {
	    show |= SHOW_CYLS;
	}
	else if (argv[0][1] == 'h') {
	    show |= SHOW_HEAD;
	}
	else if (argv[0][1] == 's') {
	    show |= SHOW_SECS;
	}
	else if (argv[0][1] == 'b') {
	    show |= SHOW_BYTES;
	}
	else if (argv[0][1] == 'm') {	/* MХñ̤ */
	    show |= SHOW_MEGABYTES;
	}
	else if (argv[0][1] == 'B') {	/* Хȿ򥳥޶ڤ */
	    show |= SHOW_BYTES_WITH_COMMA;
	}
	else if (argv[0][1] == 'p') {	/* Ŭñդk, M, G, etc. */
	    show |= SHOW_BYTES_WITH_UNITS;
	}
	else if (argv[0][1] == 'l') {
	    show |= SHOW_BLOCKS;
	}
	else {
	    myputs(STDERR_FILENO, "Usage: diskinfo [-chsbBpl] [device]\n");
	    exit(1);
	}
	shift;
    }
    if (show == 0) {
	show = SHOW_BYTES | SHOW_CYLS | SHOW_HEAD | SHOW_SECS;
    }
    if (argc > 0) {
	disk = *argv;
    }
    else {
	disk = DFLT_DISK;
    }
    if ((fd = open(disk, O_RDONLY)) < 0) {
	myputs(STDERR_FILENO, "diskinfo: unable to open disk ");
	myputs(STDERR_FILENO, disk);
	putch(STDERR_FILENO, NEWLINE);
	exit(1);
    }
    /* FreeBSD 5.1ʹߤ餤ǡioctl(fd, DIOCGDINFO, &disklabel)*/
    /* Ȥʤʤä? */
#if OBSOLATED
    if (ioctl(fd, DIOCGSECTORSIZE, &secsiz) != 0) {
	myputs(STDERR_FILENO, "diskinfo: can't get sectorsize\n");
	exit(1);
    }
    if (ioctl(fd, DIOCGMEDIASIZE, &mediasize) != 0) {
	myputs(STDERR_FILENO, "diskinfo: can't get mediasize\n");
	exit(1);
    }
    if (ioctl(fd, DIOCGFWSECTORS, &nsecs) != 0) {
	myputs(STDERR_FILENO, "diskinfo: can't get number of sectors\n");
	exit(1);
    }
    if (ioctl(fd, DIOCGFWHEADS, &nhead) != 0) {
	myputs(STDERR_FILENO, "diskinfo: can't get number of heads\n");
	exit(1);
    }
    blocks = mediasize / secsiz;
    ncyls = mediasize / (secsiz * nhead * nsecs);
#else
    /* /usr/src/usr.sbin/diskinfo/diskinfo.c */
    if (fstat(fd, &sb)) {
	myputs(STDERR_FILENO, "disksize: can't fstat(2)\n");
	exit(1);
    }
    if (S_ISREG(sb.st_mode)) { /* regular file */
	mediasize = sb.st_size;
	secsiz = 0;
	blocks = 0;
	ncyls = 0;
    }
    else {	/* device file */
	if (ioctl(fd, DIOCGMEDIASIZE, &mediasize)) {;
	    myputs(STDERR_FILENO, "disksize: ioctl(DIOCGMEDIASIZE) failed\n");
	    exit(1);
	}
	if (ioctl(fd, DIOCGSECTORSIZE, &secsiz)) {
	    myputs(STDERR_FILENO, "disksize: ioctl(DIOCGSECTORSIZE) failed\n");
	    exit(1);
	}
	if ((show & SHOW_SECS) && (ioctl(fd, DIOCGFWSECTORS, &nsecs))) {
	    myputs(STDERR_FILENO, "disksize: ioctl(DIOCGFWSECTORS) failed\n");
	    /* exit(1); */ /* warn only */
	}
	if ((show & SHOW_HEAD) && (ioctl(fd, DIOCGFWHEADS, &nhead))) {
	    myputs(STDERR_FILENO, "disksize: ioctl(DIOCGFWHEADS) failed\n");
	    /* exit(1); */ /* warn only */
	}
	if ((show & SHOW_CYLS) && (secsiz > 0) && (nsecs > 0) && (nhead > 0)) {
	    ncyls = mediasize / (secsiz * nsecs * nhead);
	}
    }
#endif
    if (show & SHOW_BLOCKS) {
	num2str(blocks, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_BYTES) {
	num2str(mediasize, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_MEGABYTES) {
	num2str((mediasize + MEGABYTES - 1) / MEGABYTES, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_BYTES_WITH_COMMA) {
	num2commastr(mediasize, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_BYTES_WITH_UNITS) {
	m = mediasize / 1024;
	p = 0;
	fraction = 0;
	while ((m > 1000) && (units[p] != EOS)) {
	    fraction = ((m * 10) / 1024) % 10;
	    m /= 1024;
	    ++p;
	}
	num2str(m, s);
	myputs(STDOUT_FILENO, s);
	if (m < 10) {
	    putch(STDOUT_FILENO, '.');
	    num2str(fraction, s);
	    myputs(STDOUT_FILENO, s);
	}
	putch(STDOUT_FILENO, units[p]);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_CYLS) {
	num2str(ncyls, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_HEAD) {
	num2str(nhead, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    if (show & SHOW_SECS) {
	num2str(nsecs, s);
	myputs(STDOUT_FILENO, s);
	putch(STDOUT_FILENO, NEWLINE);
    }
    exit(0);
}

/* Local Variables: */
/* compile-command:"cc -Wall -O -s -o disksize disksize.c" */
/* End: */
