#! /bin/sh
#
#   ログ保存先デバイスを探す
#
#	0.0: May  21, 2020 by Dai ISHIJIMA (for v2.0, FreeBSD 11.3R)
#	0.1: Sep.  1, 2025 (for v2.5, FreeBSD 14.2R, GPT partition)
#

searchfor="/dev/fd0 /dev/da0 /dev/da*s* /dev/da*p*"
ndevs=0
cp /dev/null /tmp/logdevs.txt
for dev in $searchfor ; do
    if [ -w $dev ]; then
	echo -e "\r                                        \r\c" 1>&2
	echo -n "checking $dev" 1>&2
	if mount_msdosfs -s -o rdonly $dev /floppy > /dev/null 2>&1; then
		if [ -d /floppy/wipe-out ]; then
			echo $dev >> /tmp/logdevs.txt
			ndevs=$(( $ndevs + 1 ))
		fi
		umount /floppy
	fi
    fi
done

cat "/tmp/logdevs.txt" | sed 's|/dev/||'
exit 0

# EOF
