#! /bin/sh
#
#   mainmenu.sh -- CD-ROM版メインメニュー
#
#	0.0: Jun. 20, 2004 by Dai ISHIJIMA (for wpout03)
#	0.1: Jul. 11  2004 (for wpout04)
#	0.2: Jun. 23  2005 (for wpout05)
#	0.3: Jul.  8  2005 (for wpout06)
#	0.4: Aug.  5, 2006 (for wpout07)
#	0.5: Dec. 21, 2006 (erase MBR)
#	0.6: Feb. 10, 2007 (ログ記録 for wpout08)
#	0.7: Feb. 15, 2007 (エンターキー長押し対策)
#	0.8: Feb. 18, 2007 (メニューの順番を変更)
#	0.9: Sep. 12, 2007 (wpout09, FreeBSD 6.2R)
#	1.0: Sep. 17, 2007 (shutdown時の画面復帰)
#	1.1: Oct.  6, 2007 (expr(1) のPOSIX準拠対応)
#	1.2: Feb. 10, 2008 (ヘルプメッセージの表示、動作ログの表示)
#	1.3: Apr. 19, 2009 (高速ディスクコピー, wpout10)
#	1.4: Sep. 30, 2009 (IBM ServeRAID, ips(4), /dev/ipsd%d)
#	1.5: Dec. 22, 2012 (smartctl)
#	1.6: Feb.  1, 2014 (先頭に戻る)
#	1.7: Aug.  4, 2015 (FreeBSD 9.3R, camcontrol sanitize)
#	1.8: Nov.  8, 2015 (スクリーンセーバー)
#	1.9: Dec.  4, 2016 (ttyname)
#	2.0: Jan.  2. 2017 (既存FreeBSD上のアプリとして動作)
#	2.1: Aug. 12, 2017 (v1.7, FreeBSD 11.1R)
#	2.2: Aug.  3, 2018 (pre v1.8, FreeBSD 11.2R)
#	2.3: Sep. 23, 2019 (pre v1.9, FreeBSD 12.0R)
#	2.4: May   6, 2020 (pre v2.0, FreeBSD 11.3R)
#	2.5: Aug.  8, 2021 (pre v2.1, FreeBSD 12.2R)
#	2.6: Oct. 16, 2021 (pre v2.1, FreeBSD 12.2R), 埼玉県教委
#	2.7: Jul. 12, 2025 (pre v2.5, FreeBSD 14.2R, ja_JP.UTF-8)
#	2.8: Aug. 23, 2025 (diskinfo)
#

# メインメニューのエラーを保存する
exec 2>/tmp/mm-error-$TTY.txt

# 
dmesg="${DMESG:-/var/run/dmesg.boot}"
devices="${DEVICES:-'nda|nvd|da|ada|aacd|amrd|idad|ipsd|mfid|mlxd|twed|ad|ar}"

#
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
export ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
export DISPUPD="${DISPUPD:-5}"
export STATEFIL="${STATEFIL:-/tmp/status.txt}"
export HISTFIL="${HISTFIL:-/tmp/history.txt}"
export WIPEOUTDIR="${WIPEOUTDIR:-/wipeout}"
# 2020-05-18
export CHIMEMIN="${CHIMEMIN:-10}"
export EPOCH="${EPOCH:-1589760000}" # Mon May 18 09:00:00 JST 2020
export SID="${SID:-ABCD:EFGH}"

cbs="${CBS:-512}"
obs="${OBS:-1048576}"

resultfil=/tmp/result
nsec=/tmp/sector
nmin=/tmp/chime		# 2020-05-22
stuffs='10'

##sed -n -E "/^(${devices})[0-9][0-9]*:.*</p" $dmesg |
##	sed 's/^\([a-z][a-z]*[0-9][0-9]*\).*/\1/' > $resultfil
sed -n -E "/^(${devices})[0-9][0-9]*:.*B [<(]/p" $dmesg |
	sed 's/^\([a-z][a-z]*[0-9][0-9]*\).*/\1/' > $resultfil

disk=`sed -n '1p' $resultfil`

export VERSION=`cat /version.txt`
export VOLID=`cat /volume.id`

ttyname=`tty | sed 's+/dev/++' | sed 's|/|.|'`
export TTYNAME="$ttyname"
TITLE="ストレージ消去ツール『wipe-out』"
export TITLE="$TITLE v$VERSION (${ttyname}/${SID})"
dumpskip=0

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script mainmenu.sh ($ttyname) started on " >> $LOGFIL
date >> $LOGFIL

echo '# ---------------------------- #' >> $ERRORLOG
echo -n "script mainmenu.sh ($ttyname) started on " >> $ERRORLOG
date >> $ERRORLOG

credit=''
if [ -s /credit.txt ]; then
	credit=`sed -n 1p /credit.txt`
fi
case x"$credit" in
	x)
		credit="超消わいぷたん・名前入れサービス"
		;;
	*)
		hlinecredit="--hline $credit"
		dialog	--title "$TITLE" \
		--hline 'Press ENTER or wait a seconds...' \
		--infobox "$credit" 3 72
		prompt="press ENTER key or wait a second... "
		count=5
		. ncountdown.sh
		;;
esac

while true ; do
	dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`disksize -B /dev/$disk`
	cap=`disksize -p /dev/$disk`

	echo '# ---------------------------- #' >> $ERRORLOG
	echo -n "preparing mainmenu ($ttyname)" >> $ERRORLOG
	date >> $ERRORLOG

	# 2025-08-23
	echo '# ---------------------------- #' >> $ERRORLOG
	diskinfo -v >> $ERRORLOG

	# ★マークは化ける => ** に
	msg="                   #%** メインメニュー **%#\n"
	msg="${msg}現在選択中のディスクは /dev/${disk} ${dname} です。\n"
	msg="${msg}ディスクの容量は $bytes バイト ($cap) です。\n"
	msg="${msg}以下のメニューから"
	msg="${msg}上下カーソルキーで処理を選択してください。\n"

	echo 'displaying main menu' >> $HISTFIL
	cp /dev/null $STATEFIL

	sh dummyread.sh
	dialog 	2>$resultfil \
		$hlinecredit --title "$TITLE" \
		--menu "$msg" \
		21 74 9 \
		z '0を上書きして、このディスクのデータを消す' \
		E 'ATA SSD/HDDを (ATA Securityで) セキュア消去する' \
		v 'データが消去されたか確認する (高速／一部をチェック)' \
		V 'データが消去されたか確認する (通常／全部をチェック)' \
		L '動作記録をUSBメモリやフロッピーに書き出す' \
		n '複数回上書きして、このディスクのデータを念入りに消す' \
		m '念入り消去の上書き方法を選択する' \
		s '別のディスクを選択する' \
		d 'ディスクのデータを表示する' \
		h '下にも続きがあります／操作方法の概要を表示する' \
		S 'データを表示するセクタの指定' \
		a '「『wipe-out』について」を見る' \
		C '表示をスクリーンセーバーに切り替える' \
		D '起動時のシステムメッセージを確認する' \
		P '動作記録を表示する' \
		Y 'ディスクをコピーする（高速／バックアップ向け）' \
		y 'ディスクをコピーする（低速／データサルベージ向け）' \
		f '1を上書きして、このディスクのデータを消す' \
		p 'ランダムパターンを上書きして、このディスクのデータを消す' \
		q 'パターンの補数を上書きして、このディスクのデータを消す' \
		r 'ランダムデータを上書きして、このディスクのデータを消す' \
		T 'ディスクの自己診断情報 (SMART情報) を表示する' \
		Z 'サニタイズ機能 (SCSI Sanitize) でセキュア消去する' \
		X 'ATA SSD/HDDをエンハンストセキュア消去する' \
		O 'サニタイズ機能でセキュア消去する (BLOCKモード)' \
		F '固定文字列を上書きして、このディスクのデータを消す' \
		K '消去対象ディスクを手動で設定する' \
		w '消去ログをディスクの先頭に書き込む' \
		b 'シェル (sh) を起動する' \
		t 'シェル (csh) を起動する' \
		M 'CD-ROMをmountする' \
		U 'CD-ROMをumountする' \
		B 'MBR *のみ* を消去する' \
		c '終了時のチャイム時間を設定する' \
		x 'シャットダウンする' \
		R '再起動する' \
		N 'メニューの先頭に戻る' \
		# end of menu
	case x"$?" in
		x1)
			break
			;;
	esac

	result=`cat $resultfil`

	case x"${result}" in
		x[zfrpq])
			echo "starting erase ($ttyname)" >> $HISTFIL
			sh erase.sh -$result $disk
			;;
		xF)
			echo "starting erase ($ttyname)" >> $HISTFIL
			cp mani.txt $PATTERNFIL
			sh erase.sh -F $disk
			;;
		xE)
			echo -n 'starting ata secure erase ' >> $HISTFIL
			echo "($ttyname)" >> $HISTFIL
			sh atasecurity.sh -e $disk
			;;
		xX)
			echo -n 'starting ata enhanced ' >> $HISTFIL
			echo "secure erase ($ttyname)" >> $HISTFIL
			sh atasecurity.sh -h $disk
			;;
		xh)
			echo "displaying instruction ($ttyname)" >> $HISTFIL
			dialog	--title '操作方法の概要' \
				--textbox help.txt 20 76
			;;
		xs)
			echo "selecting disk ($ttyname)" >> $HISTFIL
			. seldisk.sh
			;;
		xn)
			echo "starting fine erase ($ttyname)" >> $HISTFIL
			sh fine-erase.sh $stuffs $disk
			;;
		xm)
			echo "selecting erase method ($ttyname)" >> $HISTFIL
			. sel-fine.sh
			;;
		xv)
			echo "starting quick verify ($ttyname)" >> $HISTFIL
			sh verify.sh 90 $disk
			;;
		xV)
			echo "starting verify ($ttyname)" >> $HISTFIL
			sh verify.sh 0 $disk
			;;
		xw)
			echo "writing log ($ttyname)" >> $HISTFIL
			sh writelog.sh $disk
			;;
		xL)
			echo "saving log ($ttyname)" >> $HISTFIL
			sh floppylog.sh
			;;
		xd)
			echo "dump sector ($ttyname)" >> $HISTFIL
			sh dump.sh $dumpskip $disk
			dumpskip=`expr $dumpskip + 1`
			;;
		xS)
			echo "selecting sector ($ttyname)" >> $HISTFIL
			msg="セクタを指定してください ($dumpskip)"
			dialog	2>$nsec \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> $nsec
				echo "$dumpskip" >> $nsec
				dumpskip=`sed -n '/^[0-9]/p' $nsec | sed -n 1p`
				;;
			esac
			;;
		xa)
			echo "displaying about ($ttyname)" >> $HISTFIL
			dialog	--title '『wipe-out』について' \
				--textbox info.txt 20 76
			;;
		xC)
			echo "displaying saver ($ttyname)" >> $HISTFIL
			msg='Alt+F8を押すとスクリーンセーバーに切り替えます。'
			msg="${msg}\nアプリモードやシリアルコンソール"
			msg="${msg}では動作しません。"
			dialog	--title "$TITLE" \
				--msgbox "$msg" 6 64
			;;
		xD)
			echo -n "displaying system message " >> $HISTFIL
			echo "($ttyname)" >> $HISTFIL
			dialog	--title '起動時のシステムメッセージ' \
				--textbox /var/run/dmesg.boot 20 76
			;;
		xy)
			echo "starting copy ($ttyname)" >> $HISTFIL
			srcdisk=$disk
			. seldisk.sh
			dstdisk=$disk
			sh copy.sh $srcdisk $dstdisk $cbs
			disk=$srcdisk
			;;
		xY)
			echo "starting quick copy ($ttyname)" >> $HISTFIl
			srcdisk=$disk
			. seldisk.sh
			dstdisk=$disk
			sh copy.sh $srcdisk $dstdisk $obs
			disk=$srcdisk
			;;
		xP)
			echo "displaying history ($ttyname)" >> $HISTFIL
			echo "::: $LOGFIL ($ttyname) :::" > /tmp/loglog.txt
			cat $LOGFIL >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			for f in /tmp/erase-log.* ; do
				if [ -f "$f" ]; then
					echo "::: $f :::" >> /tmp/loglog.txt
					cat $f >> /tmp/loglog.txt
					echo '' >> /tmp/loglog.txt
				fi
			done
			for f in /tmp/verify-log.* ; do
				if [ -f "$f" ]; then
					echo "::: $f :::" >> /tmp/loglog.txt
					cat $f >> /tmp/loglog.txt
					echo '' >> /tmp/loglog.txt
				fi
			done
			echo '::: history :::' >> /tmp/loglog.txt
			cat $HISTFIL		 >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			echo '::: shell variables :::' >> /tmp/loglog.txt
			set >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			dialog	--title '動作ログ' \
				--textbox /tmp/loglog.txt 20 76
			;;
		xT)
			echo "displaying smart info ($ttyname)" >> $HISTFIL
			if [ ! -x /usr/local/sbin/smartctl ]; then
				echo '::: no smartctl found :::' >> $LOGFIL
				dialog	--title "$TITLE" \
				--msgbox 'smartctl(8) がありません' 5 64
			else
				echo -n "displaying " >> $HISTFIL
				echo -n "smart infomation " >> $HISTFIL
				echo "($TTYNAME)" >> $HISTFIL
				/usr/local/sbin/smartctl -s on /dev/$disk \
					> /tmp/smart.txt 2>&1
				/usr/local/sbin/smartctl -a /dev/$disk \
					>> /tmp/smart.txt 2>&1
				case x"$?" in
				    x0)
					echo "SMARTは正常終了しました" \
						> /tmp/smartmsg.txt
					;;
				    *)
					echo "SMARTは動作しませんでした" \
						> /tmp/smartmsg.txt
					;;
				esac
				echo '' >> $LOGFIL
				echo '::: SMART (smartctl output) :::' \
					>> $LOGFIL
				echo cat /tmp/smart.txt >> $LOGFIL
				cat /tmp/smart.txt >> /tmp/smartmsg.txt
				dialog	--title 'SMARTログ' \
					--textbox /tmp/smartmsg.txt 20 76
			fi
			;;
		xZ)
			echo "starting sanitize ($ttyname)" >> $HISTFIL
			sh sanitize.sh crypto $disk
			;;
		xO)
			echo "starting block sanitize ($ttyname)" >> $HISTFIL
			sh sanitize.sh block $disk
			;;
		xK)
			echo "selecting disk (manual) ($ttyname)" >> $HISTFIL
			msg="ディスクを指定してください ($disk)"
			dialog	2>/tmp/diskname \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> /tmp/diskname
				echo "$disk" >> /tmp/diskname
				cat /tmp/diskname |	
					sed -n '/^[a-z][a-z]*[0-9][0-9]*/p' |
					sed -n 1p > /tmp/diskname.new
				disk=`cat /tmp/diskname.new`
				;;
			esac
			;;
		xb)
			echo "starting shell ($ttyname)" >> $HISTFIL
			stamp=`date +%y%m%d%H`
			/usr/bin/script -a /tmp/${stamp}.txt /bin/sh -i
			;;
		xt)
			echo "starting shell ($ttyname)" >> $HISTFIL
			stamp=`date +%y%m%d%H`
			/usr/bin/script -a /tmp/${stamp}.txt /bin/csh -i
			;;
		xM)
			echo "mounting CD-ROM ($ttyname)" >> $HISTFIL
			if [ -r /cdrom/verstion.txt ]; then
				msg='CD-ROMはすでにマウントされています'
			elif mount_cd9660 $CDROM /cdrom > /dev/null 2>&1; then
				msg='CD-ROMをマウントしました'
			else
				msg='CD-ROMをマウントできませんでした'
			fi
			dialog	--title "$TITLE" \
				--msgbox "$msg" 5 64
			;;
		xU)
			echo "unmounting CD-ROM ($ttyname)" >> $HISTFIL
			msg=''
			if [ ! -r /cdrom/verston.txt ]; then
				msg='CD-ROMはすでにアンマウントされています'
			fi
			if umount /cdrom > /dev/null 2>&1; then
				msg='CD-ROMをアンマウントしました'
			elif [ -z "$msg" ]; then
				msg='CD-ROMアンマウントできませんでした'
			fi
			dialog	--title "$TITLE" \
				--msgbox "$msg" 5 64
			;;
		xc)
			echo "setting chime idle time ($ttyname)" >> $HISTFIL
			msg="終了時チャイム設定 ($CHIMEMIN) 分"
			dialog	2>$nmin \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> $nmin
				echo "$CHIMEMIN" >> $nmin
				CHIMEMIN=`sed -n '/^[0-9]/p' $nmin | sed -n 1p`
				export CHIMEMIN
				;;
			esac
			;;
		xB)
			echo "erasing MBR ($ttyname)" >> $HISTFIL
			sh embr.sh $disk
			;;
		xx)
			echo "starting shutdown ($ttyname)" >> $HISTFIL
			echo "halt" > /var/run/nologin
			vidcontrol -s 1 < /dev/ttyv0
			echo '' > /dev/console
			echo 'シャットダウンします。' > /dev/console
			(sleep 30; /sbin/shutdown -p now) > /dev/null 2>&1 &
			exit 1
			;;
		xR)
			echo "starting reboot ($ttyname)" >> $HISTFIL
			echo "reboot" > /var/run/nologin
			vidcontrol -s 1 < /dev/ttyv0
			echo '' > /dev/console
			echo '再起動します。' > /dev/console
			(sleep 30; /sbin/shutdown -r now) > /dev/null 2>&1 &
			exit 1
			;;
		#xN)
		#	NOP
		#	;;
	esac
done

dialog	--title "$TITLE" \
	--infobox '終了します' 3 64

echo "「/bin/sh ${WIPEOUTDIR}/mainmenu.sh」でメニュー画面を呼び出せます。"
echo ''

exit 0

# EOF
