#! /bin/sh
#
#   atasecurity.sh -- 奢õ
#
#	0.0: May  18, 2020 (for v20, FreeBSD 11.3R)
#

disk="${1:-ada0}"
method="${2:--e}"

dmesg=/var/run/dmesg.boot
dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

echo ''; echo ''; echo ''
echo "*** secure erase data on ${disk} ${dname}, ${bytes} bytes"

echo -n "Ok? [y/n]: "
read ans
case x"$ans" in
	xy)	;;
	*)	echo 'canceled'; exit 1;;
esac

echo -n "Really? [yes/no]: "
read ans
case x"$ans" in
	xyes)	;;
	*)	echo 'canceled'; exit 1;;
esac

/sbin/camcontrol security $disk -U user 2>&1

sh timer.sh &
child=$!
/sbin/camcontrol security $disk -U user -y -s wipe $method wipe 2>&1
case "x$?" in
    x0)
	status="finished"
	echo "secure erase successfully finished"
	;;
    *)
	status="failed"
	echo "secure erase failed"
	;;
esac
kill $child > /dev/null 2>&1

echo -n 'Press ENTER to return menu...'
read x

exit 0

# EOF
