#! /bin/sh
#
#   seldisk.sh - ディスクの選択
#
#	ダイアログボックスを表示してディスクを選択、あるいは入力する。
#	デバイスファイル名を返す。
#
#	0.0: May  30, 2004 by Dai ISHIJIMA
#	0.1: Jun. 29, 2006 (support some more disk types)
#	0.2: Sep. 12, 2007 (wpout09)
#	0.3: Aug. 12, 2025 (wpout25, 14.2R, ja_JP.UTF-8)
#

dmesg="${DMESG:-/var/run/dmesg.boot}"
devices="${DEVICES:-da|ad|ar|aacd|amrd|ipsd}"
resultfil=/tmp/result

title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

#sed -n -E "/^(${devices})[0-9]:.*</p" $dmesg |
#	sed 's/^\([a-z][a-z]*[0-9]\).*/\1/' > $resultfil
sed -n -E "/^(${devices})[0-9]:.*B [(<]/p" $dmesg |
	sed 's/^\([a-z][a-z]*[0-9]\).*/\1/' > $resultfil
disks=`cat $resultfil`

n=0
taglist=''
for d in $disks ; do
	dname=`sed -n -E "/^${d}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`disksize -B /dev/$d`
	cap=`disksize -p /dev/$d`
	taglist="$taglist $d '$dname (${bytes}バイト, $cap)'"
done
#######taglist="$taglist XX '上記以外を入力する'"

eval dialog \
	--title "'$title'" \
	--menu "'ディスクを選択してください'" \
	12 72 5 \
	$taglist \
	2>$resultfil
status=$?

/bin/sh logdev.sh > /tmp/devices.txt
if [ -s /tmp/devices.txt ]; then
    sed -n "/$disk/p" /tmp/devices.txt > /tmp/checkdev.txt 2>&1
    if [ -s /tmp/checkdev.txt ]; then
	sh dummyread.sh
	msg="${disk}は「wipe-out」の起動メディアと思われます。選択しますか?\n"
	msg="${msg}\n                      よろしいですか?"
	dialog --title "$title" --yesno "$msg" 9 64
	case x"$?" in
	    x1)
		status=1
	esac
    fi
fi

case "$status" in
	0)
		newdisk=`cat $resultfil`
		if [ x"$disk" != x"$newdisk" ]; then
			msg="ディスクを ${disk} から"
			msg="${msg} ${newdisk} に変更しました。"
			dialog	--title "$title" \
				--infobox "$msg" 5 72
			sleep 2
		fi
		disk="$newdisk"
		;;	
	1)
		dialog	--title "$title" \
			--infobox 'ディスクの選択をキャンセルしました' 3 64
		sleep 2
		;;
esac

# EOF
