#! /bin/sh
#
#   copy.sh -- 顼̵뤷ƥǡ򥳥ԡ
#
#	Ȥ: /bin/sh copy.sh ԡǥ ԡǥ
#		ǥ: ǥХեǻꡢƬΡ/dev/פϾʤ
#		: /bin/sh copy.sh ad0 ad1
#
#	0.0: Aug.  5, 2006 by Dai ISHIJIMA (for wpout07)
#	0.1: Feb. 10, 2007 (Ͽ for wpout08)
#	0.2: Feb. 15, 2007 (󥿡Ĺк)
#	0.3: Sep. 12, 2007 (wpout09)
#	0.4: Oct.  6, 2007 (expr(1) POSIXб)
#	0.4: Dec. 13, 2007 (СաĤ׻֤ΥСե)
#	0.5: Jan.  2, 2008 ()
#	0.6: Apr. 19, 2009 (֥å, wpout10)
#	0.7: Oct. 11, 2013 (ԡΥǥ̾ɽ, wpout13)
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"
PATTERNFIL="${PATTERNFIL:-/tmp/pattern.dat}"
dispupd="${DISPUPD:-2}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

# ׻ 32bit signed int θ³˰äʤ褦ˤ
export EXPR_COMPAT

# ֥å512Х
cbs="${CBS:-512}"

srcdisk="${1:-ad0}"
dstdisk="${2:-ad1}"
cbs="${3:-$cbs}"

dmesg="${DMESG:-/var/run/dmesg.boot}"

if [ ! -r /dev/$srcdisk ]; then
	echo "$0: disk '$srcdisk' does not exist or is not readable"
	echo "Usage: $0 srcdisk dstdist"
	exit 1
fi
if [ ! -w /dev/$dstdisk ]; then
	echo "$0: disk '$dstdisk' does not exist or is not writable"
	echo "Usage: $0 srcdisk dstdist"
	exit 1
fi

# ٤32MХȤ
blklen="${BLKLEN:-33554432}"

# ԡΥѥ᡼
# MХñ̤ǿ
mbytes=`disksize -m /dev/$srcdisk`
# 524288MХȰʲʤ֥å512Х
# ֥åΥȤ30ӥåȤǼޤ褦ˤ
xbs=$(( ( $mbytes + 524288 - 1 ) / 524288 ))
minbs=512
xbs=$(( $xbs >> 1 ))
# ֥åĹϥǥ˱ 512, 1k, 2k, 4k,..
while [ $xbs -gt 0 ]; do
	minbs=$(( $minbs << 1 ))
	xbs=$(( $xbs >> 1 ))
done

# ֥åĹû (׻դ붲Τ) ȤĹ
if [ $cbs -lt $minbs ]; then
	cbs=$minbs
fi
ccnt=$(( $blklen / $cbs ))
#
obs="${OBS:-1048576}"
ocnt=$(( $blklen / $obs ))
ounit=$(( $obs / 1048576 ))


title="${TITLE:-ϡɥǥõġwipe-out}"

sname=`sed -n -E "/^${srcdisk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
sbytes=`disksize -B /dev/$srcdisk`
dname=`sed -n -E "/^${dstdisk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
dbytes=`disksize -B /dev/$dstdisk`

msg="ǥ ${srcdisk} ${sname} \n"
msg="${msg}ǡ ${sbytes}ХȤ${cbs}Хñ̤\n"
msg="${msg}ǥ ${dstdisk} ${dname}\n"
msg="${msg}(${dbytes}Х) ˥ԡޤ"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥΥԡ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${srcdisk}Υǡ${dstdisk}˥ԡƤǤ?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥΥԡ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


dd if=/dev/$dstdisk ibs=512 count=1 | check -s 2>&1
case $? in
	0)
		dstempty="may be empty or erased."
		;;
	*)
		dstempty="may NOT be empty or erased."
		msg="ԡΥǥ${dstdisk} ${dname}\n"
		msg="${msg}ˤϥǡĤäƤǽޤ\n"
		msg="${msg}${srcdisk}Υǡ"
		msg="${msg}${dstdisk}˥ԡƤǤ?"
		sh dummyread.sh
		dialog	--title "$title" \
			--hline "$dname" \
			--yesno "$msg" \
			7 72
		case x"$?" in
		x1)
			dialog	--title "$title" \
				--infobox \
				'ǥΥԡ򥭥󥻥뤷ޤ' 3 64
			sleep 2
			exit 1
			;;
		esac
		;;
esac


ccnt=$(( $blklen / $cbs ))
max=$(( $mbytes * (1048576 / $cbs) ))

startsec=`tinydate '+%s'`
rems=''

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "copy started on " >> $LOGFIL
date >> $LOGFIL
echo "  copy $srcdisk ($sname)" >> $LOGFIL
echo "  -> $dstdisk ($dname)" >> $LOGFIL
echo "  destination disk $dstdisk ($dname) $dstempty" >> $LOGFIL
echo "  copying $sbytes bytes ($mbytes Mbytes)" >> $LOGFIL
echo "  cbs=$cbs, ccnt=$ccnt, max=$max, obs=$obs, ocnt=$ocnt" >> $LOGFIL

nerrs=0
skip=0
oseek=0
xcent=100
xmill=1000
mcent=$max
mmill=$max
if [ $max -gt 1048576 ]; then
	xcent=1
	xmill=1
	mcent=$(( ( $max + 99 ) / 100 ))
	mmill=$(( ( $max + 999 ) / 1000 ))
fi
#
echo "  xcent=$xcent, xmill=$xmill, mcent=$mcent, mmill=$mmill" >> $LOGFIL
lastdisp=0
dispintv=0
while [ $skip -le $max ]; do
	# ׻
	cursec=`tinydate '+%s'`
	# С
	p=$(( ( $xcent * $skip ) / $mcent ))
	m=$(( ( $xmill * $skip ) / $mmill ))
	q=$(( $p / 2 ))
	i=0
	bar=''
	while [ $i -lt $q ]; do
		bar="$bar"'#'
		i=$(( $i + 1 ))
	done
	while [ $i -lt 50 ]; do
		bar="$bar"'_'
		i=$(( $i + 1 ))
	done
	# Ĥ
	elapsed=$(( $cursec - $startsec ))
	if [ $elapsed -gt 10 ]; then
		if [ $m -gt 0 ]; then
			remain=$(( ( 1000 - $m ) * $elapsed / $m + 1 ))
			if [ $remain -gt 120 ]; then
				rems=$(( ( $remain + 59 ) / 60 ))
				rems="Ĥ 褽${rems}ʬ"
			else
				rems="Ĥ 褽${remain}"
			fi
		fi
	fi
	if [ $elapsed -gt 120 ]; then
		elas=$(( ( $elapsed + 30 ) / 60 ))
		elas="${elas}ʬ"
	else
		elas="${elapsed}"
	fi
	#
	text="ǥ ${srcdisk} ${sname} \n"
	text="${text}ǡ ${dstdisk} ${dname} \n"
	text="${text}${cbs}Хñ̤ǥԡƤޤ\n"
	text="${text} ${p}% ($skip/$max) λ  "
	text="${text}${elas} в  ${rems}  \n\n"
	text="${text}        0%|${bar}|100%"
	text="${text}\n${errormsg}"
	dispintv=$(( $cursec - $lastdisp ))
	if [ $dispintv -ge $dispupd ]; then
		dialog --title "$title" --infobox "$text" 9 72
		lastdisp=$cursec
	else
		echo -e '\r\c'
	fi
	case "x$progchar" in
		xO) progchar='.' ;;
		xo) progchar='O' ;;
		*)  progchar='o' ;;
	esac
	echo -n "$progchar $status2"
	case x$DEBUG in
		x[Yy]*)
			status2='now in debug mode...'
			errormsg=''
			sleep 1
			;;
		*)
			status=`dd if=/dev/$srcdisk ibs=$cbs skip=$skip conv=noerror,sync obs=$obs seek=$oseek count=$ccnt of=/dev/$dstdisk 2>&1`
			status2=`echo "$status" | sed -n '/transfer/p'`
			errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
			;;
	esac
	# Ͽ
	case x"$skip" in
		x0)
			echo "skip: $skip, $status2" >> $LOGFIL
			;;
	esac
	case x"${nerrs}"x"${errormsg}" in
		x[0-8]x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
		x9x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			echo "Too many errors encounterd..." >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
	esac
	# 롼
	skip=$(( $skip + $ccnt ))
	oseek=$(( $oseek + $ocnt ))
done

sleep 2

#
echo "skip: $skip, $status2" >> $LOGFIL
echo "number of error messages: $nerrs" >> $LOGFIL
echo -n "copy finished on " >> $LOGFIL
date >> $LOGFIL
echo -n "$srcdisk ($sname, $sbytes)" >> $LOGFIL
echo "  -> $dstdisk ($dname, $dbytes)" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

cursec=`tinydate '+%s'`
elapsed=$(( $cursec - $startsec ))
if [ $elapsed -gt 120 ]; then
	min=$(( $elapsed / 60 ))
	sec=$(( $elapsed - $min * 60 ))
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

sh dummyread.sh
dialog	--title "$title" \
	--msgbox "ǥΥԡλޤ (${elas})" 5 72

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
