# $FreeBSD: src/etc/root/dot.cshrc,v 1.30.6.1 2008/11/25 02:59:29 kensmith Exp $
#
# .cshrc - csh resource script, read at beginning of execution by each shell
#
# see also csh(1), environ(7).
#

alias h		history 25
alias j		jobs -l
alias la	ls -a
alias lf	ls -FA
alias ll	ls -lA

# 2009-04-19
alias hg	'history | egrep \!* | sed '"'"'$d'"'"
alias ap	'set path=($path \!*)'
alias cons	'set path=(\!* $path)'

# A righteous umask
umask 22

set path = (/sbin /bin /usr/sbin /usr/bin /usr/games /usr/local/sbin /usr/local/bin $HOME/bin)

setenv	EDITOR	vi
setenv	PAGER	more
setenv	BLOCKSIZE	K

if ($?prompt) then
	# An interactive shell -- set some stuff up
	set prompt = "`/bin/hostname -s`# "
	set filec
	set history = 100
	set savehist = 100
	set mail = (/var/mail/$USER)
	if ( $?tcsh ) then
		bindkey "^W" backward-delete-word
		bindkey -k up history-search-backward
		bindkey -k down history-search-forward
	endif

	# 2009-04-19
	set pb=`whoami`@`hostname -s`
	alias setp3 'set dirs=`dirs`; set ptmp=$dirs[1]; unset dirs'
	alias setp2 'setp3; if (x$ptmp =~ x??????????*) set ptmp="../"$ptmp:t'
	if ($?tcsh) then
	    alias setp1 'setp2; set prompt="$pb"':'$ptmp" # "; unset ptmp'
	else
	    alias setp1 'setp2; set prompt="$pb"':'$ptmp"[\\!] "; unset ptmp'
	endif
	alias setp  'set noglob; setp1; unset noglob'
	alias cd    'cd \!*; setp'
	setp
endif
