#! /bin/sh
#
#   floppylog.sh -- եåԡ˥Ͽ
#
#	Ȥ: /bin/sh floppylog.sh [ǥ]
#		ǥ: ǥХեǻꡢƬΡ/dev/פϾʤ
#		: /bin/sh floppylog.sh fd0
#
#	0.0: Feb. 10, 2007 by Dai ISHIJIMA (for wpout08)
#	0.1: Feb. 15, 2007 (ǥ򤹤)
#	0.2: Feb. 15, 2007 (dmesg -a Ǹ)
#	0.3: Feb. 18, 2007 (󥻥뼺bugfix)
#	0.4: Feb. 20, 2007 (ѿ)
#	0.5: Feb. 21, 2007 (ƤǲԤɽ)
#	0.6: Feb. 23, 2007 (: ƤǲԤɽ)
#	0.7: Sep. 12, 2007 (wpout09)
#	0.8: Oct.  6, 2007 (expr  $(( )) )
#	0.9: Mar. 22, 2014 (顼)
#

dmesg="${DMESG:-/var/run/dmesg.boot}"
ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
disk="${1:-fd0}"
resultfil=/tmp/result

searchfor="fd0 da0 da0s1 da1 da1s1 da2 da2s1 da3 da3s1"

header=/tmp/header.txt

title="${TITLE:-ϡɥǥõġwipe-out}"

dialog	--title "$TITLE" \
	--infobox "¸򸡺Ƥޤ" 3 64

ndevs=0
devs=''
for dev in $searchfor ; do
	echo -e "\r                                        \r\c"
	echo -n "checking $dev"
	if mount_msdosfs -s -o rdonly /dev/$dev /floppy > /dev/null 2>&1; then
		if [ -d /floppy/wipe-out ]; then
			devs="$devs $dev"
			ndevs=$(( $ndevs + 1 ))
		fi
		umount /floppy
	fi
done

case x"$ndevs" in
	x0)
		echo "no device to write log" >> $LOGFIL
		msg="¸褬ߤĤޤǤ"
		dialog --title $title --msgbox "$msg" 5 64
		exit 1
		;;
esac

taglist=''
for dev in $devs ; do
	d=`echo $dev | sed 's/^\([a-z][a-z]*[0-9]\).*/\1/'`
	dname=`sed -n -E "/^${d}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	taglist="$taglist $dev '$dname'"
done

sh dummyread.sh
eval dialog \
	--title "'$title'" \
	--menu "'¸򤷤Ƥ'" \
	10 72 3 \
	$taglist \
	2>$resultfil

case "$?" in
	0)
		disk=`cat $resultfil`
		msg=" ${disk} ¸ޤ"
		dialog	--title "$title" --infobox "$msg" 3 64
		;;
	1)
		dialog	--title "$title" \
			--infobox '¸򥭥󥻥뤷ޤ' 3 64
		sleep 2
		# 2007-02-18
		exit 1
		;;
esac

echo -e "\r                                        \r\c"
echo -n "mounting floppy"
if ! mount_msdosfs -s /dev/$disk /floppy > /dev/null 2>&1; then
	msg="¸ ${disk} 񤭹ߥޥȤǤޤǤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

echo "" > $header
echo -n "####################################" >> $header
echo	"####################################" >> $header
echo -n "following messages were logged on " >> $header
date >> $header
echo -n "====================================" >> $header
echo	"====================================" >> $header

# dmesg.boot
echo -e "\r                                        \r\c"
echo -n "writing dmesg.boot header"
if ! crlf.sh < $header >> /floppy/wipe-out/dmsgboot.txt ; then
	umount /floppy
	msg="dmesg.bootإåν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi
echo -e "\r                                        \r\c"
echo -n "writing dmesg.boot body"
if ! crlf.sh < $dmesg >> /floppy/wipe-out/dmsgboot.txt ; then
	umount /floppy
	msg="dmesg.bootν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

# wpoutlog.txt
echo -e "\r                                        \r\c"
echo -n "writing wpoutlog header"
if ! crlf.sh < $header >> /floppy/wipe-out/wpoutlog.txt ; then
	umount /floppy
	msg="wipe-outإåν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi
echo -e "\r                                        \r\c"
echo -n "writing wpoutlog body"
if ! crlf.sh < $LOGFIL >> /floppy/wipe-out/wpoutlog.txt ; then
	umount /floppy
	msg="wipe-outν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

# mbrlog.txt
echo -e "\r                                        \r\c"
echo -n "writing mbrlog header"
if ! crlf.sh < $header >> /floppy/wipe-out/mbrlog.txt ; then
	umount /floppy
	msg="MBRإåν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

# wperrlog.txt
echo -e "\r                                        \r\c"
echo -n "writing errorlog"
if ! crlf.sh < $ERRORLOG >> /floppy/wipe-out/wperrlog.txt ; then
	umount /floppy
	msg="顼ν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

eraselog='No erase log found'
echo -e "\r                                        \r\c"
echo -n "writing mbrlog body"
for i in /tmp/erase-log.* ; do
	if [ -f "$i" ]; then
		if ! crlf.sh < $i >> /floppy/wipe-out/mbrlog.txt ; then
			umount /floppy
			msg="MBR ($i) ν񤭹ߤ˼Ԥޤ"
			dialog --title "$title" --msgbox "$msg" 5 64
			exit 1
		fi
		eraselog=''
	fi
done
case x"$eraselog" in
    xNo*)
	if ! echo "$eraselog" | crlf.sh >> /floppy/wipe-out/mbrlog.txt ; then
		umount /floppy
		msg="MBRν񤭹ߤ˼Ԥޤ"
		dialog --title "$title" --msgbox "$msg" 5 64
		exit 1
	fi
esac

verifylog='No verify log found'
echo -e "\r                                        \r\c"
echo -n "writing verifylog body"
for i in /tmp/verify-log.* ; do
	if [ -f "$i" ]; then
		if ! crlf.sh < $i >> /floppy/wipe-out/mbrlog.txt ; then
			umount /floppy
			msg="MBR ($i) ν񤭹ߤ˼Ԥޤ"
			dialog --title "$title" --msgbox "$msg" 5 64
			exit 1
		fi
		verifylog=''
	fi
done

case x"$verifylog" in
    xNo*)
	if ! echo "$verifylog" | crlf.sh >> /floppy/wipe-out/mbrlog.txt ; then
		umount /floppy
		msg="MBRν񤭹ߤ˼Ԥޤ"
		dialog --title "$title" --msgbox "$msg" 5 64
		exit 1
	fi
esac

# ѿ
echo -e "\r                                        \r\c"
echo -n "writing environ header"
if ! crlf.sh < $header >> /floppy/wipe-out/environ.txt ; then
	umount /floppy
	msg="ѿإåν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi
echo -e "\r                                        \r\c"
echo -n "writing environ body"
if ! set | crlf.sh >> /floppy/wipe-out/environ.txt ; then
	umount /floppy
	msg="ѿν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

# dmesg-a
echo -e "\r                                        \r\c"
echo -n "writing dmesg -a header"
if ! crlf.sh < $header >> /floppy/wipe-out/dmesg-a.txt ; then
	umount /floppy
	msg="dmesg -a إåν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi
echo -e "\r                                        \r\c"
echo -n "writing dmesg -a body"
if ! dmesg -a | crlf.sh >> /floppy/wipe-out/dmesg-a.txt ; then
	umount /floppy
	msg="dmesg -a ν񤭹ߤ˼Ԥޤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

echo -e "\r                                        \r\c"
echo -n "umounting floppy"
if ! umount /floppy > /dev/null 2>&1; then
	msg="񤭹߸˥ǥ ${disk} 򥢥ޥȤǤޤǤ"
	dialog --title "$title" --msgbox "$msg" 5 64
	exit 1
fi

dialog	--title "$title" \
	--msgbox "ν񤭹ߤλޤ" 5 64

exit 0

# EOF
