#! /bin/sh
#
#   atasecurity.sh -- camcontrol security ǥǡõ
#
#	Ȥ: /bin/sh atasecurity.sh ˡ ǥ
#		: /bin/sh atasecurity -e ada0
#
#	0.0: Aug.  4, 2015 by Dai ISHIJIMA (for wpout15, FreeBSD 9.3R)
#	0.1: May  20, 2020 for wpout20, FreeBSD 11.3R
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

echo "starting ata security ($TTYNAME)" > $STATEFIL

#
method="${1:--e}"
disk="${2:-ada0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"

#
resultfil=/tmp/result

#
title="${TITLE:-ϡɥǥõġwipe-out}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ǥ $disk ¸ߤʤ񤭹ߤǤޤ" \
		5 64
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "ޥΥǥ $disk õ뤳ȤϤǤޤ" \
	    5 64
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"
msg="${msg}奢õ (ATA Security) Ǿõޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="P-ATAǥХSCSIǥХUSB³ΥǥХǤ\n"
msg="${msg}奢õ (ATA Security) ưʤä\n"
msg="${msg}ｪλƤǡξõ¹ԤƤʤȤޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) Υǡ򥻥奢õƤǤ?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

dialog	--title "$title" \
	--infobox 'ǥ򥻥奢õƤޤ' 3 64

sleep 2

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "ata security $method ($TTYNAME) started on " >> $LOGFIL
date >> $LOGFIL

date '+%s' > /tmp/secure-stamp-${TTYNAME}.txt
sh waitsecure.sh /tmp/secure-stamp-${TTYNAME}.txt &
echo "ata security $method $disk ($dname) $bytes bytes" >> $LOGFIL
echo "confirm ata security ($TTYNAME)" > $STATEFIL
script /tmp/sanitize-${TTYNAME}.txt \
	/sbin/camcontrol security $disk -U user
case "x${method} in
    x-e)
	echo 'Enhanced Erase time: UNKNOWN' > /tmp/erasetime.txt
	grep -i 'erase time' /tmp/sanitize-${TTYNAME}.txt >> /tmp/erasetime.txt
	;;
    *)
	echo 'Erase time: UNKNOWN' > /tmp/erasetime.txt
	grep -i 'erase time' /tmp/sanitize-${TTYNAME}.txt >> /tmp/erasetime.txt
	;;
esac
erasetime=`sed -n '$p' < /tmp/erasetime.txt'

case x"$?" in
	x0)
		stat="ok"
		echo "奢õλǧｪλޤ"  > /tmp/sanitizemsg.txt
		;;
	*)
		stat="failed"
		echo "奢õλǧưޤǤ" > /tmp/sanitizemsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;
esac
echo '' >> $LOGFIL
echo '::: ATA Security (camcontrol output) :::' >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt
echo '' >> /tmp/sanitizemsg.txt
case x"$stat" in
    xok)
	sh timer.sh '' "/ $erasetime" 2>&1 &
	child=$!
	echo "erasing $disk with ata security ($TTYNAME)" > $STATEFIL
	script /tmp/sanitize-${TTYNAME}.txt \
		/sbin/camcontrol security $disk -U user -y -s wipe $method wipe
	kill $child 2>&1
	case "x$?" in
	    x0)
		status="finished"
		echo "奢õｪλޤ" >> /tmp/sanitizemsg.txt
		echo "奢õｪλޤ" > /tmp/dialogmsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;
	    *)
		status="failed"
		echo "奢õưޤǤ" >> /tmp/sanitizemsg.txt
		echo "奢õưޤǤ" > /tmp/dialogmsg.txt
		cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
		;;

	esac
	nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL
	nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt
esac

cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt

echo -n 'ޥɼ¹ԻΥϰʲΤȤǤ' >> /tmp/dialogmsg.txt
echo 'ǥ뤷ޤ' >> /tmp/dialogmsg.txt
echo '' >> /tmp/dialogmsg.txt
echo '/* ======== */' >> /tmp/dialogmsg.txt
cat /tmp/sanitizemsg.txt >> /tmp/dialogmsg.txt

echo "show result of ata security ($TTYNAME)" > $STATEFIL

sh dummyread.sh
dialog	--title '奢õΥ' --textbox /tmp/dialogmsg.txt 19 76

#

echo -n "sanitize $status on " >> $LOGFIL
date >> $LOGFIL
echo "sanitize $disk ($dname, $cap)" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

# λ
endstamp=`date '+%H:%M'`

case x"$status" in
    xfinished)
	# ¸
	echo 'The contents of this storage device' > /tmp/erase-log.$disk
	echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
	echo -n 'were erased with ' >> /tmp/erase-log.$disk
	echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
	echo "Erased with 'ATA SECURITY'" >> /tmp/erase-log.$disk
	echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk
	echo "but NOT verified" > /tmp/verify-log.$disk
	;;
esac

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
