#! /bin/sh
#
#   fine-erase.sh -- ʣ񤭹ߤǰ˥ǥΥǡõ
#
#	Ȥ: /bin/sh fine-erase.sh ä ǥ
#		ä: [0z1fRr]+
#		ǥ: ǥХեǻꡢƬΡ/dev/פϾʤ
#		: /bin/sh fine-erase.sh 0101010 ad0
#
#	0.0: Jun. 27, 2004 by Dai ISHIJIMA
#	0.1: Jul. 11, 2004
#	0.2: Jun. 28, 2006
#	0.3: Aug.  1, 2006 (ॹ for wpout07)
#	0.4: Feb. 10, 2007 (Ͽ for wpout08)
#	0.5: Feb. 15, 2007 (󥿡Ĺк)
#	0.6: Sep. 12, 2007 (wpout09)
#	0.7: Oct.  6, 2007 (׻32ӥåդϰϤǹԤ)
#	0.8: Dec. 23, 2007 (Сɽη׻)
#	0.9: Jan.  2, 2008 ()
#	1.0: Mar. 22, 2014 (̤ΤĤ򸺤餹 (򸺤餹))
#	1.1: Aug.  4, 2015 (expr *, FreeBSd 9.3R)
#	1.2: Jan. 15, 2017 (0x55б)
#	1.3: May  18, 2020 (v2.0 λΥ㥤)
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
CHIMEMIN="${CHIMEMIN:-10}"

exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"
PATTERNFIL="${PATTERNFIL:-/tmp/pattern.dat}"
STATEFIL="${STATEFIL:-/tmp/status.txt}"
dispupd="${DISPUPD:-5}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

echo "starting erase ($TTYNAME)" > $STATEFIL

if [ ! -s $PATTERNFIL ]; then
	stuff -g > $PATTERNFIL
	echo "random pattern file $PATTERNFIL generated" >> $LOGFIL
fi

stuffs="${1:-fz}"
disk="${2:-ad0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"
# ٤32MХȤ
blklen="${BLKLEN:-33554432}"
# ϥ֥å1MХ
obs="${OBS:-1048576}"
ocnt=$(( $blklen / $obs ))
ounit=$(( $obs / 1048576 ))
# ϥ֥å1kХ
ibs="${IBS:-1024}"
icnt=$(( $blklen / $ibs ))

#
resultfil=/tmp/result

#
title="${TITLE:-ϡɥǥõġwipe-out}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ǥ $disk ¸ߤʤ񤭹ߤǤޤ" \
		5 64
	echo "$0: can't write to $disk" 1>&2
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "ޥΥǥ $disk õ뤳ȤϤǤޤ" \
	    5 64
	echo "$0: can't write to $disk, mounted" 1>&2
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"

nstuff=0
for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	case x"$stuff" in
		x[0z])	msg="${msg}0" ;;
		x[1f])	msg="${msg}1" ;;
		x[Rr])	msg="${msg}R" ;;
		x[Pp])	msg="${msg}P" ;;
		x[An])	msg="${msg}A" ;;
		x[U5])	msg="${msg}5" ;;
	esac
	nstuff=$(( $nstuff + 1 ))
done

msg="${msg}ν\n${nstuff}񤭤ƾõޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 10 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) ΥǡõƤǤ?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

# õΥѥ᡼ (MХñ̤ǿ)
mbytes=`disksize -m /dev/$disk`
max=$(( $mbytes / $ounit ))

stage=0
xstage=1
startsec=`tinydate '+%s'`
totalrems=''

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "erase ($nstuff times) started on " >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname) $bytes bytes with $stuffs" >> $LOGFIL

nerrs=0
xcent=100
xmill=1000
mcent=$max
mmill=$max
if [ $max -gt 1048576 ]; then
	xcent=1
	xmill=1
	mcent=$(( ( $max + 99 ) / 100 ))
	mmill=$(( ( $max + 999 ) / 1000 ))
fi
for stuff in `echo $stuffs | sed 's/\(.\)/\1 /g'` ; do
	skip=0
	stagestart=`tinydate '+%s'`
	case "$stuff" in
		[0z])	method="'0'񤭤" ;;
		[1f])	method="'1'񤭤" ;;
		[Rr])	method="ǡ񤭤" ;;
		[Pp])	stuff -g > $PATTERNFIL
			echo "random pattern file $PATTERNFIL generated" \
				>> $LOGFIL
			method="ѥ񤭤" ;;
		[Qq])	method="ľѥ񤭤" ;;
		[An])	method="'0xAA'񤭤" ;;
		[U5])	method="'0x55'񤭤" ;;
	esac
	rems=''
	status=''
	status2=''
	errormsg=''
	#
	echo -n "stage: $stage, with writing $stuff " >> $LOGFIL
	echo -n "started on " >> $LOGFIL
	date >> $LOGFIL
	#
	lastdisp=0
	dispintv=0
	while [ $skip -le $max ]; do
		# ׻
		cursec=`tinydate '+%s'`
		# С
		p=$(( ( $xcent * $skip ) / $mcent ))
		m=$(( ( $xmill * $skip ) / $mmill ))
		q=$(( $p / 2 ))
		i=0
		bar=''
		while [ $i -lt $q ]; do
			bar="$bar"'#'
			i=$(( $i + 1 ))
		done
		while [ $i -lt 50 ]; do
			bar="$bar"'_'
			i=$(( $i + 1 ))
		done
		# Ĥ
		elapsed=$(( $cursec - $stagestart ))
		if [ $elapsed -gt 10 ]; then
			if [ $m -gt 0 ]; then
				remain=$(( ( 1000 - $m ) * $elapsed / $m + 1 ))
				if [ $remain -gt 120 ]; then
					rems=$(( ( $remain + 59 ) / 60 ))
					rems="Ĥ 褽${rems}ʬ"
				else
					rems="Ĥ 褽${remain}"
				fi
			fi
		fi
		if [ $elapsed -gt 120 ]; then
			elas=$(( ( $elapsed + 30 ) / 60 ))
			elas="${elas}ʬ"
		else
			elas="${elapsed}"
		fi
		# ΥС
		pp=$(( ( $p + 100 * $stage ) / $nstuff ))
		mm=$(( ( $m + 1000 * $stage ) / $nstuff ))
		q=$(( $pp / 2 ))
		i=0
		totalbar=''
		while [ $i -lt $q ]; do
			totalbar="$totalbar"'#'
			i=$(( $i + 1 ))
		done
		while [ $i -lt 50 ]; do
			totalbar="$totalbar"'_'
			i=$(( $i + 1 ))
		done
		ee=$(( $cursec - $startsec ))
		if [ $mm -gt 0 ]; then
			rr=$(( ( 1000 - $mm ) * $ee / $mm + 1 ))
			if [ $rr -gt 120 ]; then
				totalrems=$(( ( $rr + 59 ) / 60 ))
				totalrems="Ĥ 褽${totalrems}ʬ"
			else
				totalrems="Ĥ 褽${rr}"
				dispupd=10
			fi
		fi
		if [ $ee -gt 120 ]; then
			totalelas=$(( ( $ee + 30 ) / 60 ))
			totalelas="${totalelas}ʬ"
			dispupd=30
		else
			totalelas="${ee}"
		fi
		#
		echo "erasing $disk, fine, $pp % done.  ($TTYNAME)" > $STATEFIL
		text="ǥ ${disk} ΥǡõƤޤ\n\n"
		text="${text} ${nstuff}  ${xstage} ֤  "
		text="${text} Τ ${pp}% λ\n"
		text="${text}${totalelas} в  ${totalrems}  \n\n"
		text="${text}        0%|${totalbar}|100%\n\n"
		text="${text}ιǤ${method}ǡõƤޤ\n"
		text="${text}${p}% ($skip/$max) λ  "
		text="${text}${elas} в  ${rems}  \n\n"
		text="${text}        0%|${bar}|100%\n\n"
		text="${text}\n${errormsg}"
		dispintv=$(( $cursec - $lastdisp ))
		if [ $dispintv -ge $dispupd ]; then
			dialog --title "$title" --infobox "$text" 15 72
			lastdisp=$cursec
		else
			echo -e '\r\c'
		fi
		sh poko.sh
		echo -n "$status2 "
		case x$DEBUG in
			x[Yy]*)
				status2='now in debug mode...'
				errormsg=''
				sleep 1
				;;
			*)
				status=`stuff -$stuff < $PATTERNFIL | dd ibs=$ibs obs=$obs seek=$skip count=$icnt of=/dev/$disk 2>&1`
				status2=`echo "$status" | sed -n '/transfer/p'`
				errormsg=`echo "$status" | sed -n -E '/records (in|out)$/!p' | sed -n '/transferred in/!p'`
				;;
		esac
		# Ͽ
		case x"$skip" in
		    x0)
			echo "stage: $stage, skip: $skip, $status2" >> $LOGFIL
			;;
		esac
		case x"${nerrs}"x"${errormsg}" in
		    x[0-8]x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
		    x9x?*)
			echo "errmesg[${nerrs}]: $errormsg" >> $LOGFIL
			echo "Too many errors encounterd..." >> $LOGFIL
			nerrs=$(( $nerrs + 1 ))
			;;
		esac
		# 롼
		skip=$(( $skip + $ocnt ))

	done
	stage=$(( $stage + 1 ))
	xstage=$(( $xstage + 1 ))
	echo "stage: $stage, skip: $skip, $status2" >> $LOGFIL
done

sleep 2

#
echo "number of errmessages: $nerrs" >> $LOGFIL
echo -n "erase finished on " >> $LOGFIL
date >> $LOGFIL
echo "  $disk ($dname, $cap) with overwriting $nstuff times" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

cursec=`tinydate '+%s'`
elapsed=$(( $cursec - $startsec ))
if [ $elapsed -gt 120 ]; then
	min=$(( $elapsed / 60 ))
	sec=$(( $elapsed - $min * 60 ))
	elas="${min}ʬ${sec}"
else
	elas="${elapsed}"
fi

# λ
endstamp=`date '+%H:%M'`

# ¸
echo 'The contents of this storage device' > /tmp/erase-log.$disk
echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
echo -n 'were erased with ' >> /tmp/erase-log.$disk
echo -n 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
echo "  ($TTYNAME)" >> /tmp/erase-log.$disk
echo "Erase $nstuff times ($stuffs)" >> /tmp/erase-log.$disk
echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk

echo "but NOT verified" > /tmp/verify-log.$disk

echo "$disk erased ($elapsed [s]) ($TTYNAME)" > $STATEFIL

sh chime.sh $CHIMEMIN & 2>&1
child=$!
sh dummyread.sh
dialog	--title "$title" \
	--msgbox "ǥΥǡõλޤ (${elas})" 5 72
kill $child > /dev/null 2>&1

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
