#! /bin/sh
#
#   kon2start.sh -- ȥ󤷤ĤġɤΥ⡼ɤ˰ܹԤ뤫
#
#	0.0: May   5, 2009 by Dai ISHIJIMA (as countdown.sh)
#	0.1: Apr. 11, 2011 for wpout11
#	0.2: Oct. 11, 2013 (use /dev/ttyv0, wpout13)
#	0.3: May  11, 2014 (comconsole -> serial console)
#	0.4: Aug   3, 2015 (FreeBSD 9.3R, kon -s for single user mode)
#	0.5: May  17, 2020 (FreeBSD 11.3R, legacy console mode, v0.8 based)
#

export TTY="${TTY:-ttyv0}"
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
####export TERMCAP=/etc/termcap
export TERM=vt100		# for kon

echo ''
echo 'Starting yet another console session on VTY1 (Alt+F2)'
/wipeout/shell-on /dev/ttyv1
echo -n 'You can start yet another wipe-out session with ' > /dev/ttyv1
echo '"sh /wipeout/kon2alt.sh"' > /dev/ttyv1
echo -n "Starting console session on VTY1 " >> $LOGFIL
date >> $LOGFIL

export STATEFIL=/tmp/status.txt
echo -n 'selecting console' > $STATEFIL

echo 'Starting screen saver on VTY7 (Alt+F8)'
/wipeout/shell-on /dev/ttyv7 /bin/sh /wipeout/scsaver.sh
echo -n "Starting screen saver on VTY7 " >> $LOGFIL
date >> $LOGFIL

echo ''

prompt="waiting for device to settle... (press SPACE to pause) "
#count=5
# 2020-05-17
count=8

# 2016-12-08
while [ $count -ge 0 ]; do
	echo -e "\r$prompt[$count] \c"
	if tread -t 1 -e 1 > /tmp/keyin; then
		count=0
		keyin=`sed -n 1p /tmp/keyin`
	fi
	count=$(( $count - 1 ))
done
#echo -e "\r$prompt[0]"

echo ''
echo ''
echo ''
echo "# select console mode"
echo "    0: Start wipe-out on KON2 (Kanji on console) [default]"
echo "    1: Start wipe-out on KON2 fixed for some Laptops"

# 2020-05-17
echo "    9: Start wipe-out on Legacy Console (non-VGA) mode"

if [ -c /dev/cuau0 ]; then
	echo "    c: Start wipe-out on serial console (regacy serial, uart0)"
fi
if [ -c /dev/cuaU0 ]; then
	echo "    u: Start wipe-out on serial console (USB adaptor, ucom0)"
fi

echo "    S: Start interactive shell, stay in Native console (non Japanese)"


prompt="# Just press ENTER to select default mode"

count=9
keyin=0

# 2016-12-08
while [ $count -ge 0 ]; do
	echo -e "\r$prompt[$count] \c"
	if tread -t 1 -e 1 > /tmp/keyin; then
		count=0
		keyin=`sed -n 1p /tmp/keyin`
	fi
	count=$(( $count - 1 ))
done
#echo -e "\r$prompt[0]"
echo ''

session > /tmp/session.txt
export EPOCH=`sed -n '1p' < /tmp/session.txt`
export SID=`sed -n '2p' < /tmp/session.txt`

echo -n "kon2start with keyin = $keyin, " >> $LOGFIL
date >> $LOGFIL

touch /tmp/fd-mode.txt

export KON2MODE=NONE
case x"$keyin" in
	x*S*)
		/bin/sh -i
		;;
	x*c*)
		export TTY=comconsole.cuau0
		dmesg > /dev/cuau0
		/wipeout/shell-on /dev/cuau0 /bin/sh /wipeout/startup.sh
		;;
	x*u*)
		export TTY=comconsole.cuaU0
		dmesg > /dev/cuaU0
		/wipeout/shell-on /dev/cuaU0 /bin/sh /wipeout/startup.sh
		;;
	x*0*)
		export KON2MODE=default
		echo 'default' > /tmp/kon2mode.txt
		/usr/local/bin/kon -s -e /wipeout/startup.sh \
			< /dev/ttyv0
		;;
	x*9*)
		export KON2MODE=legacy_console
		echo 'legacy_console' > /tmp/kon2mode.txt
		cd /fd-mode
		script -a /tmp/fd-mode.txt /bin/sh /fd-mode/startup.sh
		;;
	*)
		export KON2MODE=FIXed
		echo 'FIXed' > /tmp/kon2mode.txt
		/usr/local/bin/kon2fixed FIX -s -e /wipeout/startup.sh \
			< /dev/ttyv0
		;;
esac

exit 0

# EOF
