#! /bin/sh
#
#   mainmenu.sh -- CD-ROMǥᥤ˥塼
#
#	0.0: Jun. 20, 2004 by Dai ISHIJIMA (for wpout03)
#	0.1: Jul. 11  2004 (for wpout04)
#	0.2: Jun. 23  2005 (for wpout05)
#	0.3: Jul.  8  2005 (for wpout06)
#	0.4: Aug.  5, 2006 (for wpout07)
#	0.5: Dec. 21, 2006 (erase MBR)
#	0.6: Feb. 10, 2007 (Ͽ for wpout08)
#	0.7: Feb. 15, 2007 (󥿡Ĺк)
#	0.8: Feb. 18, 2007 (˥塼ν֤ѹ)
#	0.9: Sep. 12, 2007 (wpout09, FreeBSD 6.2R)
#	1.0: Sep. 17, 2007 (shutdownβ)
#	1.1: Oct.  6, 2007 (expr(1) POSIXб)
#	1.2: Feb. 10, 2008 (إץåɽưɽ)
#	1.3: Apr. 19, 2009 (®ǥԡ, wpout10)
#	1.4: Sep. 30, 2009 (IBM ServeRAID, ips(4), /dev/ipsd%d)
#	1.5: Dec. 22, 2012 (smartctl)
#	1.6: Feb.  1, 2014 (Ƭ)
#	1.7: Aug.  4, 2015 (FreeBSD 9.3R, camcontrol sanitize)
#	1.8: Nov.  8, 2015 (꡼󥻡С)
#	1.9: Dec.  4, 2016 (ttyname)
#	2.0: Jan.  2. 2017 (¸FreeBSDΥץȤư)
#	2.1: Aug. 12, 2017 (v1.7, FreeBSD 11.1R)
#	2.2: Aug.  3, 2018 (pre v1.8, FreeBSD 11.2R)
#	2.3: Sep. 23, 2019 (pre v1.9, FreeBSD 12.0R)
#	2.4: May   6, 2020 (pre v2.0, FreeBSD 11.3R)
#

exec 2>/tmp/mm-error.txt

# 
dmesg="${DMESG:-/var/run/dmesg.boot}"
devices="${DEVICES:-da|ada|aacd|amrd|idad|ipsd|mfid|mlxd|twed|ad|ar}"
#
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
export ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
export DISPUPD="${DISPUPD:-5}"
export STATEFIL="${STATEFIL:-/tmp/status.txt}"
export HISTFIL="${HISTFIL:-/tmp/history.txt}"
export WIPEOUTDIR="${WIPEOUTDIR:-/wipeout}"
# 2020-05-18
export CHIMEMIN="${CHIMEMIN:-10}"
export EPOCH="${EPOCH:-1589760000}" # Mon May 18 09:00:00 JST 2020
export SID="${SID:-ABCD:EFGH}"
#
export DIALOG="--ascii-lines --no-collapse"

cbs="${CBS:-512}"
obs="${OBS:-1048576}"

resultfil=/tmp/result
nsec=/tmp/sector
stuffs='10'

##sed -n -E "/^(${devices})[0-9][0-9]*:.*</p" $dmesg |
##	sed 's/^\([a-z][a-z]*[0-9][0-9]*\).*/\1/' > $resultfil
sed -n -E "/^(${devices})[0-9][0-9]*:.*B [<(]/p" $dmesg |
	sed 's/^\([a-z][a-z]*[0-9][0-9]*\).*/\1/' > $resultfil

disk=`sed -n '1p' $resultfil`

ttyname=`tty | sed 's+/dev/++' | sed 's|/|.|'`
ttyname="$ttyname/$SID"
export TTYNAME="$ttyname"
export TITLE="ϡɥǥõġwipe-out v2.0 ($ttyname)"
dumpskip=0

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script mainmenu.sh ($ttyname) started on " >> $LOGFIL
date >> $LOGFIL

echo '# ---------------------------- #' >> $ERRORLOG
echo -n "script mainmenu.sh ($ttyname) started on " >> $ERRORLOG
date >> $ERRORLOG

while true ; do
	dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
	bytes=`disksize -B /dev/$disk`
	cap=`disksize -p /dev/$disk`

	echo '# ---------------------------- #' >> $ERRORLOG
	echo -n "preparing mainmenu ($ttyname)" >> $ERRORLOG
	date >> $ERRORLOG

	msg="                      ᥤ˥塼\n"
	msg="${msg}Υǥ /dev/${disk} ${dname} Ǥ\n"
	msg="${msg}ǥ̤ $bytes Х ($cap) Ǥ\n"
	msg="${msg}ʲΥ˥塼򤷤Ƥ\n"

	echo 'displaying main menu' >> $HISTFIL
	cp /dev/null $STATEFIL

	sh dummyread.sh
	dialog 	2>$resultfil \
		--title "$TITLE" \
		--menu "$msg" \
		21 74 10 \
		z '0񤭤ơΥǥΥǡä' \
		E 'ATA SSD/HDD (ATA Security) 奢õ' \
		v 'ǡõ줿ǧ (®å)' \
		V 'ǡõ줿ǧ (̾å)' \
		L 'ưϿUSBեåԡ˽񤭽Ф' \
		n 'ʣ񤭤ơΥǥΥǡǰ˾ä' \
		m 'ǰõξˡ򤹤' \
		s '̤Υǥ򤹤' \
		d 'ǥΥǡɽ' \
		h 'ˤ³ޤˡγפɽ' \
		S 'ǡɽ륻λ' \
		a '֡wipe-out٤ˤĤơפ򸫤' \
		C 'ɽ򥹥꡼󥻡Сڤؤ' \
		D 'ưΥƥåǧ' \
		P 'ưϿɽ' \
		Y 'ǥ򥳥ԡʹ®Хåå׸' \
		y 'ǥ򥳥ԡ®ǡ١' \
		f '1񤭤ơΥǥΥǡä' \
		p 'ѥ񤭤ơΥǥΥǡä' \
		q 'ѥ񤭤ơΥǥΥǡä' \
		r 'ǡ񤭤ơΥǥΥǡä' \
		T 'ǥμʿǾ (SMART) ɽ' \
		Z '˥ǽ (SCSI Sanitize) ǥ奢õ' \
		X 'ATA SSD/HDD򥨥ϥ󥹥ȥ奢õ' \
		O '˥ǽǥ奢õ (BLOCK⡼)' \
		F 'ʸ񤭤ơΥǥΥǡä' \
		K 'õоݥǥưꤹ' \
		w 'õǥƬ˽񤭹' \
		b ' (sh) ư' \
		t ' (csh) ư' \
		M 'CD-ROMmount' \
		U 'CD-ROMumount' \
		B 'MBR *Τ* õ' \
		c 'λΥ㥤֤ꤹ' \
		x 'åȥ󤹤' \
		R 'Ƶư' \
		N '˥塼Ƭ' \
		# end of menu
	case x"$?" in
		x1)
			break
			;;
	esac

	result=`cat $resultfil`

	case x"${result}" in
		x[zfrpq])
			echo "starting erase ($ttyname)" >> $HISTFIL
			sh erase.sh -$result $disk
			;;
		xF)
			echo "starting erase ($ttyname)" >> $HISTFIL
			cp mani.txt $PATTERNFIL
			sh erase.sh -F $disk
			;;
		xE)
			echo -n 'starting ata secure erase ' >> $HISTFIL
			echo "($ttyname)" >> $HISTFIL
			sh atasecurity.sh -e $disk
			;;
		xX)
			echo -n 'starting ata enhanced ' >> $HISTFIL
			echo "secure erase ($ttyname)" >> $HISTFIL
			sh atasecurity.sh -h $disk
			;;
		xE)
			echo -n 'starting ata secure erase' >> $HISTFIL
			echo "($ttyname)" >> $HISTFIL
			;;
		xh)
			echo "displaying instruction ($ttyname)" >> $HISTFIL
			dialog	--title 'ˡγ' \
				--textbox help.txt 20 76
			;;
		xs)
			echo "selecting disk ($ttyname)" >> $HISTFIL
			. seldisk.sh
			;;
		xn)
			echo "starting fine erase ($ttyname)" >> $HISTFIL
			sh fine-erase.sh $stuffs $disk
			;;
		xm)
			echo "selecting erase method ($ttyname)" >> $HISTFIL
			. sel-fine.sh
			;;
		xv)
			echo "starting quick verify ($ttyname)" >> $HISTFIL
			sh verify.sh 90 $disk
			;;
		xV)
			echo "starting verify ($ttyname)" >> $HISTFIL
			sh verify.sh 0 $disk
			;;
		xw)
			echo "writing log ($ttyname)" >> $HISTFIL
			sh writelog.sh $disk
			;;
		xL)
			echo "saving log ($ttyname)" >> $HISTFIL
			sh floppylog.sh
			;;
		xd)
			echo "dump sector ($ttyname)" >> $HISTFIL
			sh dump.sh $dumpskip $disk
			dumpskip=`expr $dumpskip + 1`
			;;
		xS)
			echo "selecting sector ($ttyname)" >> $HISTFIL
			msg="ꤷƤ ($dumpskip)"
			dialog	2>$nsec \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> $nsec
				echo "$dumpskip" >> $nsec
				dumpskip=`sed -n '/^[0-9]/p' $nsec | sed -n 1p`
				;;
			esac
			;;
		xa)
			echo "displaying about ($ttyname)" >> $HISTFIL
			dialog	--title 'wipe-out٤ˤĤ' \
				--textbox info.txt 20 76
			;;
		xC)
			echo "displaying saver ($ttyname)" >> $HISTFIL
			msg='Alt+F8򲡤ȥ꡼󥻡Сڤؤޤ'
			msg="${msg}\nץ⡼ɤ䥷ꥢ륳󥽡"
			msg="${msg}Ǥưޤ"
			dialog	--title "$TITLE" \
				--msgbox "$msg" 6 64
			;;
		xD)
			echo -n "displaying system message " >> $HISTFIL
			echo "($ttyname)" >> $HISTFIL
			dialog	--title 'ưΥƥå' \
				--textbox /var/run/dmesg.boot 20 76
			;;
		xy)
			echo "starting copy ($ttyname)" >> $HISTFIL
			srcdisk=$disk
			. seldisk.sh
			dstdisk=$disk
			sh copy.sh $srcdisk $dstdisk $cbs
			disk=$srcdisk
			;;
		xY)
			echo "starting quick copy ($ttyname)" >> $HISTFIL
			srcdisk=$disk
			. seldisk.sh
			dstdisk=$disk
			sh copy.sh $srcdisk $dstdisk $obs
			disk=$srcdisk
			;;
		xP)
			echo "displaying history ($ttyname)" >> $HISTFIL
			echo "::: $LOGFIL ($ttyname) :::" > /tmp/loglog.txt
			cat $LOGFIL >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			for f in /tmp/erase-log.* ; do
				if [ -f "$f" ]; then
					echo "::: $f :::" >> /tmp/loglog.txt
					cat $f >> /tmp/loglog.txt
					echo '' >> /tmp/loglog.txt
				fi
			done
			for f in /tmp/verify-log.* ; do
				if [ -f "$f" ]; then
					echo "::: $f :::" >> /tmp/loglog.txt
					cat $f >> /tmp/loglog.txt
					echo '' >> /tmp/loglog.txt
				fi
			done
			echo '::: history :::' >> /tmp/loglog.txt
			cat $HISTFIL		 >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			echo '::: shell variables :::' >> /tmp/loglog.txt
			set >> /tmp/loglog.txt
			echo '' >> /tmp/loglog.txt
			dialog	--title 'ư' \
				--textbox /tmp/loglog.txt 20 76
			;;
		xT)
			echo "displaying smart info ($ttyname)" >> $HISTFIL
			if [ ! -x /usr/local/sbin/smartctl ]; then
				echo '::: no smartctl found :::' \
					>> $LOGFIL
				dialog	--title "$TITLE" \
				--msgbox 'smartctl(8) ޤ' 5 64
			else
				echo -n "displaying smart infomation " \
					>> $HISTFIL
				echo "($TTYNAME)" >> $HISTFIL
				/usr/local/sbin/smartctl -s on /dev/$disk \
					> /tmp/smart.txt 2>&1
				/usr/local/sbin/smartctl -a /dev/$disk \
					>> /tmp/smart.txt 2>&1
				case x"$?" in
				    x0)
					echo "SMARTｪλޤ" \
						> /tmp/smartmsg.txt
					;;
				    *)
					echo "SMARTưޤǤ" \
						> /tmp/smartmsg.txt
					;;
				esac
				echo '' >> $LOGFIL
				echo '::: SMART (smartctl output) :::' \
					>> $LOGFIL
				cat /tmp/smart.txt >> $LOGFIL
				cat /tmp/smart.txt >> /tmp/smartmsg.txt
				dialog	--title 'SMART' \
					--textbox /tmp/smartmsg.txt 20 76
			fi
			;;
		xZ)
			echo "starting sanitize ($ttyname)" >> $HISTFIL
			sh sanitize.sh crypto $disk
			;;
		xO)
			echo "starting block sanitize ($ttyname)" >> $HISTFIL
			sh sanitize.sh block $disk
			;;
		xK)
			echo "selecting disk (manual) ($ttyname)" >> $HISTFIL
			msg="ǥꤷƤ ($disk)"
			dialog	2>/tmp/diskname \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> /tmp/diskname
				echo "$disk" >> /tmp/diskname
				cat /tmp/diskname |	
					sed -n '/^[a-z][a-z]*[0-9][0-9]*/p' |
					sed -n 1p > /tmp/diskname.new
				disk=`cat /tmp/diskname.new`
				;;
			esac
			;;
		xb)
			echo "starting shell ($ttyname)" >> $HISTFIL
			/bin/sh -i
			;;
		xt)
			echo "starting shell ($ttyname)" >> $HISTFIL
			if [ -x /bin/csh ]; then
				/bin/csh -i
			else
				msg='cshäCD-ROMޥȤƤ'
				dialog	--title "$TITLE" \
					--msgbox "$msg" 5 64
			fi
			;;
		xM)
			echo "mounting CD-ROM ($ttyname)" >> $HISTFIL
			if [ -x /cdrom/usr.bin/dialog ]; then
				msg='CD-ROMϤǤ˥ޥȤƤޤ'
			elif mount_cd9660 $CDROM /cdrom > /dev/null 2>&1; then
				msg='CD-ROMޥȤޤ'
			else
				msg='CD-ROMޥȤǤޤǤ'
			fi
			dialog	--title "$TITLE" \
				--msgbox "$msg" 5 64
			;;
		xU)
			echo "unmounting CD-ROM ($ttyname)" >> $HISTFIL
			msg=''
			if [ ! -x /cdrom/usr.bin/dialog ]; then
				msg='CD-ROMϤǤ˥ޥȤƤޤ'
			fi
			if umount /cdrom > /dev/null 2>&1; then
				msg='CD-ROM򥢥ޥȤޤ'
			elif [ -z "$msg" ]; then
				msg='CD-ROMޥȤǤޤǤ'
			fi
			dialog	--title "$TITLE" \
				--msgbox "$msg" 5 64
			;;
		xc)
			echo "setting chime idle time ($ttyname)" >> $HISTFIL
			msg="λ㥤 ($CHIMEMIN) ʬ"
			dialog	2>$nmin \
				--title "$TITLE" \
				--inputbox "$msg" 8 64
			case x"$?" in
			    x0)
				echo '' >> $nmin
				echo "$CHIMEMIN" >> $nmin
				CHIMEMIN=`sed -n '/^[0-9]/p' $nmin | sed -n 1p`
				export CHIMEMIN
				;;
			esac
			;;
		xB)
			echo "erasing MBR ($ttyname)" >> $HISTFIL
			sh embr.sh $disk
			;;
		xx)
			echo "starting shutdown ($ttyname)" >> $HISTFIL
			echo "halt" > /var/run/nologin
			(sleep 30; /sbin/shutdown -p now) > /dev/null 2>&1 &
			exit 1
			;;
		xR)
			echo "starting reboot ($ttyname)" >> $HISTFIL
			echo "reboot" > /var/run/nologin
			(sleep 30; /sbin/shutdown -r now) > /dev/null 2>&1 &
			exit 1
			;;
		#xN)
		#	NOP
		#	;;
	esac
done

dialog	--title "$TITLE" \
	--infobox 'λޤ' 3 64

echo "/bin/sh ${WIPEOUTDIR}/mainmenu.shפǥ˥塼̤ƤӽФޤ"
echo ''

exit 0

# EOF
