#! /bin/sh
#
#   makeiso.sh -- ϡɥǥõѥ֡CDκ
#
#   revision history:
#	0.0: Oct. 26, 2001 by Dai ISHIJIMA
#	0.1: Oct. 22, 2002 (add diskinfo)
#	0.2: May   1, 2004 (4.8R, disklabel, random data)
#	0.3: May   1, 2004 (makefd.sh -> makeiso.sh)
#	0.4: Jun. 15, 2004 (dialog, cd9660)
#	0.5: Jun. 19, 2004 (ե륵ǡ)
#	0.6: Jun. 27, 2004 (ǰõ, fine-erase.sh)
#	0.7: Oct. 18, 2004 (ISO᡼)
#	0.8: Jun. 19, 2005 (CDޥ, PXEѥͥ)
#	0.9: Jul.  8, 2005 (õå)
#	1.0: Jun. 29, 2006 (v07pre-1, 4.11R)
#	1.1: Aug.  6, 2006 (v07pre-2, 4.11R, CD֡Ȥʤݤн)
#	1.2: Sep. 18, 2006 (v07pre-3, 4.11R, PXE֡Ȥ /var ʤݤн)
#	1.3: Dec. 21, 2006 (v07pre-4, SJISɥ)
#	1.4: Feb. 10, 2007 (v08pre-1, ǥؤΥϿ)
#	1.5: Feb. 15, 2007 (nkfץߥ)
#	1.6: Feb. 16, 2007 (ͥȥե륷ƥʬΥ)
#	1.7: Sep. 12, 2007 (v09pre-1)
#	1.9: Sep. 17, 2007 (v09pre-2)
#	2.0: Oct.  7, 2007 (v09pre-3, /etc/fstab)
#	2.1: Dec. 23, 2007 (v09pre-4, copy.sh¾Сշ׻)
#	2.2: Jan.  2, 2008 (v09pre-5, ե륵, ե, etc.)
#	2.3: Feb. 10, 2008 (v09)
#	2.4: Apr. 19, 2009 (v10pre-1)
#	2.5: Apr. 25, 2009 (v10pre-2)
#	2.6: Nov.  7, 2010 (v11pre-1), FreeBSD 7.3R
#	2.7: Apr. 11, 2011 (v11pre-2), kon2fixed
#	2.8: Apr. 16, 2011 (v11pre-3), USB
#	2.9: Dec. 22, 2012 (v12pre-1), SMART
#	3.0: Jan. 21, 2013 (v12pre-2), USB image
#	3.1: May   5, 2013 (v13pre-1), FreeBSD 8.3R, md0c -> md0a
#	3.1: Oct. 10, 2013 (v13pre-3), fix kon fatal error, libusb.so
#	3.2: Nov.  7, 2013 (v13pre-4), xhci.ko
#	3.3: Dec.  7, 2013 (v13pre-5), mfi(4), mfid
#	3.4: Mar. 22, 2014 (v14), Сֹե뤫äƤ
#	3.5: May  11, 2014 (v14, shell-on)
#	3.6: Aug.  2, 2015 (v15pre-1), FreeBSD 9.3R
#	3.7: Aug. 30, 2015 (v15pre-2), FreeBSD 9.3R, USB
#	3.8: Jul. 26, 2016 (v16pre-1), FreeBSD 10.3R, vt(4)/sc(4)+kon2
#	3.9: Sep. 10, 2016 (v16pre-2)
#	4.0: Sep. 19, 2016 (v16pre-3), USB again
#	4.1: Dec.  4, 2016 (v16pre-4), fix /root, $PATH
#	4.2: Jan.  2, 2017 (v16 official release)
#	4.3: Mar. 13, 2017 (v16 test#1)	
#	4.4: Mar. 13, 2017 (v16 test#2)	
#	4.5: Aug. 12, 2017 (v17pre-1), FreeBSD 11.1R
#	4.7: Sep. 18, 2017 (v17pre-2), FreeBSD 11.1R, USB
#	4.8: Jul. 17, 2018 (v18pre-0), FreeBSD 11.2R
#	4.9: Sep. 23, 2019 (v19pre-0), FreeBSD 12.0R
#	5.0: Mar.  1, 2020 (v20pre-0), FreeBSD 11.3R
#	5.1: May  17, 2020 (v20pre-1), FreeBSD 11.3R, floppy
#

#
#   memo: v1.9, FreeBSD 12.0R ξ硢µǥ֡Ȥʤ
#	-> v2.0  11.3R 
#

#   usage:
#	# sh makeiso.sh [-t|-p|-f|-a|-u]
#		-t:  (tiny)
#		-u:  (tiny) for USB
#		-p: PXE (pxe-boot) (obsolated)
#		-f: ե륵 (full)
#		-a:  (all) (obsolated)
#
#   required install:
#	kern-developer, setc (/etc/source), ports
#
#   required packages/ports:
#	ja-nkf, cdrtools, smartmontools, rsync, ja-kon
#
#   required font files:
#	paw16vt.fnt in /usr/local/share/fonts/vt/
#	paw16*.bdf in /usr/local/share/fonts/bdf
#
#

# Ȥꤢư
cd /tmp

# ѥΥå
this="$0"
menudir=`dirname "$this"`
basedir=`dirname "$menudir"`
case "x$basedir" in
	x*v[0-9][0-9])
		;;
	*)
		echo "can't verifty script directory" 1>&2
		exit 1
		;;
esac

#
# ɤä??
#
##size=full	# CD-ROM˥ͤᤳС
size=tiny	# ξС
pxe=no
suffix=t
mkusb=NO
case x"$1" in
	x-[afm]*)
		size=full
		pxe=yes
		suffix=m
		;;
	x-[stp]*)
		size=tiny
		pxe=yes
		suffix=t
		;;
	x-[u]*)
		size=tiny
		pxe=yes
		suffix=t
		mkusb=YES
		;;
esac

# С
version='18'
if [ -r $basedir/version ]; then
	version=`cat $basedir/version`
else
	echo 'unable to set version number' 1>&2
	exit 1
fi

#minor='997'	# 2017-09-18 for v17 (dist)
#minor='998'	# 2017-09-18 for v17 (test)
#minor='999'	# 2017-08-12 for v17 (test)
#minor="003"	# 2017-03-14 for WhiteDay
minor='996'	# 2020-05-17 v20 (legacy console mode)
#minor='997'	# 2020-05-16 v20 (present, auxfiles, images)
#minor='998'	# 2020-05-07 v20 (USB)
#minor='999'	# 2020-05-01 for v20
#minor='000'	# official release: 000, 001, 002,...
if [ -r $basedir/minor ]; then
	minor=`cat $basedir/minor`
fi

# 
output="/tmp/wpout${version}${suffix}.iso"
usbimg="/tmp/wpout${version}${suffix}.usb"
basename=`echo $output | sed 's/\.[^.]*$//' | sed 's+^.*/++'`

#
# ܥ塼٥
#      filename-maj-min
#      0123456789abcdef
#      WIPE-OUT-04M_001
#
volsuffix=`echo $suffix | tr a-z A-Z`
volid="WIPE-OUT-${version}${volsuffix}_${minor}"

# ॹ
timestamp=`date '+%Y-%m-%d'`
echo "$volid ($timestamp)" > /tmp/version.txt

# Υե뤽¾֤
srcdir=/home/dai/src/wipe-out/v$version/menu

# floppy
floppydir=/home/dai/src/wipe-out/v$version/floppy

# ͥ
ident=
case x${ident} in
	x)
		kerndir=/boot/kernel
		;;
	x*)
		kerndir=/boot/kernel.$ident
		;;
esac

# ɬפʤΤϤ?
for f in $srcdir/disksize $kerndir/kernel ; do
	if [ ! -r $f ]; then
		echo "can't open $f" 1>&2
		exit 1
	fi
done

if [ ! -f /usr/local/share/fonts/vt/paw16vt.fnt ]; then
	echo "can't find paw16vt.fnt" 1>&2
	exit 1
fi

#
# wipe-outΥե뷲
#
rc=rc
binaries="disksize stuff tinydate tinydump check makembr wpout-mbr.boot"
binaries="$binaries shell-on"
binaries="$binaries tread"
binaries="$binaries xd"
binaries="$binaries session"
sources="disksize.c stuff.c tinydate.c tinydump.c check.c makembr.c"
sources="$sources wpout-mbr.s"
sources="$sources shell-on.c"
sources="$sources tread.c"
#sources="$sources xd.c session.c"
sources="$sources session.c"
scripts="startup.sh mainmenu.sh seldisk.sh erase.sh fine-erase.sh"
scripts="$scripts sel-fine.sh verify.sh dump.sh writelog.sh"
scripts="$scripts copy.sh embr.sh crlf.sh floppylog.sh dummyread.sh"
scripts="$scripts kon2start.sh kon2alt.sh"
scripts="$scripts vtstart.sh"
scripts="$scripts sanitize.sh"
scripts="$scripts alt-menu.sh"
scripts="$scripts scsaver.sh"
scripts="$scripts atasecurity.sh waitsecure.sh"
scripts="$scripts chime.sh timer.sh poko.sh"
misc="info.txt readme.txt help.txt"
misc="$misc mani.txt"
termcap="termcap"
textfiles="$rc $scripts $misc $termcap $sources"
appdir=/home/dai/src/wipe-out/v$version/app
appfiles="README.TXT configure exifrescue exifrescue.c wipe-out.sh"
appfiles="$appfiles xd.c codeconv.c codeconv.h ucs2jis.c ucs2jis.h"

# ------------------------------------------------------------ #
images="wpout08f.flp"
images="$images /wpout08.flp"
images="$images /wpout18t-2018-08-08.usb"
images="$images /wpout16t-2016-12-18.iso"
images="$images /wpout20t-2020-05-06.iso"
images="$images /wpout16t-2016-12-18.usb"
images="$images /wpout20t.2020-05-06.usb"
images="$images /wpout18t-2018-08-08.iso"
# ------------------------------------------------------------ #
#images="NO"	# ǤΥ᡼ե򥳥ԡʤ
images="NO"

auxfiles="wipe3p.pdf exifrescue.c"
#auxfiles="NO"	# ޥΥե򥳥ԡʤ
auxfiles="NO"

#
# FreeBSDΥƥե
#

# MFS˺ǥ쥯ȥ
dirs="bin sbin lib libexec etc dev tmp"
dirs="$dirs usr.bin usr.sbin usr.lib"
dirs="$dirs usr/local/bin usr/local/etc usr/local/sbin"
dirs="$dirs usr/local/share/fonts/vt"
#dirs="$dirs a mnt cdrom floppy"
dirs="$dirs a mnt cdrom floppy fd-mode"
dirs="$dirs var/run var/tmp var/db var/log"
dirs="$dirs usr/share/misc"
dirs="$dirs wipeout"

#
# MFS˥ԡե
#

# /bin
bins="sh echo dd test expr cat sleep"
bins="$bins cp date mkdir sync"
bins="$bins csh df hostname kill ln ls mv ps rm"

# /sbin
sbins="init ldconfig mount dmesg mount_cd9660"
sbins="$sbins umount shutdown"
#sbins="$sbins mount_msdosfs mount_nfs mount_ntfs"
sbins="$sbins mount_msdosfs mount_nfs"
sbins="$sbins camcontrol"

# /usr/bin
ubins="sed dialog hd id wall tty script tr vi"

# /usr/sbin
usbins="kbdcontrol powerd vidcontrol"

# /usr/local/bin
ulbins="kon kon2fixed fld nkf ng"
#ulbins="kon fld "

# /usr/local/sbin
ulsbins="smartctl"

cp /dev/null /tmp/libs-ldd.txt
for b in $bins; do
	ldd /bin/$b >> /tmp/libs-ldd.txt
done
for b in $sbins; do
	ldd /sbin/$b >> /tmp/libs-ldd.txt
done
for b in $ubins; do
	ldd /usr/bin/$b >> /tmp/libs-ldd.txt
done
for b in $usbins; do
	ldd /usr/sbin/$b >> /tmp/libs-ldd.txt
done
for b in $ulbins; do
	ldd /usr/local/bin/$b >> /tmp/libs-ldd.txt
done
for b in $ulsbins; do
	ldd /usr/local/sbin/$b >> /tmp/libs-ldd.txt
done

cat /tmp/libs-ldd.txt | grep '=>' |
	awk '{print $3}' | sort | uniq > /tmp/libs-ldd-uniq.txt
#
# ɬפʥ饤֥ ldd(1) ޥɤǳǧ
#

# /lib
#libs="libc.so.? libcrypt.so.? libedit.so.? libncurses.so.? libutil.so.?"
#libs="$libs libkvm.so.? libkiconv.so.? libm.so.?"
#libs="$libs libcam.so.? libgcc_s.so.? libsbuf.so.?"
#
#libs="$libs libjail.so.?"	# 9.3R (/bin/ps)
#libs="$libs libncursesw.so.?"	# 9.3R (/usr/bin/dialog)
#libs="$libs libthr.so.?"	# 9.3R (/usr/local/sbin/smartctl)
#libs="$libs libcxxrt.so.?"	# 10.3R (/usr/local/sbin/smartctl)


libs=`cat /tmp/libs-ldd-uniq.txt | grep '^/lib/' | sed 's+^/lib/++'`
libexecs="ld-elf.so.?"

# /usr/lib
#ulibs="libdialog.so.? libbsm.so.? libstdc++.so.? libusb.so.?"
#ulibs="libdialog.so.? libbsm.so.? libusb.so.? libc++.so.?"
ulibs=`cat /tmp/libs-ldd-uniq.txt | grep '^/usr/lib/' | sed 's+^/usr/lib/++'`

uletcs="kon.cfg"
#ulbins=""
#uletcs=""
vtfonts="paw16vt.fnt"
fonts="paw16a.bdf paw16k.bdf"


#
# mfsroot.gz κ
#

# ᡼ե
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=10
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=12
#dd if=/dev/zero bs=1m of=/tmp/mfsroot count=16
dd if=/dev/zero bs=1m of=/tmp/mfsroot count=20

# 
mdconfig -a -t vnode -f /tmp/mfsroot -u 0
bsdlabel -w md0 auto
newfs -i 4096 md0a
# default value of i option: 8192 -> 320 inodes
# 4096 -> 576, 2048 -> 1088 inodes


# ޥ
mount /dev/md0a /mnt
cd /mnt

# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT /mnt
 
# СϿ
cp /tmp/version.txt /mnt

# ɬפʥǥ쥯ȥ
cd /mnt
for d in $dirs ; do
	mkdir -p $d
done

# 2020-05-18
cd /mnt
ln -s wipeout menu

chmod 777 /tmp

# /etc 
cd /mnt/etc

# ѥɥȥ
echo 'root::0:0:Charlie &:/:/bin/sh' > /mnt/etc/passwd
echo 'root::0:0::0:0:Charlie &:/:/bin/sh' > /mnt/etc/master.passwd
pwd_mkdb -d /mnt/etc /mnt/etc/master.passwd

# login.conf
cp -p /usr/src/etc/login.conf /mnt/etc
cap_mkdb /mnt/etc/login.conf

# fstab
echo '# device	mount	fstype	options	dump	pass'	>  /mnt/etc/fstab
echo '/dev/md0a	/	ufs	rw	1	1'	>> /mnt/etc/fstab

# ttys
cp -p /usr/src/etc/etc.i386/ttys /mnt/etc

etcs="group services protocols"
etcs="$etcs profile libmap.conf login.access"
for f in $etcs ; do
	cp -p /usr/src/etc/$f /mnt/etc
done

cp -p /usr/src/etc/root/dot.profile /mnt/.profile
echo 'PATH="$PATH:/usr.bin:/usr.sbin:/wipeout"' >> /mnt/.profile
echo 'export PATH' >> /mnt/.profile

cp -p $srcdir/dot.cshrc /mnt/.cshrc

mkdir -p /mnt/root
cp /mnt/.profile /mnt/.cshrc /mnt/root

# wipe-outϢΥե/etc˥ԡ
cd $srcdir
cp $rc /mnt/etc/rc
chmod +x /mnt/etc/rc
#cp $termcap /mnt/etc

# /wipeout ɬפʥե򥳥ԡ
cd $srcdir
cp $binaries /mnt/wipeout
cp $scripts /mnt/wipeout
#for f in $scripts; do
#	nkf -w $f > /mnt/wipeout/$f
#done
cp $misc /mnt/wipeout
#for f in $misc; do
#	nkf -w $f > /mnt/wipeout/$f
#done

cd /mnt/wipeout
chmod +x $scripts


# floppyǥݡ
cd /mnt/fd-mode
#(cd $floppydir | tar cf - ./) | tar xvf -
( cd /home/dai/src/wipe-out/v20/floppy ; tar cf - . ) | tar xvf -

# /bin
cd /mnt/bin
for f in $bins ; do
	cp -p /bin/$f .
done
# link
ln 'test' '['
# symlink
for i in `/bin/ls /bin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/bin/$i $i
	fi
done

# /sbin
cd /mnt/sbin
for f in $sbins ; do
	cp -p /sbin/$f .
done
# symlink
for i in `/bin/ls /sbin`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/sbin/$i $i
	fi
done

# /lib
cd /mnt/lib
for f in $libs ; do
	cp -p /lib/$f .
done
# symlink
for i in `/bin/ls /lib`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/lib/$i $i
	fi
done

# /libexec
cd /mnt/libexec
for f in $libexecs ; do
	cp -p /libexec/$f .
done
# symlink
for i in `/bin/ls /libexec`; do
	if [ ! -f $i ]; then
		ln -s /cdrom/libexec/$i $i
	fi
done

# /usr/bin
cd /mnt/usr.bin
for f in $ubins ; do
	cp -p /usr/bin/$f .
done
#
####cp -p /usr/src/usr.bin/login/login /mnt/usr.bin/login2 
#
ln id whoami
ln id groups
# vi
#ln -s /cdrom/usr/bin/vi vi

# /usr/sbin
cd /mnt/usr.sbin
for f in $usbins ; do
	cp -p /usr/sbin/$f .
done

# /usr/lib
cd /mnt/usr.lib
for f in $ulibs ; do
	cp -p /usr/lib/$f .
done

# other /usr directories
cd /mnt/usr
udirs="bin sbin lib libexec"
for d in $udirs ; do 
	ln -s /cdrom/usr/$d $d
done

# /usr/local/bin
cd /mnt/usr/local/bin
for f in $ulbins ; do
	cp -p /usr/local/bin/$f .
done
#ln -s /cdrom/usr/bin/ng ng

# /usr/local/etc
cd /mnt/usr/local/etc
for f in $uletcs ; do
	cp -p /usr/local/etc/$f .
done

# /usr/local/sbin
cd /mnt/usr/local/sbin
for f in $ulsbins ; do
	cp -p /usr/local/sbin/$f .
done

# bdf font
mkdir -p /mnt/usr/local/share/fonts/bdf
for f in $fonts ; do
	cp -p /usr/local/share/fonts/bdf/$f /mnt/usr/local/share/fonts/bdf
done

# vt font
mkdir -p /mnt/usr/local/share/fonts/vt
for f in $vtfonts ; do
	cp -p /usr/local/share/fonts/vt/$f /mnt/usr/local/share/fonts/vt
done

# /var
vars="run/utx.active log/utx.log log/utx.lastlogin"
for f in $vars ; do
	touch /mnt/var/$f
done

# /usr/share/locale
#langs="UTF-8 ja_JP.SJIS ja_JP.UTF-8 ja_JP.eucJP"
#for f in $langs ; do
#	mkdir -p /mnt/usr/share/locale/$f
#	(cd /usr/share/locale/$f ; tar cf - .) |
#		(cd /mnt/usr/share/locale/$f; tar xf -)
#done

#langs="C ja_JP.SJIS ja_JP.UTF-8 ja_JP.eucJP"
#for f in $langs ; do
#	mkdir -p /mnt/usr/share/nls/$f
#	(cd /usr/share/nls/$f ; tar cf - .) |
#		(cd /mnt/usr/share/nls/$f; tar xf -)
#done
#(cd /mnt/usr/share/nls; ln -s C POSIX)


# /usr/share/misc
usms="termcap.db termcap"
for f in $usms ; do
	cp -p /usr/share/misc/$f /mnt/usr/share/misc/$f
done
(cd /mnt/etc; ln -s ../usr/share/misc/termcap)
cp $srcdir/termcap /mnt/usr/share/misc/termcap
cap_mkdb /mnt/usr/share/misc/termcap

# ޥȤư
cd /tmp
umount /mnt
mdconfig -d -u 0
gzip --best < /tmp/mfsroot > /tmp/mfsroot.gz

# 
# ֡ȥ᡼κ
#
if [ -d /tmp/cdfs ]; then
	chflags -R 0 /tmp/cdfs
	rm -rf /tmp/cdfs
fi

mkdir -p /tmp/cdfs/boot/kernel
mkdir -p /tmp/cdfs/boot/modules
mkdir -p /tmp/cdfs/boot/defaults

# 11.3R
mkdir -p /tmp/cdfs/boot/lua

# FreeBSD Copyright򥳥ԡ
cp /COPYRIGHT /tmp/cdfs

#bootfils="boot* cdboot loader* mbr pxeboot"
# 11.3R
bootfils="boot* cdboot loader* mbr pxeboot pmbr"
bootfils="$bootfils beastie.4th frames.4th loader.4th screen.4th support.4th"
# --9.3R --
bootfils="$bootfils *.4th"
# --9.3R --
#bootfils="$bootfils device.hints loader.conf loader.help loader.rc"
bootfils="$bootfils device.hints"
# --9.3R --
bootfils="$bootfils *.rc"
# --11.3R --
bootfils="$bootfils logo*"

for f in $bootfils ; do
	cp -p /boot/$f /tmp/cdfs/boot
done

# -- 11.3R
for f in /boot/lua/* ; do
	cp -p $f /tmp/cdfs/boot/lua
done

cp -p /boot/defaults/loader.conf /tmp/cdfs/boot/defaults

# use sc(4) for kon
grep -v 'kern.vty' /boot/loader.conf |
	grep -v 'pty_' > /tmp/cdfs/boot/loader.conf
echo 'kern.vty=sc' >> /tmp/cdfs/boot/loader.conf
echo 'pty_load="YES"' >> /tmp/cdfs/boot/loader.conf

echo 'mfsroot_load="YES"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_type="mfs_root"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_name="/boot/mfsroot"' >> /tmp/cdfs/boot/loader.conf
echo 'mfsroot_before="echo -n '"'"'mfsroot '"'"'"' \
	>> /tmp/cdfs/boot/loader.conf
echo 'vfs.root.mountfrom="ufs:/dev/md0a"' >> /tmp/cdfs/boot/loader.conf

# 2009-09-29 (IBM ServeRAID support test) -> no need? (2012-12-22)
echo 'ips_load="YES"' >> /tmp/cdfs/boot/loader.conf

# 2013-10-11 (siis(4) eSATA support test)
echo 'siis_load="YES"' >> /tmp/cdfs/boot/loader.conf

# 2013-10-12 (xhci(4) USB 3.0 support test)
echo 'xhci_load="YES"' >> /tmp/cdfs/boot/loader.conf

# 2015-08-04 (mps(4) LSI Fution-MPT SAS driver support test)
echo 'mps_load="YES"' >> /tmp/cdfs/boot/loader.conf

cp -p $kerndir/kernel /tmp/cdfs/boot/kernel
cp -p $kerndir/linker.hints /tmp/cdfs/boot/kernel
#cp -p $kerndir/acpi.ko /tmp/cdfs/boot/kernel
cp -p $kerndir/acpi*.ko /tmp/cdfs/boot/kernel
#
cp -p $kerndir/ips.ko* /tmp/cdfs/boot/kernel
cp -p $kerndir/siis.ko* /tmp/cdfs/boot/kernel
cp -p $kerndir/xhci.ko* /tmp/cdfs/boot/kernel
cp -p $kerndir/mps.ko* /tmp/cdfs/boot/kernel
#
cp -p $kerndir/pty.ko* /tmp/cdfs/boot/kernel

# 2020-05-17 speaker
#cp -p $kerndir/speaker.ko* /tmp/cdfs/boot/kernel

#
# 2016-12-06
#for i in ucom uark uchcom uftdi umcs umct umodem uplcom ; do
#
# 2020-05-17 speaker
for i in ucom uark uchcom uftdi umcs umct umodem uplcom speaker ; do
	cp -p $kerndir/$i.ko* /tmp/cdfs/boot/kernel
	echo "$i"'_load="YES"' >> /tmp/cdfs/boot/loader.conf	
done

cp /tmp/mfsroot.gz /tmp/cdfs/boot/mfsroot.gz

# 礭Ǥ $kerndir/* 򥳥ԡ
case x"$size" in
    x[af]*)
	cp -p $kerndir/* /tmp/cdfs/boot/kernel
	;;
esac	

# 켰򥳥ԡ
mkdir -p /tmp/cdfs/src
cd $srcdir
cp -p * /tmp/cdfs/src

# Windows桼˥եJISΥեѰ
for i in $misc ; do
	nkf -s -c $i > /tmp/cdfs/$i
done
nkf -s -c /tmp/version.txt > /tmp/cdfs/version.txt

mkdir -p /tmp/cdfs/sjis
for i in $textfiles ; do
	nkf -s -c $i > /tmp/cdfs/sjis/$i
done

cd $appdir
mkdir -p /tmp/cdfs/app
for i in $appfiles ; do
	cp -p $i /tmp/cdfs/app
done

#
mkdir -p /tmp/cdfs/usr/bin
cp -p /usr/bin/vi /tmp/cdfs/usr/bin
mkdir -p /tmp/cdfs/usr/local/bin
cp -p /usr/local/bin/ng /tmp/cdfs/usr/local/bin

# ޥ˥
case x"$size" in
    x[af]*)
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p /tmp/cdfs/$d
		cd /tmp/cdfs/$d
		(cd /$d; tar cf - . ) | tar xvpf -
	done
	cddirs="bin sbin lib libexec"
	for d in $cddirs ; do
		mkdir -p /tmp/cdfs/usr/$d
		cd /tmp/cdfs/usr/$d
		(cd /usr/$d; tar cf - . ) | tar xvpf -
	done
	# ä
	cd /tmp/cdfs/usr/libexec
	/bin/rm -rf cc1* f77* lpr sendmail sm.bin
	cd /tmp/cdfs/usr/lib
	/bin/rm -rf aout compat lib*.a
	cd /tmp/cdfs/usr/sbin
	/bin/rm -rf named* dns* lwresd*	
	;;
esac

# ǤΥ᡼ե򥳥ԡ (CD)
case x"$images" in
	xNO)
		;;
	*)
		mkdir -p /tmp/cdfs/images
		for i in $images ; do
			if [ -f /tmp/$i ]; then
				cp -p /tmp/$i /tmp/cdfs/images
			fi
		done
		;;
esac

# ޥΥե򥳥ԡ (CD)
case x"$auxfiles" in
	xNO)
		;;
	*)
		mkdir -p /tmp/cdfs/auxfiles
		for i in $auxfiles ; do
			if [ -f /tmp/$i ]; then
				cp -p /tmp/$i /tmp/cdfs/auxfiles
			fi
		done
		;;
esac


# ISO᡼
cd /tmp
mkisofs -b boot/cdboot -no-emul-boot -c boot.catalog \
	-r -J -V $volid -o /tmp/$basename.iso /tmp/cdfs

# USB᡼
case x"$mkusb" in
    xYES)
	cd /tmp

	# 3 * 255 * 63 * 512 = 24,6758,403 =~ 24Mbytes
	#ncyls=6
	#nhead=128
	#nsect=62
	#
	# 1GB microSD
	# 1022 * 32 * 61 * 512 = 1,021,411,328 =~ 1Gbytes (original)
	ncyls=1022
	nhead=32
	nsect=61
	#
	# -------------
	# md0s1 FAT  4M -> 6M
	# md0s2 UFS 32M -> 36M (v17)
	# md0s3 FAT  4M -> 6M
	# -------------
	# 53 * 32 * 61 * 512 = 52,969,472 bytes =~ 53MB
	xcyls=53
	#
	ncnt=$(( ($xcyls * $nhead * $nsect * 512 + 1048576 - 1) / 1048576 ))
	# 32MХȤΥ᡼
	dd if=/dev/zero of=$usbimg bs=1048576 count=$ncnt

	# ᡼
	mdconfig -a -t vnode -f $usbimg -u 0 -x $nsect -y $nhead

	# fdiskѾ
	#   geometry	sector	head	cylinder
	echo	"g	s$nsect	h$nhead	c$ncyls"	>  /tmp/fdisk.conf
	#    partition	slice	sysid	start	length
	echo	"p	1	6	$nsect	6M"	>> /tmp/fdisk.conf
	echo	'p	2	165	*	40M'	>> /tmp/fdisk.conf
	echo	'p	3	6	*	6M'	>> /tmp/fdisk.conf
	echo	'p	4	0	0	0'	>> /tmp/fdisk.conf
	#    slice #2 is bootable (active)
	echo	'a	2'				>> /tmp/fdisk.conf

	# Ȥꤢ֡ȥ񤭹
	fdisk -v -BI md0
	# fdisk.conf ˴Ťƥѡƥ
	fdisk -v -f fdisk.conf md0

	# FAT16 (sysid == 6) եޥåȤƥǥ쥯ȥ
	newfs_msdos /dev/md0s1
	mount -t msdosfs /dev/md0s1 /mnt
	mkdir /mnt/WIPE-OUT
	cp -p /tmp/cdfs/*.txt /mnt
	mkdir /mnt/SJIS
	( cd /tmp/cdfs/sjis ; tar cf - . ) | ( cd /mnt/SJIS ; tar xvf -)
	df -k /mnt
	umount /mnt
	newfs_msdos /dev/md0s3

	# UFS (/dev/da0s2a) 
	bsdlabel -w -B /dev/md0s2
	newfs /dev/md0s2a
	mount /dev/md0s2a /mnt
	( cd cdfs ; tar cf - . ) | ( cd /mnt ; tar xvpf - )
	df -k /mnt
	umount /mnt
	fdisk /dev/md0

	# ᡼ڤΥ
	mdconfig -d -u 0
	;;
esac

# 
/bin/rm -f $basename.lzh $basename.tgz
#lha ao5 $basename.lzh $basename.iso
#tar czvf $basename.tgz $basename.iso

#
# ޤ
#
