#! /bin/sh
#
#   sanitize.sh -- camcontrol sanitize ǥǡõ
#
#	Ȥ: /bin/sh sanitize.sh ǥ
#		: /bin/sh sanitize da0
#
#	0.0: Aug.  4, 2015 by Dai ISHIJIMA (for wpout15, FreeBSD 9.3R)
#

ERRORLOG="${ERRORLOG:-/tmp/wperrlog.txt}"
exec 2>> $ERRORLOG
echo "# start $0, $@" 1>&2
echo '# ---------------------------- #' 1>&2

# ñȤǤư褦
LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
DMESG="${DMESG:-/var/run/dmesg.boot}"

echo '# ---------------------------- #' >> $LOGFIL
echo -n "script $0 started on " >> $LOGFIL
date >> $LOGFIL

echo "starting scsi sanitize ($TTYNAME)" > $STATEFIL

#
method="${1:-crypto}"
disk="${2:-da0}"
dmesg="${DMESG:-/var/run/dmesg.boot}"

#
resultfil=/tmp/result

#
title="${TITLE:-ϡɥǥõġwipe-out}"

#
if [ ! -w /dev/$disk ]; then
	dialog	--title "$title" \
		--msgbox "ǥ $disk ¸ߤʤ񤭹ߤǤޤ" \
		5 64
	exit 1
fi

#
mount -p | sed -n -E "/^.dev.$disk/p" > $resultfil
if [ -s $resultfil ]; then
	dialog	--title "$title" \
	    --msgbox "ޥΥǥ $disk õ뤳ȤϤǤޤ" \
	    5 64
	exit 1
fi

dname=`sed -n -E "/^${disk}:.*<.*>/p" $dmesg | sed 's/.*\(<.*>\).*/\1/'`
bytes=`disksize -B /dev/$disk`
cap=`disksize -p /dev/$disk`

msg="ǥ ${disk} ${dname} \n"
msg="${msg}ǡ ${bytes}ХȤ\n"
msg="${msg}˥ǽ (Sanitize Device Feature) Ǿõޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="ATAǥХUSB³ΥǥХʤSCSIǥХǤ\n"
msg="${msg}˥ (SCSI Sanitize) ưʤä\n"
msg="${msg}ｪλƤǡξõ¹ԤƤʤȤޤ\n"
msg="${msg}\n                      Ǥ?"

sh dummyread.sh
dialog --title "$title" --yesno "$msg" 9 64

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac


msg="${disk} ($cap) Υǡ򥵥˥ƤǤ?"

sh dummyread.sh
dialog	--title "$title" \
	--hline "$dname" \
	--yesno "$msg" \
	5 72

case x"$?" in
	x1)
		dialog	--title "$title" \
			--infobox 'ǥξõ򥭥󥻥뤷ޤ' 3 64
		sleep 2
		exit 1
		;;
esac

dialog	--title "$title" \
	--infobox 'ǥ򥵥˥Ƥޤ' 3 64

sleep 2

# ϻ
startstamp=`date '+%Y-%m-%d %H:%M'`

#
echo "v ---------------------------- v" >> $LOGFIL
echo -n "sanitize $method ($TTYNAME) started on " >> $LOGFIL
date >> $LOGFIL

echo "erasing $disk with scsi sanitize ($TTYNAME)" > $STATEFIL

date '+%s' > /tmp/secure-stamp-${TTYNAME}.txt
sh waitsecure.sh /tmp/secure-stamp-${TTYNAME}.txt &
echo "sanitize $method $disk ($dname) $bytes bytes" >> $LOGFIL
script /tmp/sanitize-${TTYNAME}.txt \
	/sbin/camcontrol sanitize $disk -a $method -y
case x"$?" in
	x0)
		status="finished"
		echo "˥ｪλޤ" > /tmp/sanitizemsg.txt
		;;
	*)
		status="failed"
		echo "˥ưޤǤ" > /tmp/sanitizemsg.txt
		;;
esac
cp /dev/null /tmp/secure-stamp-${TTYNAME}.txt
echo '' >> $LOGFIL
echo '::: Sanitize (camcontrol output) :::' >> $LOGFIL
nkf -d /tmp/sanitize-${TTYNAME}.txt >> $LOGFIL

echo 'ޥɼ¹ԻΥϰʲΤȤǤ' >> /tmp/sanitizemsg.txt
#echo 'ǥ뤷ޤ' >> /tmp/sanitizemsg.txt
echo '' >> /tmp/sanitizemsg.txt
echo '/* ======== */' >> /tmp/sanitizemsg.txt
nkf -d /tmp/sanitize-${TTYNAME}.txt >> /tmp/sanitizemsg.txt

echo "show result of scsi sanitize ($TTYNAME)" > $STATEFIL

sh dummyread.sh
dialog	--title 'SCSI˥Υ' --textbox /tmp/sanitizemsg.txt 19 76

#

echo -n "sanitize $status on " >> $LOGFIL
date >> $LOGFIL
echo "sanitize $disk ($dname, $cap)" >> $LOGFIL
echo "^ ---------------------------- ^" >> $LOGFIL

# λ
endstamp=`date '+%H:%M'`

case x"$status" in
    xfinished)
	# ¸
	echo 'The contents of this storage device' > /tmp/erase-log.$disk
	echo "$disk ($cap) '$dname'" >> /tmp/erase-log.$disk
	echo -n 'were erased with ' >> /tmp/erase-log.$disk
	echo 'hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
	echo "Erased with 'SANITIZE'" >> /tmp/erase-log.$disk
	echo " $startstamp -> $endstamp" >> /tmp/erase-log.$disk
	echo "but NOT verified" > /tmp/verify-log.$disk
	;;
esac

#
echo '# ---------------------------- #' 1>&2

exit 0

# EOF
