#! /bin/sh
#
#   vtsstart.sh -- ȥ󤷤ĤġɤΥ⡼ɤ˰ܹԤ뤫
#
#	0.0: May   5, 2009 by Dai ISHIJIMA (as countdown.sh)
#	0.1: Apr. 11, 2011 for wpout11
#	0.2: Oct. 11, 2013 (use /dev/ttyv0, wpout13)
#	0.3: May  11, 2014 (comconsole -> serial console)
#	0.4: Aug   3, 2015 (FreeBSD 9.3R, kon -s for single user mode)
#	0.5: Jul. 26, 2016 (10.3R, vt), as vtstart.sh
#

export TTY="${TTY:-ttyv0}"
export LOGFIL="${LOGFIL:-/tmp/wpoutlog.txt}"
####export TERMCAP=/etc/termcap
export TERM=vt100		# for kon

echo ''
echo 'Starting another console session on VTY3 (Alt+F4)'
/wipeout/shell-on /dev/ttyv3
echo 'You can start another wipe-out session with "sh kon2alt.sh"' \
	> /dev/ttyv3
echo -n "Starting console session on VTY3" >> $LOGFIL
date >> $LOGFIL

export STATEFIL=/tmp/status.txt
echo -n 'selecting console' > $STATEFIL

echo 'Starting screen saver on VTY7 (Alt+F8)'
/wipeout/shell-on /dev/ttyv7 /bin/sh /wipeout/scsaver.sh
echo -n "Starting screen saver on VTY7" >> $LOGFIL
date >> $LOGFIL

echo ''


echo ''
echo ''
echo "# select console mode"
echo "    0: Start wipe-out on VT console [default]"

if [ -c /dev/cuau0 ]; then
	echo "    c: Start wipe-out on serial console (regacy serial, uart0)"
fi
if [ -c /dev/cuaU0 ]; then
	echo "    u: Start wipe-out on serial console (USB adaptor, ucom0)"
fi

echo "    2: Start interactive shell, stay in Native console (non Japanese)"


prompt="# Just press ENTER to select default mode"

count=9

while [ $count -gt 0 ]; do
	echo -e "\r$prompt[$count] \c"
	if read -t 1 keyin 1>/dev/null 2>&1 ; then
		count=0
	fi
	count=$(( $count - 1 ))
done

case x"$count" in
	x0)
		echo -e "\r$prompt[0] 0"
		keyin=0		
		;;
esac


echo -n "vtstart with keyin = $keyin, " >> $LOGFIL
date >> $LOGFIL


case x"$keyin" in
	x2)
		/bin/sh -i
		;;
	xc)
		export TTY=comconsole.cuau0
		dmesg > /dev/cuau0
		/wipeout/shell-on /dev/cuau0 /bin/sh /wipeout/startup.sh
		;;
	xu)
		export TTY=comconsole.cuaU0
		dmesg > /dev/cuaU0
		/wipeout/shell-on /dev/cuaU0 /bin/sh /wipeout/startup.sh
		;;
	*)
		/usr.sbin/vidcontrol -f /usr/local/share/fonts/vt/paw16vt.fnt
		export LC_CTYPE=ja_JP.UTF-8
		/bin/sh /wipeout/startup.sh
		;;
esac

echo -n "vstart.sh finished, " >> $LOGFIL
date >> $LOGFIL

exit 0

# EOF

