#! /bin/sh
#
#   vtstart.sh -- カウントダウンしつつ、どのモードに移行するか選択
#
#	0.0: May   5, 2009 by Dai ISHIJIMA (as countdown.sh)
#	0.1: Apr. 11, 2011 for wpout11
#	0.2: Oct. 11, 2013 (use /dev/ttyv0, wpout13)
#	0.3: May  11, 2014 (comconsole -> serial console)
#	0.4: Aug   3, 2015 (FreeBSD 9.3R, kon -s for single user mode)
#	0.5: Jul. 26, 2016 (10.3R, vt), as vtstart.sh
#	0.6: Jul.  6, 2025 (14.2R, vt, EFI, ja_JP.UTF-8)
#

# VTY2 @ 2025-09-20
echo ''
echo '別のコンソールセッションを VTY2 (Alt+F2) で起動しています。'
/wipeout/shell-on /dev/ttyv1
echo 'You can start another wipe-out session with "sh vt-alt.sh"' \
	> /dev/ttyv1
vidcontrol -f $VTFONT < /dev/ttyv1

echo -n "Starting console session on VTY2" >> $LOGFIL
date >> $LOGFIL

echo -n 'selecting console' > $STATEFIL

echo 'スクリーンセーバーを VTY7 (Alt+F8) で起動しています。'
/wipeout/shell-on /dev/ttyv7 /bin/sh /wipeout/scsaver.sh
vidcontrol -f $VTFONT < /dev/ttyv7

echo -n "Starting screen saver on VTY7" >> $LOGFIL
date >> $LOGFIL

echo ''


echo ''
echo ''
echo "# 「wipe-out」を起動するコンソールを選んでください："
echo "    0: このコンソールで起動する [規定値]"

if [ -c /dev/cuau0 ]; then
	echo "    c: シリアルコンソールで起動する (レガシーシリアル: uart0)"
fi
if [ -c /dev/cuaU0 ]; then
	echo "    u: USBシリアルコンソールで起動する (USBシリアル: ucom0)"
fi

echo "    S: 「wipe-out」ではなく、単にシェルを起動する"


prompt="# ENTERキーだけを押すと、このコンソールで「wipe-out」を動かします "

count=9
keyin=0
. /wipeout/ncountdown.sh

echo -n "vtstart with keyin = $keyin, " >> $LOGFIL
date >> $LOGFIL

case x"$keyin" in
	xS)
		/bin/sh -i
		;;
	xc)
		export TTY=comconsole.cuau0
		dmesg > /dev/cuau0
		/wipeout/shell-on /dev/cuau0 /bin/sh /wipeout/startup.sh
		;;
	xu)
		export TTY=comconsole.cuaU0
		dmesg > /dev/cuaU0
		/wipeout/shell-on /dev/cuaU0 /bin/sh /wipeout/startup.sh
		;;
	*)
		/bin/sh /wipeout/startup.sh
		;;
esac

echo -n "vstart.sh finished, " >> $LOGFIL
date >> $LOGFIL

exit 0

# EOF
