#! /bin/sh
#
#   writelog.sh -- 消去ログをディスクに書き込む
#
#	使い方: /bin/sh writelog.sh ディスク
#		ディスク: デバイスファイルで指定、先頭の「/dev/」は省く
#		例: /bin/sh writelog.sh ad0
#
#	0.0: Aug.  1, 2006 by Dai ISHIJIMA (for wpout07)
#	0.1: Aug.  7, 2006 念入りに確認
#	0.2: Feb. 10, 2007 (ログ記録 for wpout08)
#	0.3: Feb. 15, 2007 (エンターキー長押し対策)
#	0.4: Sep. 12, 2007 (wpout09)
#	0.5: Aug. 12, 2025 (wpout25, 14.2R, ja_JP.UTF-8)
#

disk="${1:-ad0}"
mbr="${MBR:-wpout-mbr.boot}"
title="${TITLE:-ハードディスク消去ツール『wipe-out』}"

# すでに消去済みか?
if [ ! -s /tmp/erase-log.$disk ]; then
	dialog	--title "$title" \
		--yesno '消去操作が行われていません\n本当に書き込みますか?' \
		6 64
	case x"$?" in
	    x1)
		dialog  --title "$title" \
			--infobox 'ログの書き込みをキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
	esac
fi

# 本当に消去されているのか?
dd if=/dev/$disk count=1 of=/tmp/org-mbr.$disk 1>/dev/null 2>&1
if ! check < /tmp/org-mbr.$disk 1>/dev/null 2>&1 ; then
	dialog	--title "$title" \
		--yesno 'MBRは0で消去されていません\n本当に書き込みますか?' \
		6 64
	case x"$?" in
	    x1)
		dialog  --title "$title" \
			--infobox 'ログの書き込みをキャンセルしました' 3 64
		sleep 2
		exit 1
		;;
	esac
fi

# ログが存在しなかったらそれらしく作成
if [ ! -s /tmp/erase-log.$disk ]; then
	echo 'The contents of this storage device' > /tmp/erase-log.$disk
	echo 'may have been erased' >> /tmp/erase-log.$disk
	echo 'with hard disk wiping tool "wipe-out."' >> /tmp/erase-log.$disk
fi

if [ ! -s /tmp/verify-log.$disk ]; then
	echo 'But NOT verified.' > /tmp/verify-log.$disk
fi

# 最終確認
sh dummyread.sh
dialog	--title "$title" \
	--yesno "消去ログをディスク ($disk) に書き込みますか?" \
	6 64
case x"$?" in
    x1)
	dialog  --title "$title" \
		--infobox 'ログの書き込みをキャンセルしました' 3 64
	sleep 2
	exit 1
	;;
esac

echo -n 'Logged: ' > /tmp/stamp-log.$disk
date '+%Y-%m-%d %H:%M:%S' >> /tmp/stamp-log.$disk
echo 'ABSOLUTELY NO WARRANTY.' >> /tmp/stamp-log.$disk


# 書き込み操作
cat $mbr /tmp/erase-log.$disk /tmp/verify-log.$disk /tmp/stamp-log.$disk |
	makembr > /tmp/boot.$disk

#
echo -n "MBR log was written on " >> $LOGFIL
date >> $LOGFIL
echo "==" >> $LOGFIL
cat /tmp/erase-log.$disk /tmp/verify-log.$disk /tmp/stamp-log.$disk >> $LOGFIL
echo "==" >> $LOGFIL

case x$DEBUG in
    x[Yy]*)
	echo 'debug mode, no write'
	mesg="消去ログをディスク ($disk) に書き込みました (in debug mode)"
	;;
    *)
	if dd if=/tmp/boot.$disk of=/dev/$disk > /dev/null 2>&1; then
		mesg="消去ログをディスク ($disk) に書き込みました"
	else
		mesg="消去ログをディスク ($disk) に書き込めませんでした"
	fi	
	;;
esac

sh dummyread.sh
dialog	--title "$title" --msgbox "$mesg" 5 72

exit 0

# EOF
