#! /bin/sh
#
#   makefd.sh -- ϡɥǥõѥ֡FDκ
#
#   revision history:
#	0.0: Oct. 26, 2001 by Dai ISHIJIMA
#	0.1: Oct. 22, 2002 (add diskinfo)
#	0.2: May   1, 2004 (4.8R, disklabel, random data)
#	0.3: May   1, 2004 (makefd.sh -> makeiso.sh)
#	0.4: Jun. 15, 2004 (dialog, cd9660)
#	0.5: Jun. 18, 2004 (makeiso.sh -> makefd.sh)
#	0.6: Jun. 21, 2005 (unchanged, but version number was changed)
#	0.7: Feb. 12, 2007 (for wpout08, expr/test -> builtin)
#	0.8: Feb. 16, 2007 (ͥȥե륷ƥʬΥ)
#
#   usage:
#	# sh makefd.sh
#

version='08'

# Υե뤽¾֤
srcdir=/home/dai/src/wipe-out/v$version/floppy

rc=rc
binaries="diskinfo stuff tinydate tinydump check makembr wpout-mbr.boot"
scripts="startup.sh mainmenu.sh seldisk.sh erase.sh fine-erase.sh sel-fine.sh verify.sh writelog.sh"

kernel=/sys/compile/MICRO/kernel
bins="dd sh"
sbins="init dmesg"
devs="all"
output=/tmp/wpout${version}f.flp
basename=`echo $output | sed 's/\.[^.]*$//' | sed 's+^.*/++'`
readme=readme${version}.txt

#
# եΥå
#
#if [ ! -f /usr/src/release/write_mfs_in_kernel.c ] ; then
#	echo 'unable to compile "write_mfs_in_kernel"'
#	exit 1
#fi

if [ ! -f $kernel ] ; then
	echo 'no kernel found'
	exit 1
fi

if [ ! -f /usr/src/usr.bin/sed/Makefile ] ; then
	echo 'no source for sed'
	exit 1;
fi


#echo "Making write_mfs_in_kernel..."
#
# write_mfs_in_kernel 
#
#mkdir /tmp/write_mfs_in_kernel
#cd /tmp/write_mfs_in_kernel
#cp /usr/src/release/write_mfs_in_kernel.c .
#cc -o write_mfs_in_kernel write_mfs_in_kernel.c

#
# sed Υѥ (static link)
#
if [ ! -x /tmp/sed/sed ]; then
	if [ ! -x /usr/src/usr.bin/sed ]; then
		echo 'no source of sed'
		exit 1
	fi
	echo "Making static-linked 'sed'..."
	cd /tmp
	(cd /usr/src/usr.bin; tar cf - sed) | tar xvf -
	cd sed
	patch -p1 < $srcdir/sed.patch
	make
fi

echo "Making file system onto MFS..."
#
# MFSե륷ƥ
#
cd /tmp
# 18, 160 -> 9kХ/ȥå, 320ȥå
dd of=mfs-image if=/dev/zero count=320 bs=9216
vnconfig -s labels -c /dev/vn0 mfs-image
# ǥ٥
disklabel -w -B -b /boot/boot1 -s /boot/boot2 /dev/rvn0c minimum2
newfs -t 2 -u 18 -l 1 -c 80 -i 2048 -m 5 -o space /dev/rvn0c

# -t [track/cylinder]
# -u [sectors/track]
# -l [interleave factor]
# -i [bytes/inode]
# -m [MINFREE]
# -o [optimize]

echo "Mounting MFS..."
#
# MFSޥȤ
#
mount /dev/vn0c /mnt

echo "Making device files..."
#
# ǥХե
#
mkdir /mnt/dev
cd /mnt/dev
cp /dev/MAKEDEV .
for i in $devs; do
	./MAKEDEV $i
done

echo "Making tmp..."
#
# /tmp ǥ쥯ȥ
#
mkdir /mnt/tmp
chmod 777 /mnt/tmp

# ޥȥݥ

echo "Making etc..."
#
# /etc ǥ쥯ȥ
#
mkdir /mnt/etc
cd /mnt/etc
echo 'root:*:0:0:Charlie &:/:/bin/sh' > /mnt/etc/passwd
echo 'root:*:0:0::0:0:Charlie &:/:/bin/sh' > /mnt/etc/master.passwd
pwd_mkdb -d /mnt/etc /mnt/etc/master.passwd

#
#
#
cd $srcdir
cp $rc /mnt/etc/rc
chmod +x /mnt/etc/rc

cp /usr/src/etc/etc.i386/ttys /mnt/etc
cp /usr/src/etc/group /mnt/etc

cp /usr/src/etc/login.conf /mnt/etc
cap_mkdb /mnt/etc/login.conf


echo "Copying binaries..."
#
# /bin
#
mkdir /mnt/bin
cd /mnt/bin
for i in $bins; do
	cp /bin/$i /mnt/bin/$i
done
cd /mnt/bin
####ln 'test' '['

mkdir /mnt/wipeout
cd $srcdir
cp $binaries /mnt/wipeout
cp $scripts /mnt/wipeout
cd /mnt/wipeout
chmod +x $scripts

#
# /sbin
#
mkdir /mnt/sbin
cd /mnt/sbin
for i in $sbins; do
	cp /sbin/$i /mnt/sbin/$i
done

#
# /usr
#
mkdir -p /mnt/usr/bin
cp /tmp/sed/sed /mnt/usr/bin

#
# /var
#
mkdir -p /mnt/var/run
mkdir -p /mnt/var/tmp

#
# MFS򥢥ޥ
#
cd /tmp
umount /mnt
vnconfig -u /dev/vn0

echo "Compressing kernel..."
#
#
#
cp $kernel /tmp
#/tmp/write_mfs_in_kernel/write_mfs_in_kernel /tmp/kernel /tmp/mfs-image

#
# ͥ򰵽
#
cd /tmp
gzip --best < /tmp/kernel > /tmp/kernel.gz
chmod +x kernel.gz

# 2007-02-16
gzip --best < /tmp/mfs-image > /tmp/mfsroot.gz

echo "Making boot floppy image..."

# 18, 80 -> 9kХ/ȥå, 160ȥå
dd of=floppy-image if=/dev/zero count=160 bs=9216
vnconfig -s labels -c /dev/vn0 floppy-image

# ǥ٥
disklabel -w -B -b /boot/boot1 -s /boot/boot2 /dev/rvn0c fd1440
newfs -t 2 -u 18 -l 1 -c 80 -i 65536 -m 0 -o space /dev/rvn0c

#
# եåԡ᡼ޥ
#
mount /dev/vn0a /mnt

#
# ̤ͥ򥳥ԡ
#
mkdir /mnt/boot
###cp /boot/boot1 /mnt/boot
###cp /boot/boot2 /mnt/boot
cp /boot/loader /mnt/boot

#
echo "load /kernel" > /mnt/boot/loader.rc
echo "echo -n '/mfsroot '" >> /mnt/boot/loader.rc
echo "load -t mfs_root /mfsroot" >> /mnt/boot/loader.rc
echo "echo ." >> /mnt/boot/loader.rc
echo "autoboot 10" >> /mnt/boot/loader.rc

cp -f /tmp/kernel.gz /mnt/kernel.gz
cp -f /tmp/mfsroot.gz /mnt/mfsroot.gz

cd /tmp
umount /mnt
vnconfig -u /dev/vn0

cp floppy-image $output
nkf -s -c < $srcdir/$readme > $readme

/bin/rm $basename.lzh $basename.tgz
lha ao5 $basename.lzh $readme $basename.flp
tar czvf $basename.tgz $readme $basename.flp

exit 0

# EOF
