/*
 *  crc.c -- CRC (Cyclic Redundancy Check) ׻
 *
 *  revision history:
 *	0.1: May 24, 1996 by Dai ISHIJIMA
 *		for BSD Filer [HP200LX <-> UNIX box]
 *	0.2: May 23, 2020 for wipe-out v2.0, FreeBSD 11.3R
 *
 *  ʸ:
 *      W.H.Press, et al.: Numerical Recipes in C
 *	(Cambridge University Press, 1992) 2nd ed., pp.896-901
 */

#include <stdio.h>
#include <stdlib.h>	/* 2025-06-22 */

#define YES 1
#define NO  0

#ifndef HP200LX
#define MAIN
#endif

/* ¿༰          6 5432 1098 7654 3210 */
/* #ifdef CCITT */
#ifndef HP200LX
#define GX 0x11021L /* 1 0001 0000 0010 0001: G(x) = x^16 + x^12 + x^5 + 1 */
#else
#define GX 0x18005L /* 1 1000 0000 0000 0101: G(x) = x^16 + x^15 + x^2 + 1 */
#endif

#define G ((unsigned short)(((unsigned long)GX) & 0xffff))


/* ɽΤɽ */
#define TABSIZ 256
static unsigned short crctbl[TABSIZ];


/* CRC *׻*  */
unsigned short rawcrc(unsigned short crc, unsigned char ch)
{
    unsigned int i;

    crc = crc ^ ch << 8;
    for (i = 0; i < 8; i++) {
	if (crc & 0x8000) {
	    crc = (crc <<= 1) ^ G;
	}
	else {
	    crc <<= 1;
	}
    }
    return(crc);
}


/* ɽΤν */
void tblini()
{
    unsigned int i;

    for (i = 0; i < TABSIZ; i++) {
	crctbl[i] = (0x0000ffff & rawcrc(i << 8, 0));
    }
}


#define lo(x) ((unsigned char)((x) & 0xff))
#define hi(x) (((unsigned char)((x) >> 8)) & 0xff)

static unsigned char revtab[16] = {
    0x0, 0x8, 0x4, 0xc, 0x2, 0xa, 0x6, 0xe,
    0x1, 0x9, 0x5, 0xd, 0x3, 0xb, 0x7, 0xf,
};

/* ӥåȤΤʤӤȿž롣: 11001010 -> 01010011 */
#define revord(x) ((revtab[(x) & 0x0f] << 4) | revtab[((x) & 0xf0) >> 4])
#define revord16(x) ((revord(lo(x)) << 8) | revord(hi(x)))


/* CRC缡׻ */
unsigned short crc16c(unsigned short crc, unsigned char ch, int rev)
{
    if (rev) {
	crc = revord16(crc);
	crc = crctbl[revord(ch) ^ hi(crc)] ^ lo(crc) << 8;
	crc = revord16(crc);
    }
    else {
	crc = crctbl[ch ^ hi(crc)] ^ lo(crc) << 8;
    }
    return(0x0000fffff & crc);
}


#ifdef BLOCKCALC
/* ʸCRC֤ */
unsigned short crc16(unsigned short crc, int len, unsigned char *s, int rev)
{
    int i;

    if (rev) {
	crc = revord16(crc);
    }
    for (i = 0; i < len; i++) {
	if (rev) {
	    crc = crctbl[revord(s[i]) ^ hi(crc)] ^ lo(crc) << 8;
	}
	else {
	    crc = crctbl[s[i] ^ hi(crc)] ^ lo(crc) << 8;
	}
    }
    if (rev) {
	return(revord16(crc));
    }
    else {
	return(crc);
    }
}
#endif /* BLOCKCALC */


#ifdef MAIN
/*
 *  MAIN ƤȤϡɸϤ CRC׻ץब
 *  롣(δؿΥåѤΥץ)
 *
 *  ˡ: crc [-i ] [-r]
 *	-i     CRCνͤꤹ
 *	-j     CRCνͤꤹ, ͤȽͤʤ׻
 *	-r           ӥåȤʤӤȿž CRC׻
 */
#define shift --argc; ++argv

int main(int argc, char *argv[])
{
    int ch;
    int rev;
    int dualmode = NO;
    unsigned int len = 0;
    unsigned short crc, crc2;
    char *prog;

    prog = *argv;
    shift;
    crc = crc2 = 0;
    rev = NO;
    while ((argc > 0) && (argv[0][0] == '-')) {
	if (argv[0][1] == 'i') {
	    shift;
	    crc = atoi(*argv);
	}
	if (argv[0][1] == 'j') {
	    shift;
	    crc = atoi(*argv);
	    dualmode = !dualmode;
	}
	else if (argv[0][1] == 'r') {
	    rev = !rev;
	}
	else {
	    fprintf(stderr, "Usage: %s [-i initial_value] [-r]\n", prog);
	    exit(1);
	}
	shift;
    }
    if (argc > 0) {
	fprintf(stderr, "Usage: %s [-[i|j] initial_value] [-r]\n", prog);
	exit(1);
    }
    tblini();
    while ((ch = getchar()) != EOF) {
	++len;
	crc = crc16c(crc, ch, rev);
	if (dualmode) {
	    crc2 =  crc16c(crc2, ch, rev);
	}
    }
    if (dualmode) {
	printf("%08x %04x ", len, crc);
    }
    printf("%04x\n", crc);
    exit(0);
}
#endif

/* Local Variables: */
/* compile-command:"cc -DMAIN -o crc crc.c" */
/* End: */
